package net.shrine.utilities.batchquerier

import java.io.File
import net.shrine.protocol.AuthenticationInfo
import com.typesafe.config.Config
import com.typesafe.config.ConfigException
import net.shrine.protocol.Credential

/**
 * @author clint
 * @date Sep 6, 2013
 */
final case class BatchQuerierConfig(
    expressionFile: File,
    shrineUrl: String,
    authorization: AuthenticationInfo,
    outputFile: File,
    projectId: String,
    topicId: String)
    
object BatchQuerierConfig {
  def apply(config: Config): BatchQuerierConfig = {
    def file(path: String) = (new File(path)).getCanonicalFile
    
    import Keys._
    
    def getAuthInfo(subConfig: Config): AuthenticationInfo = {
      def string(path: String) = subConfig.getString(path)
      
      def requirePath(path: String) = if (!subConfig.hasPath(path)) throw new ConfigException.Missing(s"Expected to find '$path' in $subConfig")

      requirePath(domain)
      requirePath(username)
      requirePath(password)
      
      AuthenticationInfo(string(domain), string(username), Credential(string(password), false))
    }
    
    def string(path: String) = config.getString(path)
    
    BatchQuerierConfig(
        file(string(inputFile)),
        string(shrineUrl),
        getAuthInfo(config.getConfig(credentials)),
        file(string(outputFile)),
        string(projectId),
        string(topicId))
  }
  
  //TODO: Factor out code shared with Scanner
  object Keys {
    val domain = "domain"
    val username = "username"
    val password = "password"

    private def subKey(k: String) = s"batch.$k"
    
    val inputFile = subKey("inputFile")
    val outputFile = subKey("outputFile")
    val shrineUrl = subKey("shrineUrl")
    val credentials = subKey("credentials")
    val projectId = subKey("projectId")
    val topicId = subKey("topicId")
  }
}