package net.shrine.utilities.batchquerier.commands

import net.shrine.utilities.commands.>>>
import net.shrine.utilities.batchquerier.BatchQueryResult
import net.shrine.protocol.query.QueryDefinition
import net.shrine.utilities.batchquerier.BatchQuerier
import net.shrine.protocol.AggregatedRunQueryResponse
import net.shrine.utilities.batchquerier.BatchQueryResult
import net.shrine.utilities.batchquerier.BatchQueryResults

/**
 * @author clint
 * @date Sep 20, 2013
 */
final case class QueryWith(querier: BatchQuerier) extends (Iterable[QueryDefinition] >>> Iterable[BatchQueryResult]) {
  def apply(queryDefs: Iterable[QueryDefinition]): Iterable[BatchQueryResult] = {
    def toBatchQueryResult(response: AggregatedRunQueryResponse): Iterable[BatchQueryResult] = {
      BatchQueryResults.fromAggregatedRunQueryResponse(response)
    }
    
    querier.query(queryDefs).flatMap(toBatchQueryResult) 
  }
}