/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration;

import java.io.Reader;
import java.io.Writer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.Util;
import org.spin.tools.config.Module;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.config.migration.MigrationException;
import org.spin.tools.config.migration.Migrator;
import org.spin.tools.config.migration.Transition;
import org.spin.tools.config.migration.Version;

public final class ConfigFileType
extends Enum<ConfigFileType> {
    public static final /* enum */ ConfigFileType RoutingTable = new ConfigFileType(Module.routingtable, ConfigFileType.makeRoutingTableImplementationMap(), ConfigFileType.makeRoutingTableMigrationMap());
    public final Module module;
    private final Map<Version, Class<?>> implementations;
    private final Map<Transition, Migrator<?, ?>> migrations;
    private static final /* synthetic */ ConfigFileType[] $VALUES;

    public static ConfigFileType[] values() {
        return (ConfigFileType[])$VALUES.clone();
    }

    public static ConfigFileType valueOf(String name) {
        return Enum.valueOf(ConfigFileType.class, name);
    }

    private ConfigFileType(Module module, Map<Version, Class<?>> implementations, Map<Transition, Migrator<?, ?>> migrations) {
        assert (module != null);
        assert (implementations != null);
        assert (migrations != null);
        this.module = module;
        this.implementations = implementations;
        this.migrations = migrations;
    }

    public static final ConfigFileType of(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name passed in");
        }
        if (Module.routingtable.name().equalsIgnoreCase(name)) {
            return RoutingTable;
        }
        throw new IllegalArgumentException("Unknown config file type '" + name + "'");
    }

    public <Src, Dst> void migrate(Reader reader, Transition transition, Writer writer) throws MigrationException {
        assert (writer != null);
        Dst result = this.migrate((Src)reader, transition);
        try {
            JAXBUtils.marshalToWriter(result, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new MigrationException("Couldn't marshall results: ", e);
        }
    }

    public <Src, Dst> Dst migrate(Reader reader, Transition transition) throws MigrationException {
        assert (reader != null);
        assert (transition != null);
        return this.migrate(this.load(reader, this.getImplementationClass(transition.from)), transition);
    }

    public <Src, Dst> Dst migrate(Src src, Transition transition) throws MigrationException {
        assert (transition != null);
        if (transition.isIdentity()) {
            return (Dst)src;
        }
        Migrator<Src, Dst> migrator = this.getMigrator(transition);
        return migrator.migrate(src);
    }

    private final <T> T load(Reader reader, Class<T> clazz) throws MigrationException {
        try {
            return (T)JAXBUtils.unmarshal((Reader)reader, clazz);
        }
        catch (JAXBException e) {
            throw new MigrationException("Couldn't load resource to be migrated: ", e);
        }
    }

    <Src, Dst> Migrator<Src, Dst> getMigrator(Transition transition) throws MigrationException {
        if (this.migrations.containsKey(transition)) {
            return this.migrations.get(transition);
        }
        throw new MigrationException("Can't migrate " + (Object)((Object)this.module) + " from version " + (Object)((Object)transition.from) + " to version " + (Object)((Object)transition.to));
    }

    public Class<?> getImplementationClass(Version version) throws MigrationException {
        if (this.implementations.containsKey((Object)version)) {
            return this.implementations.get((Object)version);
        }
        throw new MigrationException("Unknown version: '" + (Object)((Object)version) + "'");
    }

    public Set<Version> getKnownVersions() {
        return Util.asSet(this.implementations.keySet());
    }

    private static final Map<Version, Class<?>> makeRoutingTableImplementationMap() {
        EnumMap result = Util.makeEnumMap(Version.class);
        result.put(Version.OneNinePlus, RoutingTableConfig.class);
        return result;
    }

    private static final Map<Transition, Migrator<?, ?>> makeRoutingTableMigrationMap() {
        HashMap result = Util.makeHashMap();
        return result;
    }

    static {
        $VALUES = new ConfigFileType[]{RoutingTable};
    }
}

