/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.InputStream;
import java.io.StringReader;
import org.specs2.control.Exceptions$;
import org.specs2.io.MockFileSystem;
import org.specs2.xml.Nodex$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.parsing.XhtmlParser$;

public abstract class MockFileSystem$class {
    public static IndexedSeq readLines(MockFileSystem $this, String path) {
        return Predef$.MODULE$.refArrayOps((Object[])$this.readFile(path).split("\n")).toIndexedSeq();
    }

    public static String readFile(MockFileSystem $this, String path) {
        return (String)$this.files().apply((Object)path);
    }

    public static List filePaths(MockFileSystem $this, String basePath, String path, boolean verbose) {
        return $this.files().keySet().toList();
    }

    public static String filePaths$default$1(MockFileSystem $this) {
        return ".";
    }

    public static String filePaths$default$2(MockFileSystem $this) {
        return "*";
    }

    public static boolean filePaths$default$3(MockFileSystem $this) {
        return false;
    }

    public static void addFile(MockFileSystem $this, String content2) {
        $this.addFile($this.defaultFilePath(), content2);
    }

    public static void addFile(MockFileSystem $this, String path, String content2) {
        $this.files().$plus$eq(Predef.Pair$.MODULE$.apply((Object)path, (Object)content2));
        $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
    }

    public static void addChild(MockFileSystem $this, String parent, String child) {
        Option option;
        block4: {
            block3: {
                BoxedUnit boxedUnit;
                block2: {
                    Some x2;
                    option = $this.children().get((Object)parent);
                    if (!(option instanceof Some) || (x2 = (Some)option) == null) break block2;
                    ListBuffer l = (ListBuffer)x2.x();
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                Option x3 = option;
                boxedUnit = $this.children().put((Object)parent, (Object)new ListBuffer());
            }
            ((ListBuffer)$this.children().get((Object)parent).get()).$plus$eq((Object)child);
            return;
        }
        throw new MatchError((Object)option);
    }

    public static String setReadable(MockFileSystem $this, String path) {
        if (!$this.canRead(path)) {
            $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        }
        return path;
    }

    public static String setWritable(MockFileSystem $this, String path) {
        if (!$this.canWrite(path)) {
            $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
        }
        return path;
    }

    public static String setNotReadable(MockFileSystem $this, String path) {
        $this.readableFiles_$eq((List<String>)((List)$this.readableFiles().filterNot((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = this.path$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.path$1 = path$1;
            }
        })));
        return path;
    }

    public static String setNotWritable(MockFileSystem $this, String path) {
        $this.writableFiles_$eq((List<String>)((List)$this.writableFiles().filterNot((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final String path$2;

            public final boolean apply(String x$2) {
                String string = x$2;
                String string2 = this.path$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.path$2 = path$2;
            }
        })));
        return path;
    }

    public static boolean canRead(MockFileSystem $this, String path) {
        return $this.readableFiles().exists((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final String path$3;

            public final boolean apply(String x$3) {
                String string = x$3;
                String string2 = this.path$3;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.path$3 = path$3;
            }
        });
    }

    public static boolean canWrite(MockFileSystem $this, String path) {
        return $this.writableFiles().exists((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final String path$4;

            public final boolean apply(String x$4) {
                String string = x$4;
                String string2 = this.path$4;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.path$4 = path$4;
            }
        });
    }

    public static boolean isAbsolute(MockFileSystem $this, String path) {
        return path.startsWith("/") || path.startsWith("\\");
    }

    public static boolean isHidden(MockFileSystem $this, String path) {
        return path.startsWith(".");
    }

    public static boolean isFile(MockFileSystem $this, String path) {
        return path.matches(".*\\..*");
    }

    public static boolean isDirectory(MockFileSystem $this, String path) {
        return !$this.isFile(path);
    }

    public static List listFiles(MockFileSystem $this, String path) {
        return (List)$this.children().get((Object)path.replaceAll("\\\\", "/")).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(ListBuffer<String> x$5) {
                return x$5.toList();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
    }

    public static String defaultFilePath(MockFileSystem $this) {
        return new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)$this.files().size())).append((Object)$this.defaultExtension()).toString();
    }

    public static boolean createFile(MockFileSystem $this, String path) {
        $this.files().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)path), (Object)""));
        return true;
    }

    public static boolean delete(MockFileSystem $this, String path) {
        $this.files().$minus$eq((Object)path);
        return true;
    }

    public static boolean mkdirs(MockFileSystem $this, String path) {
        String string = path;
        $this.createdDirs_$eq((List<String>)$this.createdDirs().$colon$colon((Object)string));
        return true;
    }

    public static boolean createDir(MockFileSystem $this, String path) {
        return $this.mkdirs(path);
    }

    public static MockFileSystem.MockFileWriter getWriter(MockFileSystem $this, String path, boolean append2) {
        return new MockFileSystem.MockFileWriter($this, path);
    }

    public static boolean getWriter$default$2(MockFileSystem $this) {
        return false;
    }

    public static MockFileSystem reset(MockFileSystem $this) {
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
        return $this;
    }

    public static boolean exists(MockFileSystem $this, String path) {
        return $this.files().keys().exists((Function1)new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MockFileSystem $outer;
            private final String path$5;

            public final boolean apply(String f) {
                return this.$outer.samePath(f, this.path$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$5 = path$5;
            }
        });
    }

    public static InputStream inputStream(MockFileSystem $this, String filePath) {
        return new InputStream($this, filePath){
            private final StringReader reader;

            private StringReader reader() {
                return this.reader;
            }

            public int read() {
                return this.reader().read();
            }
            {
                this.reader = new StringReader($outer.readFile(filePath$1));
            }
        };
    }

    public static NodeSeq loadXmlFile(MockFileSystem $this, String filePath, Function1 report2) {
        return (NodeSeq)Exceptions$.MODULE$.tryo(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MockFileSystem $outer;
            private final String filePath$2;

            public final NodeSeq apply() {
                Source xhtml = Source$.MODULE$.fromString(new StringBuilder().append((Object)"<e>").append((Object)this.$outer.readFile(this.filePath$2)).append((Object)"</e>").toString());
                return Nodex$.MODULE$.reducable((Seq<NodeSeq>)XhtmlParser$.MODULE$.apply(xhtml).$bslash$bslash("e").apply(0).child()).reduceNodes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.filePath$2 = filePath$2;
            }
        }, (Function1<Exception, BoxedUnit>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Object t2) {
                Exceptions$.MODULE$.implicitUnit(t2);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSeq apply() {
                return NodeSeq$.MODULE$.Empty();
            }
        });
    }

    public static Function1 loadXmlFile$default$2(MockFileSystem $this, String filePath) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Exception e) {
                e.printStackTrace();
            }
        };
    }

    public static void $init$(MockFileSystem $this) {
        $this.defaultExtension_$eq("");
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.createdDirs_$eq((List<String>)Nil$.MODULE$);
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
    }
}

