/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.dao.hibernate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import net.shrine.broadcaster.dao.AuditDAO;
import net.shrine.broadcaster.dao.hibernate.AuditEntry;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateAuditDAO
implements AuditDAO {
    @Resource
    SessionFactory sessionFactory;

    @Override
    public void addAuditEntry(AuditEntry auditEntry) {
        Session s = this.sessionFactory.getCurrentSession();
        s.saveOrUpdate((Object)auditEntry);
    }

    @Override
    public void addAllAuditEntry(List<AuditEntry> entries) {
        Session s = this.sessionFactory.getCurrentSession();
        for (AuditEntry e : entries) {
            s.saveOrUpdate((Object)e);
        }
    }

    @Override
    public List<AuditEntry> getEntriesAfter(Date after) {
        Session s = this.sessionFactory.getCurrentSession();
        Query q = s.createQuery("from AuditEntry e where e.time > :after");
        q.setDate("after", after);
        ArrayList returnList = new ArrayList();
        return q.list();
    }

    @Override
    public AuditEntry findAuditEntryById(Integer auditEntryId) {
        Session s = this.sessionFactory.getCurrentSession();
        Query q = s.createQuery("from AuditEntry e where e.auditEntryId = :id");
        q.setParameter("id", (Object)auditEntryId);
        AuditEntry entry = (AuditEntry)q.uniqueResult();
        return entry;
    }

    @Override
    public List<AuditEntry> getEntriesBetween(Date start, Date end) {
        Session s = this.sessionFactory.getCurrentSession();
        Query q = s.createQuery("from AuditEntry e where e.time between :start and :end");
        q.setDate("start", start);
        q.setDate("end", end);
        return q.list();
    }
}

