/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.service;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import net.shrine.authorization.AuthorizationService;
import net.shrine.broadcaster.aggregators.GenericAggregator;
import net.shrine.broadcaster.aggregators.PDOAggregator;
import net.shrine.broadcaster.aggregators.PatientSetAggregator;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.dao.AuditDAO;
import net.shrine.broadcaster.dao.hibernate.AuditEntry;
import net.shrine.config.ShrineConfig;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.BroadcastMessage;
import net.shrine.protocol.DeleteQueryRequest;
import net.shrine.protocol.ReadApprovedQueryTopicsRequest;
import net.shrine.protocol.ReadInstanceResultsRequest;
import net.shrine.protocol.ReadPdoRequest;
import net.shrine.protocol.ReadPreviousQueriesRequest;
import net.shrine.protocol.ReadQueryDefinitionRequest;
import net.shrine.protocol.ReadQueryInstancesRequest;
import net.shrine.protocol.RenameQueryRequest;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.protocol.ShrineRequest;
import net.shrine.protocol.ShrineRequestHandler;
import net.shrine.protocol.ShrineResponse;
import net.shrine.protocol.ShrineResponse$;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.service.ShrineService$;
import org.apache.log4j.MDC;
import org.spin.node.acknack.AckNack;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.SpinAgent;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.serializer.BasicSerializer;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.signature.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import scala.xml.NodeSeq;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ScalaSignature(bytes="\u0006\u0001\t5h\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u001bMC'/\u001b8f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011AB:ie&tWMC\u0001\b\u0003\rqW\r^\u0002\u0001'\u0011\u0001!B\u0005\r\u0011\u0005-\u0001R\"\u0001\u0007\u000b\u00055q\u0011\u0001\u00027b]\u001eT\u0011aD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0012\u0019\t1qJ\u00196fGR\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0011A\u0014x\u000e^8d_2L!a\u0006\u000b\u0003)MC'/\u001b8f%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011}\u0001!Q1A\u0005\n\u0001\n\u0001\"Y;eSR$\u0015m\\\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0004I\u0006|'B\u0001\u0014\u0005\u0003-\u0011'o\\1eG\u0006\u001cH/\u001a:\n\u0005!\u001a#\u0001C!vI&$H)Q(\t\u0011)\u0002!\u0011!Q\u0001\n\u0005\n\u0011\"Y;eSR$\u0015m\u001c\u0011\t\u00111\u0002!Q1A\u0005\n5\nA#Y;uQ>\u0014\u0018N_1uS>t7+\u001a:wS\u000e,W#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011!D1vi\"|'/\u001b>bi&|g.\u0003\u00024a\t!\u0012)\u001e;i_JL'0\u0019;j_:\u001cVM\u001d<jG\u0016D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0016CV$\bn\u001c:ju\u0006$\u0018n\u001c8TKJ4\u0018nY3!\u0011!9\u0004A!b\u0001\n\u0013A\u0014aD5eK:$\u0018\u000e^=TKJ4\u0018nY3\u0016\u0003e\u0002\"AO#\u000e\u0003mR!\u0001P\u001f\u0002\u0011%$WM\u001c;jifT!AP \u0002\u000f5,7o]1hK*\u0011\u0001)Q\u0001\u0006cV,'/\u001f\u0006\u0003\u0005\u000e\u000bAa\u001d9j]*\tA)A\u0002pe\u001eL!AR\u001e\u0003\u001f%#WM\u001c;jif\u001cVM\u001d<jG\u0016D\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0011S\u0012,g\u000e^5usN+'O^5dK\u0002B\u0001B\u0013\u0001\u0003\u0006\u0004%IaS\u0001\rg\"\u0014\u0018N\\3D_:4\u0017nZ\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nB\u0001\u0007G>tg-[4\n\u0005Es%\u0001D*ie&tWmQ8oM&<\u0007\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u001bMD'/\u001b8f\u0007>tg-[4!\u0011!)\u0006A!b\u0001\n\u00131\u0016AC:qS:\u001cE.[3oiV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[{\u0005)\u0011mZ3oi&\u0011A,\u0017\u0002\n'BLg.Q4f]RD\u0001B\u0018\u0001\u0003\u0002\u0003\u0006IaV\u0001\fgBLgn\u00117jK:$\b\u0005C\u0003a\u0001\u0011\u0005\u0011-\u0001\u0004=S:LGO\u0010\u000b\u0007E\u0012,gm\u001a5\u0011\u0005\r\u0004Q\"\u0001\u0002\t\u000b}y\u0006\u0019A\u0011\t\u000b1z\u0006\u0019\u0001\u0018\t\u000b]z\u0006\u0019A\u001d\t\u000b){\u0006\u0019\u0001'\t\u000bU{\u0006\u0019A,)\u0005}S\u0007CA6u\u001b\u0005a'BA7o\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003_B\fqAZ1di>\u0014\u0018P\u0003\u0002re\u0006)!-Z1og*\u00111oQ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011Q\u000f\u001c\u0002\n\u0003V$xn^5sK\u0012D\u0001b\u001e\u0001\t\u0006\u0004%I\u0001_\u0001\u000fK:$\u0007o\\5oi\u000e{gNZ5h+\u0005I\bC\u0001>\u007f\u001b\u0005Y(BA(}\u0015\ti\u0018)A\u0003u_>d7/\u0003\u0002\u0000w\nqQI\u001c3q_&tGoQ8oM&<\u0007\"CA\u0002\u0001!\u0005\t\u0015)\u0003z\u0003=)g\u000e\u001a9pS:$8i\u001c8gS\u001e\u0004\u0003\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0003\u0019\u0011\u0018M\u001c3p[V\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u000e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\tyA\u0001\u0004SC:$w.\u001c\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\f\u00059!/\u00198e_6\u0004\u0003bBA\u000f\u0001\u0011%\u0011qD\u0001\u0011g\"\u0014\u0018N\\3SKN\u0004xN\\:f\u001f\u001a$B!!\t\u0002(A\u00191#a\t\n\u0007\u0005\u0015BC\u0001\bTQJLg.\u001a*fgB|gn]3\t\u0011\u0005%\u00121\u0004a\u0001\u0003W\t1C]3ta>t7/Z'fgN\fw-\u001a+za\u0016\u0004B!!\f\u0002H5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0006je\t\u0014T.Z:tC\u001e,'\u0002BA\u001b\u0003o\ta\u0001Z1uCZ|'\u0002BA\u001d\u0003w\t1a\u0019:d\u0015\u0011\ti$a\u0010\u0002\t%\u0014$M\r\u0006\u0005\u0003\u0003\n\u0019%A\u0004iCJ4\u0018M\u001d3\u000b\u0005\u0005\u0015\u0013aA3ek&!\u0011\u0011JA\u0018\u0005M\u0011Vm\u001d9p]N,W*Z:tC\u001e,G+\u001f9f\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f\nA\"\u001b\u001ace=\u0013'.Z2u\u001f\u001a$B!!\u0015\u0002XA!\u0011QFA*\u0013\u0011\t)&a\f\u0003%I+\u0017/^3ti6+7o]1hKRK\b/\u001a\u0005\t\u00033\nY\u00051\u0001\u0002\\\u00059!/Z9vKN$\bcA\n\u0002^%\u0019\u0011q\f\u000b\u0003\u001bMC'/\u001b8f%\u0016\fX/Z:u\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\n\u0001cZ3oKJ\fG/Z%eK:$\u0018\u000e^=\u0015\t\u0005\u001d\u0014q\u000f\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%\u0019\u0018n\u001a8biV\u0014XMC\u0002\u0002rq\faa\u0019:zaR|\u0017\u0002BA;\u0003W\u0012\u0001\"\u00133f]RLG/\u001f\u0005\t\u0003s\n\t\u00071\u0001\u0002|\u0005)\u0011-\u001e;i]B\u00191#! \n\u0007\u0005}DC\u0001\nBkRDWM\u001c;jG\u0006$\u0018n\u001c8J]\u001a|\u0007\u0002CAB\u0001\u0011\u0005!!!\"\u0002%\u0011,G/\u001a:nS:,\u0007+Z3sOJ|W\u000f\u001d\u000b\u0005\u0003\u000f\u000bi\tE\u0002\f\u0003\u0013K1!a#\r\u0005\u0019\u0019FO]5oO\"A\u0011qRAA\u0001\u0004\t9)A\u0005qe>TWm\u0019;JI\"9\u00111\u0013\u0001\u0005\n\u0005U\u0015aF:ie&tW-T3tg\u0006<WmU3sS\u0006d\u0017N_3s+\t\t9\nE\u0003\u0002\u001a\u0006}%\"\u0004\u0002\u0002\u001c*\u0019\u0011QT\u001f\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002\"\u0006m%a\u0004\"bg&\u001c7+\u001a:jC2L'0\u001a:\t\u0011\u0005\u0015\u0006\u0001\"\u0001\u0003\u0003O\u000b\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;NKN\u001c\u0018mZ3\u0015\r\u0005%\u0016\u0011XAa!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000bq!Y2l]\u0006\u001c7NC\u0002\u00024\u0006\u000bAA\\8eK&!\u0011qWAW\u0005\u001d\t5m\u001b(bG.DqAPAR\u0001\u0004\tY\fE\u0002\u0014\u0003{K1!a0\u0015\u0005A\u0011%o\\1eG\u0006\u001cH/T3tg\u0006<W\r\u0003\u0005\u0002D\u0006\r\u0006\u0019AAc\u0003%\tX/\u001a:z\u0013:4w\u000e\u0005\u0003\u0002H\u00065WBAAe\u0015\r\tY-P\u0001\bQ\u0016\fG-\u001a:t\u0013\u0011\ty-!3\u0003\u0013E+XM]=J]\u001a|\u0007bBAj\u0001\u0011%\u0011Q[\u0001\u000fO\u0016$8\u000b]5o%\u0016\u001cX\u000f\u001c;t)\u0019\t9.!8\u0002bB!\u0011qYAm\u0013\u0011\tY.!3\u0003\u0013I+7/\u001e7u'\u0016$\b\u0002CAp\u0003#\u0004\r!a\"\u0002\u000fE,XM]=J\t\"9A(!5A\u0002\u0005\u001d\u0004bBAs\u0001\u0011%\u0011q]\u0001\u0011[\u0006\\Wm\u00155sS:,\u0007*Z1eKJ$B!!;\u0002vB!\u00111^Ay\u001b\t\tiOC\u0002\u0002p\u0012\t1b]3sS\u0006d\u0017N_3sg&!\u00111_Aw\u00051\u0019\u0006N]5oK\"+\u0017\rZ3s\u0011\u001dq\u00141\u001da\u0001\u0003wCq!!?\u0001\t\u0013\tY0A\u0005bO\u001e\u0014XmZ1uKRQ\u0011\u0011EA\u007f\u0003\u007f\u0014\u0019A!\u0002\t\u000fy\n9\u00101\u0001\u0002<\"A!\u0011AA|\u0001\u0004\t9)A\u0004rk\u0016\u0014\u00180\u00133\t\u000fq\n9\u00101\u0001\u0002h!A!qAA|\u0001\u0004\u0011I!\u0001\u0006bO\u001e\u0014XmZ1u_J\u0004BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001f)\u0013aC1hOJ,w-\u0019;peNLAAa\u0005\u0003\u000e\t12\u000b\u001b:j]\u0016\u0014Vm];mi\u0006;wM]3hCR|'\u000fC\u0004\u0003\u0018\u0001!IA!\u0007\u0002\u001d\u0015DXmY;uKJ+\u0017/^3tiRA\u0011\u0011\u0005B\u000e\u0005;\u0011y\u0002C\u0004=\u0005+\u0001\r!a\u001a\t\u000fy\u0012)\u00021\u0001\u0002<\"A!q\u0001B\u000b\u0001\u0004\u0011I\u0001C\u0004\u0003\u0018\u0001!IAa\t\u0015\r\u0005\u0005\"Q\u0005B\u0014\u0011!\tIF!\tA\u0002\u0005m\u0003\u0002\u0003B\u0004\u0005C\u0001\rA!\u0003\t\u000f\t-\u0002\u0001\"\u0003\u0003.\u0005)An\\4JIV\u0011!q\u0006\t\u00043\tE\u0012b\u0001B\u001a5\t!Aj\u001c8h\u0011\u001d\u00119\u0004\u0001C\u0005\u0005[\t\u0001B]1oI>l\u0017\n\u001a\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0003a\u0019wN\\:ueV\u001cGOU;o#V,'/_'fgN\fw-\u001a\u000b\u0005\u0003w\u0013y\u0004\u0003\u0005\u0002Z\te\u0002\u0019\u0001B!!\r\u0019\"1I\u0005\u0004\u0005\u000b\"\"a\u0004*v]F+XM]=SKF,Xm\u001d;\t\u000f\t%\u0003\u0001\"\u0003\u0003L\u0005!\u0012-\u001e3jiJ+h.U;fef\u0014V-];fgR$bA!\u0014\u0003T\tU\u0003cA\r\u0003P%\u0019!\u0011\u000b\u000e\u0003\tUs\u0017\u000e\u001e\u0005\by\t\u001d\u0003\u0019AA4\u0011!\tIFa\u0012A\u0002\t\u0005\u0003b\u0002B-\u0001\u0011\u0005!1L\u0001\teVt\u0017+^3ssR!\u0011\u0011\u0005B/\u0011!\tIFa\u0016A\u0002\t\u0005\u0003\u0006\u0002B,\u0005C\u0002BAa\u0019\u0003l5\u0011!Q\r\u0006\u0004[\n\u001d$b\u0001B5e\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\u0011iG!\u001a\u0003\u001bQ\u0013\u0018M\\:bGRLwN\\1m\u0011\u001d\u0011\t\b\u0001C\u0001\u0005g\n1C]3bIF+XM]=EK\u001aLg.\u001b;j_:$B!!\t\u0003v!A\u0011\u0011\fB8\u0001\u0004\u00119\bE\u0002\u0014\u0005sJ1Aa\u001f\u0015\u0005i\u0011V-\u00193Rk\u0016\u0014\u0018\u0010R3gS:LG/[8o%\u0016\fX/Z:u\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003\u000bqA]3bIB#w\u000e\u0006\u0003\u0002\"\t\r\u0005\u0002CA-\u0005{\u0002\rA!\"\u0011\u0007M\u00119)C\u0002\u0003\nR\u0011aBU3bIB#wNU3rk\u0016\u001cH\u000fC\u0004\u0003\u000e\u0002!\tAa$\u0002'I,\u0017\rZ%ogR\fgnY3SKN,H\u000e^:\u0015\t\u0005\u0005\"\u0011\u0013\u0005\t\u00033\u0012Y\t1\u0001\u0003\u0014B\u00191C!&\n\u0007\t]EC\u0001\u000eSK\u0006$\u0017J\\:uC:\u001cWMU3tk2$8OU3rk\u0016\u001cH\u000fC\u0004\u0003\u001c\u0002!\tA!(\u0002%I,\u0017\rZ)vKJL\u0018J\\:uC:\u001cWm\u001d\u000b\u0005\u0003C\u0011y\n\u0003\u0005\u0002Z\te\u0005\u0019\u0001BQ!\r\u0019\"1U\u0005\u0004\u0005K#\"!\u0007*fC\u0012\fV/\u001a:z\u0013:\u001cH/\u00198dKN\u0014V-];fgRDqA!+\u0001\t\u0003\u0011Y+A\nsK\u0006$\u0007K]3wS>,8/U;fe&,7\u000f\u0006\u0003\u0002\"\t5\u0006\u0002CA-\u0005O\u0003\rAa,\u0011\u0007M\u0011\t,C\u0002\u00034R\u0011!DU3bIB\u0013XM^5pkN\fV/\u001a:jKN\u0014V-];fgRDqAa.\u0001\t\u0003\u0011I,A\u0006sK:\fW.Z)vKJLH\u0003BA\u0011\u0005wC\u0001\"!\u0017\u00036\u0002\u0007!Q\u0018\t\u0004'\t}\u0016b\u0001Ba)\t\u0011\"+\u001a8b[\u0016\fV/\u001a:z%\u0016\fX/Z:u\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u000f\f1\u0002Z3mKR,\u0017+^3ssR!\u0011\u0011\u0005Be\u0011!\tIFa1A\u0002\t-\u0007cA\n\u0003N&\u0019!q\u001a\u000b\u0003%\u0011+G.\u001a;f#V,'/\u001f*fcV,7\u000f\u001e\u0005\b\u0005'\u0004A\u0011\u0001Bk\u0003]\u0011X-\u00193BaB\u0014xN^3e#V,'/\u001f+pa&\u001c7\u000f\u0006\u0003\u0002\"\t]\u0007\u0002CA-\u0005#\u0004\rA!7\u0011\u0007M\u0011Y.C\u0002\u0003^R\u0011aDU3bI\u0006\u0003\bO]8wK\u0012\fV/\u001a:z)>\u0004\u0018nY:SKF,Xm\u001d;)\u0007\u0001\u0011\t\u000f\u0005\u0003\u0003d\n%XB\u0001Bs\u0015\r\u00119O]\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002Bv\u0005K\u0014qaU3sm&\u001cW\r")
public class ShrineService
implements ShrineRequestHandler,
ScalaObject {
    private final AuditDAO auditDao;
    private final AuthorizationService authorizationService;
    private final IdentityService identityService;
    private final ShrineConfig shrineConfig;
    private final SpinAgent spinClient;
    private EndpointConfig endpointConfig;
    private final Random random;
    public volatile int bitmap$0;

    private AuditDAO auditDao() {
        return this.auditDao;
    }

    private AuthorizationService authorizationService() {
        return this.authorizationService;
    }

    private IdentityService identityService() {
        return this.identityService;
    }

    private ShrineConfig shrineConfig() {
        return this.shrineConfig;
    }

    private SpinAgent spinClient() {
        return this.spinClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EndpointConfig endpointConfig() {
        if ((this.bitmap$0 & 1) != 0) return this.endpointConfig;
        ShrineService shrineService = this;
        synchronized (shrineService) {
            if ((this.bitmap$0 & 1) == 0) {
                this.endpointConfig = new EndpointConfig(EndpointType.SOAP, this.shrineConfig().getAggregatorEndpoint());
                this.bitmap$0 |= 1;
            }
            return this.endpointConfig;
        }
    }

    private Random random() {
        return this.random;
    }

    private ShrineResponse shrineResponseOf(ResponseMessageType responseMessageType) {
        String xmlString = HiveCommonSerializer.toXMLString((ResponseMessageType)responseMessageType);
        return ShrineResponse$.MODULE$.apply((NodeSeq)XML$.MODULE$.loadString(xmlString));
    }

    private RequestMessageType i2b2ObjectOf(ShrineRequest request) {
        return HiveCommonSerializer.getRequest((String)request.toI2b2().toString());
    }

    private Identity generateIdentity(AuthenticationInfo authn) {
        return this.identityService().certify(authn.domain(), authn.username(), authn.credential().value());
    }

    public String determinePeergroup(String projectId) {
        return this.shrineConfig().getBroadcasterPeerGroupToQuery() == null ? projectId : this.shrineConfig().getBroadcasterPeerGroupToQuery();
    }

    private BasicSerializer<Object> shrineMessageSerializer() {
        return new $anon$1(this);
    }

    /*
     * WARNING - void declaration
     */
    public AckNack broadcastMessage(BroadcastMessage message, QueryInfo queryInfo) {
        void var3_3;
        AckNack ackNack = this.spinClient().send(queryInfo, (Object)message, this.shrineMessageSerializer());
        if (ackNack.isError()) {
            throw new AgentException("Error encountered during query.");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ResultSet getSpinResults(String queryID, Identity identity) {
        void var3_3;
        ResultSet exceptionResult1 = null;
        try {
            exceptionResult1 = this.spinClient().receive(queryID, identity);
        }
        catch (TimeoutException timeoutException) {
            exceptionResult1 = this.spinClient().getResult(queryID, identity);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ShrineHeader makeShrineHeader(BroadcastMessage message) {
        void var2_2;
        ShrineHeader header = new ShrineHeader();
        header.putHeader("qmid", message.masterId().orNull(Predef$.MODULE$.conforms()));
        header.putHeader("qiid", message.instanceId().orNull(Predef$.MODULE$.conforms()));
        header.putHeader("qrids", message.resultIds().orNull(Predef$.MODULE$.conforms()));
        return var2_2;
    }

    private ShrineResponse aggregate(BroadcastMessage message, String queryId, Identity identity, ShrineResultAggregator aggregator) {
        ResultSet spinResults = this.getSpinResults(queryId, identity);
        Iterable spinResultEntries = (Iterable)JavaConversions$.MODULE$.asScalaIterable((java.lang.Iterable)spinResults).map((Function1)new $anonfun$2(this), Iterable$.MODULE$.canBuildFrom());
        ResponseMessageType responseMessageType = aggregator.aggregate(null, JavaConversions$.MODULE$.asJavaCollection(spinResultEntries), this.i2b2ObjectOf(message.request()), this.makeShrineHeader(message));
        return this.shrineResponseOf(responseMessageType);
    }

    private ShrineResponse executeRequest(Identity identity, BroadcastMessage message, ShrineResultAggregator aggregator) {
        AckNack ackNack = this.broadcastMessage(message, new QueryInfo(this.determinePeergroup(message.request().projectId()), identity, message.request().requestType().name(), this.endpointConfig()));
        return this.aggregate(message, ackNack.getQueryID(), identity, aggregator);
    }

    private ShrineResponse executeRequest(ShrineRequest request, ShrineResultAggregator aggregator) {
        return this.executeRequest(this.generateIdentity(request.authn()), new BroadcastMessage(this.logId(), request), aggregator);
    }

    private long logId() {
        return BoxesRunTime.unboxToLong((Object)MDC.get((String)"globalRequestId"));
    }

    public final long net$shrine$service$ShrineService$$randomId() {
        return package$.MODULE$.BigInt().apply(63, this.random()).abs().toLong();
    }

    private BroadcastMessage constructRunQueryMessage(RunQueryRequest request) {
        Seq resultIds = (Seq)Predef$.MODULE$.intWrapper(1).to(request.outputTypes().size()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        return new BroadcastMessage(this.logId(), this.net$shrine$service$ShrineService$$randomId(), this.net$shrine$service$ShrineService$$randomId(), resultIds, (ShrineRequest)request);
    }

    private void auditRunQueryRequest(Identity identity, RunQueryRequest request) {
        this.auditDao().addAuditEntry(new AuditEntry(request.projectId(), identity.getDomain(), identity.getUsername(), request.queryDefinitionXml(), request.topicId()));
    }

    @Transactional
    public ShrineResponse runQuery(RunQueryRequest request) {
        this.authorizationService().authorizeRequest(this.i2b2ObjectOf((ShrineRequest)request));
        Identity identity = this.generateIdentity(request.authn());
        this.auditRunQueryRequest(identity, request);
        return this.executeRequest(identity, this.constructRunQueryMessage(request), new PatientSetAggregator());
    }

    public ShrineResponse readQueryDefinition(ReadQueryDefinitionRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.GetRequestXmlResponseType);
    }

    public ShrineResponse readPdo(ReadPdoRequest request) {
        return this.executeRequest((ShrineRequest)request, new PDOAggregator());
    }

    public ShrineResponse readInstanceResults(ReadInstanceResultsRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.ResultResponseType);
    }

    public ShrineResponse readQueryInstances(ReadQueryInstancesRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.InstanceResponseType);
    }

    public ShrineResponse readPreviousQueries(ReadPreviousQueriesRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.UsersToMaster);
    }

    public ShrineResponse renameQuery(RenameQueryRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.MasterResponseType);
    }

    public ShrineResponse deleteQuery(DeleteQueryRequest request) {
        return this.executeRequest((ShrineRequest)request, GenericAggregator.MasterDeleteResponseType);
    }

    public ShrineResponse readApprovedQueryTopics(ReadApprovedQueryTopicsRequest request) {
        RequestMessageType requestMessageType = this.i2b2ObjectOf((ShrineRequest)request);
        ResponseMessageType approvedEntries = this.authorizationService().readApprovedEntries(requestMessageType);
        return this.shrineResponseOf(approvedEntries);
    }

    @Autowired
    public ShrineService(AuditDAO auditDao, AuthorizationService authorizationService, IdentityService identityService, ShrineConfig shrineConfig, SpinAgent spinClient) {
        this.auditDao = auditDao;
        this.authorizationService = authorizationService;
        this.identityService = identityService;
        this.shrineConfig = shrineConfig;
        this.spinClient = spinClient;
        this.random = new Random(System.currentTimeMillis());
    }
}

