/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.StatusType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

public abstract class AggregationStrategy<T> {
    private static final Logger log = Logger.getLogger(AggregationStrategy.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public final Class<T> resultClass;
    public static final AggregationStrategy<MasterResponseType> MasterResponseType = new AggregationStrategy<MasterResponseType>(MasterResponseType.class){

        @Override
        public void aggregate(MasterResponseType extra, MasterResponseType accumulator, SpinResultEntry originalSpinResult) {
            accumulator.getQueryMaster().addAll(extra.getQueryMaster());
        }

        @Override
        public ResponseMessageType packageInResponse(MasterResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            1.removeDupesFrom(toBeWrapped.getQueryMaster());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addMasterResponse((ResponseMessageType)response, (MasterResponseType)toBeWrapped);
            return response;
        }

        @Override
        public MasterResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getMasterResponse((ResponseMessageType)response);
        }
    };
    public static final AggregationStrategy<InstanceResponseType> InstanceResponseType = new AggregationStrategy<InstanceResponseType>(InstanceResponseType.class){

        @Override
        public void aggregate(InstanceResponseType extra, InstanceResponseType accumulator, SpinResultEntry originalSpinResult) {
            if (DEBUG) {
                log.debug((Object)("Adding " + extra.getQueryInstance() + " to accumulator: " + accumulator.getQueryInstance()));
            }
            accumulator.getQueryInstance().addAll(extra.getQueryInstance());
        }

        @Override
        public ResponseMessageType packageInResponse(InstanceResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            2.removeDupesFrom(toBeWrapped.getQueryInstance());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addInstanceResponse((ResponseMessageType)response, (InstanceResponseType)toBeWrapped);
            return response;
        }

        @Override
        public InstanceResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getInstanceResponse((ResponseMessageType)response);
        }
    };
    public static final AggregationStrategy<ResultResponseType> ResultResponseType = new AggregationStrategy<ResultResponseType>(ResultResponseType.class){

        @Override
        public void aggregate(ResultResponseType extra, ResultResponseType accumulator, SpinResultEntry originalSpinResult) {
            if (DEBUG) {
                log.debug((Object)("Adding " + extra.getQueryResultInstance() + " to accumulator: " + accumulator.getQueryResultInstance()));
            }
            List queryResultInstances = extra.getQueryResultInstance();
            for (QueryResultInstanceType queryResultInstance : queryResultInstances) {
                queryResultInstance.setDescription(originalSpinResult.getSpinResultMetadata().getDescription());
            }
            accumulator.getQueryResultInstance().addAll(queryResultInstances);
        }

        @Override
        public ResponseMessageType packageInResponse(ResultResponseType toBeWrapped) throws SerializationException {
            ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
            toBeWrapped.setStatus(AggregationStrategy.makeDoneStatus());
            CRCSerializer.addResultResponse((ResponseMessageType)response, (ResultResponseType)toBeWrapped);
            return response;
        }

        @Override
        public ResultResponseType extractFromResponse(ResponseMessageType response) throws SerializationException {
            return CRCSerializer.getResultResponse((ResponseMessageType)response);
        }
    };

    private static StatusType makeDoneStatus() {
        StatusType status = new StatusType();
        StatusType.Condition done = new StatusType.Condition();
        done.setType("DONE");
        done.setValue("DONE");
        status.getCondition().add(done);
        return status;
    }

    private AggregationStrategy(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public abstract void aggregate(T var1, T var2, SpinResultEntry var3);

    public abstract ResponseMessageType packageInResponse(T var1) throws SerializationException;

    public abstract T extractFromResponse(ResponseMessageType var1) throws SerializationException;

    static final <T> void removeDupesFrom(Collection<T> c) {
        Set unique = Util.asSet(c);
        c.clear();
        c.addAll(unique);
    }
}

