/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import java.io.StringReader;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.shrine.broadcaster.aggregators.AggregationStrategy;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.hive.HiveJaxbContext;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

public final class GenericAggregator<T>
implements ShrineResultAggregator {
    private static final Logger log = Logger.getLogger(GenericAggregator.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private final AggregationStrategy<T> strategy;
    public static final GenericAggregator<MasterResponseType> GetRequestXmlResponseType = GenericAggregator.instance(AggregationStrategy.MasterResponseType);
    public static final GenericAggregator<MasterResponseType> MasterDeleteResponseType = GenericAggregator.instance(AggregationStrategy.MasterResponseType);
    public static final GenericAggregator<MasterResponseType> MasterResponseType = GenericAggregator.instance(AggregationStrategy.MasterResponseType);
    public static final GenericAggregator<InstanceResponseType> InstanceResponseType = GenericAggregator.instance(AggregationStrategy.InstanceResponseType);
    public static final GenericAggregator<ResultResponseType> ResultResponseType = GenericAggregator.instance(AggregationStrategy.ResultResponseType);

    private GenericAggregator(AggregationStrategy<T> strategy) {
        this.strategy = strategy;
    }

    private static final <T> GenericAggregator<T> instance(AggregationStrategy<T> strategy) {
        Util.guardNotNull(strategy);
        return new GenericAggregator<T>(strategy);
    }

    @Override
    public ResponseMessageType aggregate(String queryID, Collection<SpinResultEntry> spinCacheResults, RequestMessageType request, ShrineHeader shrineHeader) throws SerializationException {
        T result = this.makeNewResult();
        if (DEBUG) {
            log.debug((Object)("Aggregating " + spinCacheResults.size() + " results from Spin"));
            log.debug((Object)("Expected payload type is " + this.strategy.resultClass.getSimpleName()));
        }
        for (SpinResultEntry spinResultEntry : spinCacheResults) {
            try {
                T resultFromOneNode = this.unmarshalResult(spinResultEntry);
                this.strategy.aggregate(resultFromOneNode, result, spinResultEntry);
            }
            catch (Exception e) {
                log.warn((Object)("Error aggregating response from " + spinResultEntry.getSpinResultMetadata().getOrigin()), (Throwable)e);
            }
        }
        ResponseMessageType response = this.strategy.packageInResponse(result);
        HiveCommonSerializer.addResponseHeaderWithDoneStatus((ResponseMessageType)response);
        return response;
    }

    private T makeNewResult() throws SerializationException {
        try {
            return this.strategy.resultClass.newInstance();
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    T unmarshalResult(SpinResultEntry spinResultEntry) throws Exception {
        if (DEBUG) {
            log.debug((Object)("Spin result XML: from " + spinResultEntry.getSpinResultMetadata().getOrigin() + ": " + spinResultEntry.getSpinResultXml()));
        }
        return this.unmarshal(spinResultEntry);
    }

    private T unmarshal(SpinResultEntry spinResultEntry) throws Exception {
        Unmarshaller unmarshaller = HiveJaxbContext.getInstance().getContext().createUnmarshaller();
        ResponseMessageType response = GenericAggregator.unmarshal(unmarshaller, spinResultEntry.getSpinResultXml(), ResponseMessageType.class);
        T extracted = this.strategy.extractFromResponse(response);
        if (DEBUG) {
            log.debug((Object)("Extracted from response: " + extracted));
        }
        return extracted;
    }

    private static <A> A unmarshal(Unmarshaller unmarshaller, String xml, Class<A> resultClass) throws JAXBException {
        return (A)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)), resultClass).getValue();
    }
}

