/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterInstanceResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryMasterType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryStatusTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.StatusType;
import java.util.Collection;
import java.util.List;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;

public final class PatientSetAggregator
implements ShrineResultAggregator {
    private static final Logger log = Logger.getLogger(PatientSetAggregator.class);

    private ResponseMessageType convert(SpinResultEntry result) {
        try {
            return HiveCommonSerializer.getResponse((String)result.getSpinResultXml());
        }
        catch (Exception e) {
            log.error((Object)"Failed to deserialize Result payload from Adapter.");
            return null;
        }
    }

    @Override
    public ResponseMessageType aggregate(String masterId, Collection<SpinResultEntry> spinCacheResults, RequestMessageType request, ShrineHeader shrineHeader) throws SerializationException {
        int setSize = 0;
        ResponseMessageType aggregatedResponse = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)request);
        if (spinCacheResults.isEmpty()) {
            MasterInstanceResultResponseType master = new MasterInstanceResultResponseType();
            StatusType status = new StatusType();
            StatusType.Condition condition = new StatusType.Condition();
            condition.setCodingSystem("coding");
            condition.setType("ERROR");
            condition.setValue("ERROR");
            status.getCondition().add(condition);
            master.setStatus(status);
            CRCSerializer.addMasterResultInstanceResponse((ResponseMessageType)aggregatedResponse, (MasterInstanceResultResponseType)master);
            aggregatedResponse.setResponseHeader(new ResponseHeaderType(HiveCommonSerializer.getResultStatusError((String)"ERROR")));
            return aggregatedResponse;
        }
        MasterInstanceResultResponseType master = this.createMaster(shrineHeader.getQueryMasterId(), shrineHeader.getQueryInstanceId());
        for (SpinResultEntry result : spinCacheResults) {
            ResponseMessageType singleCRCResponse = this.convert(result);
            if (CRCSerializer.isErrorQuery((ResponseMessageType)singleCRCResponse)) {
                QueryResultInstanceType errorResult = new QueryResultInstanceType();
                QueryStatusTypeType resultStatus = new QueryStatusTypeType();
                resultStatus.setDescription(singleCRCResponse.getResponseHeader().getResultStatus().getStatus().getValue());
                resultStatus.setName("ERROR");
                errorResult.setQueryStatusType(resultStatus);
                errorResult.setDescription(result.getSpinResultMetadata().getDescription());
                master.getQueryResultInstance().add(errorResult);
                continue;
            }
            List siteSpecificResults = CRCSerializer.getQueryResults((ResponseMessageType)singleCRCResponse);
            for (int i = 0; i < siteSpecificResults.size(); ++i) {
                QueryResultInstanceType siteResult = (QueryResultInstanceType)siteSpecificResults.get(i);
                siteResult.setDescription(result.getSpinResultMetadata().getDescription());
                master.getQueryResultInstance().add(siteResult);
                if (!siteResult.getQueryResultType().getName().equals("PATIENT_COUNT_XML") || siteResult.getSetSize() == -1) continue;
                setSize += siteResult.getSetSize();
            }
        }
        master.getQueryResultInstance().add(PatientSetAggregator.getAggregateSummary(masterId, setSize));
        CRCSerializer.addMasterResultInstanceResponse((ResponseMessageType)aggregatedResponse, (MasterInstanceResultResponseType)master);
        aggregatedResponse.setResponseHeader(new ResponseHeaderType(HiveCommonSerializer.getResultStatusDone((String)"DONE")));
        return aggregatedResponse;
    }

    private MasterInstanceResultResponseType createMaster(Long masterId, Long instanceId) {
        MasterInstanceResultResponseType master = new MasterInstanceResultResponseType();
        StatusType masterStatus = new StatusType();
        StatusType.Condition masterCondition = new StatusType.Condition();
        masterCondition.setType("DONE");
        masterCondition.setValue("DONE");
        masterStatus.getCondition().add(masterCondition);
        master.setStatus(masterStatus);
        QueryMasterType queryMaster = new QueryMasterType();
        String queryMasterId = String.valueOf(masterId);
        queryMaster.setQueryMasterId(queryMasterId);
        master.setQueryMaster(queryMaster);
        QueryInstanceType queryInstance = new QueryInstanceType();
        queryInstance.setQueryMasterId(queryMasterId);
        String queryInstanceId = String.valueOf(instanceId);
        queryInstance.setQueryInstanceId(queryInstanceId);
        master.setQueryInstance(queryInstance);
        QueryStatusTypeType instanceStatus = new QueryStatusTypeType();
        instanceStatus.setStatusTypeId("6");
        instanceStatus.setDescription("COMPLETED");
        instanceStatus.setName("COMPLETED");
        master.getQueryInstance().setQueryStatusType(instanceStatus);
        return master;
    }

    private static QueryResultInstanceType getAggregateSummary(String shrineQueryID, int setSize) {
        QueryResultInstanceType summary = new QueryResultInstanceType();
        QueryResultTypeType result = new QueryResultTypeType();
        QueryStatusTypeType status = new QueryStatusTypeType();
        result.setDescription("AGGREGATED");
        result.setName("PATIENT_COUNT_XML");
        result.setResultTypeId("4");
        result.setDisplayType("CATNUM");
        result.setVisualAttributeType("LA");
        status.setDescription("FINISHED");
        status.setName("FINISHED");
        status.setStatusTypeId("3");
        summary.setResultInstanceId("0");
        summary.setQueryResultType(result);
        summary.setQueryStatusType(status);
        summary.setQueryInstanceId(shrineQueryID);
        summary.setSetSize(setSize);
        summary.setDescription("aggregated");
        return summary;
    }
}

