/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestResult;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.UnitTestReport;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Logger;

public class UnitTestReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    UnitTestReport(String title, Class<?>[] classes) {
        super(title);
        try {
            1 runner = new /* Unavailable Anonymous Inner Class!! */;
            for (Class<?> clazz : classes) {
                LOGGER.info((Object)("running unit test class: " + clazz.getCanonicalName()));
                Test test = runner.getTest(clazz.getCanonicalName());
                LOGGER.info((Object)("response from unit test: " + test));
                TestResult testResult = new TestResult();
                test.run(testResult);
                String message = testResult.failureCount() == 0 ? "okay" : "error";
                message = message + String.format(" errors/test : %d/%d ", testResult.failureCount(), testResult.runCount());
                this.pack(clazz.getCanonicalName()).setValue(message);
            }
        }
        catch (Throwable t) {
            ArrayList<String> message = new ArrayList<String>();
            message.add(t.getMessage());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(output));
            message.add(output.toString());
            this.pack("unit test failure").setValue(message);
        }
    }
}

