/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration.reports;

import net.shrine.config.I2B2HiveConfig;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HiveConfigReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    public HiveConfigReport(I2B2HiveConfig hive) {
        super("Hive Config");
        ReportDTO.EntryDTO ont = this.pack("Ontology Cell");
        ReportDTO.EntryDTO crc = this.pack("CRC Cell");
        ReportDTO.EntryDTO shrineBA = this.pack("Broadcaster Aggregator (SOAP) ");
        ReportDTO.EntryDTO sheriff = this.pack("Sheriff Cell");
        try {
            ont.setValue(hive.getONTURL());
            crc.setValue(hive.getCRCURL());
            shrineBA.setValue(hive.getAggregatorURL());
            sheriff.setValue(hive.hasSheriff() ? hive.getSheriffURL() : "warning: sheriff not enabled.");
        }
        catch (Exception e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"generate hive config", (Throwable)e);
            this.exception = e.getMessage();
        }
    }
}

