/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration.reports;

import java.util.ArrayList;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

public class KeyStoreReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    public KeyStoreReport() {
        super("Keystore");
        ReportDTO.EntryDTO fileEntry = this.pack("File");
        ReportDTO.EntryDTO passwordEntry = this.pack("Password");
        ReportDTO.EntryDTO certNameEntry = this.pack("My X509 Certificate Name");
        ReportDTO.EntryDTO certSerialEntry = this.pack("My X509 Certificate Serial");
        ReportDTO.EntryDTO itrust = this.pack("I Trust");
        try {
            KeyStoreConfig keyStoreConfig = ConfigTool.loadKeyStoreConfig();
            fileEntry.setValue(ConfigTool.getConfigFileAsURL((String)keyStoreConfig.getFile().toString()).toString());
            passwordEntry.setValue("*****");
            PKITool pki = PKITool.getInstance();
            CertID certID = pki.getMyX509().getCertID();
            certNameEntry.setValue(certID.getName());
            certSerialEntry.setValue(certID.getSerial().toString());
            ArrayList<String> trusted = new ArrayList<String>();
            for (CertData imported : pki.getImportedCertsCopy()) {
                trusted.add(imported.getCertID().getName());
                trusted.add(imported.getCertID().getSerial().toString());
            }
            itrust.setValue(trusted);
        }
        catch (Exception e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"generate key store", (Throwable)e);
            this.exception = e.getMessage();
        }
    }
}

