/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.integration.reports;

import java.util.ArrayList;
import net.shrine.integration.ReportDTO;
import net.shrine.integration.util.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.RoutingTableConfig;

public class RoutingTableReport
extends ReportDTO {
    private static final Logger LOGGER = LogUtil.createLogger();

    public RoutingTableReport() {
        super("Routing Table");
        try {
            RoutingTableConfig routingTable = ConfigTool.loadRoutingTableConfig();
            NodeConfig nodeConfig = ConfigTool.loadNodeConfig();
            ArrayList<String> peerGroupNames = new ArrayList<String>();
            for (PeerGroupConfig peerGroupConfig : routingTable.getPeerGroups()) {
                peerGroupNames.add(peerGroupConfig.getGroupName());
            }
            this.pack("Is a member of peer group", peerGroupNames);
            for (PeerGroupConfig peerGroupConfig : routingTable.getPeerGroups()) {
                if (!nodeConfig.isBroadcaster().booleanValue()) continue;
                for (EndpointConfig child : peerGroupConfig.getChildren()) {
                    this.pack(String.format("Is a Broadcaster for Peer Group %s with child ", peerGroupConfig), child.getAddress());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log((Priority)Level.ERROR, (Object)"routing table", (Throwable)e);
            this.exception = e.getMessage();
        }
    }
}

