/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.protocol;

import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.AuthenticationInfo$;
import net.shrine.protocol.Credential;
import net.shrine.protocol.I2b2SerializableValidator;
import net.shrine.protocol.XmlSerializableValidator;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.ShouldMatchersForJUnit;
import org.scalatest.matchers.Matchers;
import org.scalatest.matchers.Matchers$ByteTolerance$;
import org.scalatest.matchers.Matchers$DoubleTolerance$;
import org.scalatest.matchers.Matchers$FloatTolerance$;
import org.scalatest.matchers.Matchers$IntTolerance$;
import org.scalatest.matchers.Matchers$LongTolerance$;
import org.scalatest.matchers.Matchers$ShortTolerance$;
import org.scalatest.matchers.ShouldMatchers;
import org.scalatest.matchers.ShouldMatchers$ShouldMethodHelper$;
import org.scalatest.verb.ShouldVerb;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u0013\t1\u0012)\u001e;iK:$\u0018nY1uS>t\u0017J\u001c4p)\u0016\u001cHO\u0003\u0002\u0004\t\u0005A\u0001O]8u_\u000e|GN\u0003\u0002\u0006\r\u000511\u000f\u001b:j]\u0016T\u0011aB\u0001\u0004]\u0016$8\u0001A\n\b\u0001)\u0011BdH\u0012'!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u001b\u001b\u0005!\"BA\u000b\u0017\u0003\u0015QWO\\5u\u0015\t9\u0002$A\u0005tG\u0006d\u0017\r^3ti*\t\u0011$A\u0002pe\u001eL!a\u0007\u000b\u0003%\u0005\u001b8/\u001a:uS>t7OR8s\u0015Vs\u0017\u000e\u001e\t\u0003'uI!A\b\u000b\u0003-MCw.\u001e7e\u001b\u0006$8\r[3sg\u001a{'OS+oSR\u0004\"\u0001I\u0011\u000e\u0003\tI!A\t\u0002\u00031akGnU3sS\u0006d\u0017N_1cY\u00164\u0016\r\\5eCR|'\u000f\u0005\u0002!I%\u0011QE\u0001\u0002\u001a\u0013J\u0012'gU3sS\u0006d\u0017N_1cY\u00164\u0016\r\\5eCR|'\u000f\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0003\u0001C\u00032\u0001\u0011\u0005!'A\u000buKN$8\u000b\u001e:j]\u001e\u001cuN\\:ueV\u001cGo\u001c:\u0016\u0003M\u0002\"a\n\u001b\n\u0005UB#\u0001B+oSRD#\u0001M\u001c\u0011\u0005aRT\"A\u001d\u000b\u0005UA\u0012BA\u001e:\u0005\u0011!Vm\u001d;\t\u000bu\u0002A\u0011\u0001 \u0002\u0019Q,7\u000f\u001e$s_6L%G\u0019\u001a\u0015\u0003MB#\u0001P\u001c\t\u000b\u0005\u0003A\u0011\u0001 \u0002\u0015Q,7\u000f\u001e+p\u0013J\u0012'\u0007\u000b\u0002Ao!)A\t\u0001C\u0001}\u0005IA/Z:u)>DV\u000e\u001c\u0015\u0003\u0007^BQa\u0012\u0001\u0005\u0002y\nA\u0002^3tiR{\u0007*Z1eKJD#AR\u001c\t\u000b)\u0003A\u0011\u0001 \u0002\u0017Q,7\u000f\u001e$s_6DV\u000e\u001c\u0015\u0003\u0013^BQ!\u0014\u0001\u0005\u0002y\na\u0002^3ti\u001a\u0013x.\u001c%fC\u0012,'\u000f\u000b\u0002Mo\u0001")
public class AuthenticationInfoTest
implements AssertionsForJUnit,
ShouldMatchersForJUnit,
XmlSerializableValidator,
I2b2SerializableValidator,
ScalaObject {
    private final Matchers.NotWord not;
    private final Matchers.BeWord be;
    private final Matchers.HaveWord have;
    private final Matchers.ContainWord contain;
    private final Matchers.IncludeWord include;
    private final Matchers.FullyMatchWord fullyMatch;
    private final Matchers.StartWithWord startWith;
    private final Matchers.EndWithWord endWith;
    private final Matchers.LengthWord length;
    private final Matchers.SizeWord size;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile ShouldMatchers$ShouldMethodHelper$ org$scalatest$matchers$ShouldMatchers$$ShouldMethodHelper$module;
    private volatile Matchers$DoubleTolerance$ DoubleTolerance$module;
    private volatile Matchers$FloatTolerance$ FloatTolerance$module;
    private volatile Matchers$LongTolerance$ LongTolerance$module;
    private volatile Matchers$IntTolerance$ IntTolerance$module;
    private volatile Matchers$ShortTolerance$ ShortTolerance$module;
    private volatile Matchers$ByteTolerance$ ByteTolerance$module;

    @Test
    public void testStringConstructor() {
        AuthenticationInfo auth = new AuthenticationInfo("xyz-domain", "xyz-user", new Credential("asjkdhkasjdfh", true));
        AuthenticationInfo copy = new AuthenticationInfo(auth.toHeader());
        Assert.assertNotSame((Object)auth, (Object)copy);
        this.convertToAnyRefShouldWrapper(auth).should(this.equal(copy));
    }

    @Override
    @Test
    public void testFromI2b2() {
        String passwd = "SessionKey:prFsw9A1zZTr2PZpFLh1";
        String domain = "test_domain";
        String username = "test_username";
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)"test_domain");
        $buf.$amp$plus((Object)new Elem(null, "domain", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)"test_username");
        $buf.$amp$plus((Object)new Elem(null, "username", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("is_token", (Seq)new Text("true"), (MetaData)$md);
        $md = new UnprefixedAttribute("token_ms_timeout", (Seq)new Text("1800000"), (MetaData)$md);
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)"SessionKey:prFsw9A1zZTr2PZpFLh1");
        $buf.$amp$plus((Object)new Elem(null, "password", (MetaData)$md, (NamespaceBinding)topScope$4, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        AuthenticationInfo auth = AuthenticationInfo$.MODULE$.fromI2b2((NodeSeq)new Elem(null, "security", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf));
        this.convertToStringShouldWrapper(auth.domain()).should(this.equal("test_domain"));
        this.convertToStringShouldWrapper(auth.username()).should(this.equal("test_username"));
        this.convertToStringShouldWrapper(auth.credential().value()).should(this.equal("SessionKey:prFsw9A1zZTr2PZpFLh1"));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)auth.credential().isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    @Test
    public void testToI2b2() {
        Credential credential = new Credential("value", false);
        String domain = "domain";
        String username = "username";
        AuthenticationInfo authn = new AuthenticationInfo("domain", "username", credential);
        ShouldMatchers.SeqShouldWrapper seqShouldWrapper = this.convertToSeqShouldWrapper((Seq)authn.toI2b2());
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)"domain");
        $buf.$amp$plus((Object)new Elem(null, "domain", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)"username");
        $buf.$amp$plus((Object)new Elem(null, "username", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)credential.toI2b2());
        seqShouldWrapper.should(this.equal(new Elem(null, "security", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Test
    public void testToXml() {
        void var3_3;
        Credential credential = new Credential("value", false);
        AuthenticationInfo authn = new AuthenticationInfo("domain", "username", credential);
        ShouldMatchers.SeqShouldWrapper seqShouldWrapper = this.convertToSeqShouldWrapper((Seq)authn.toXml());
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("domain"));
        $buf.$amp$plus((Object)new Elem(null, "domain", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("username"));
        $buf.$amp$plus((Object)new Elem(null, "username", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)credential.toXml());
        seqShouldWrapper.should(this.equal(new Elem(null, "authenticationInfo", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var3_3)));
    }

    @Test
    public void testToHeader() {
        String passwd = "SessionKey:prFsw9A1zZTr2PZpFLh1";
        String domain = "test_domain";
        String username = "test_username";
        Credential credential = new Credential("SessionKey:prFsw9A1zZTr2PZpFLh1", false);
        String headerString = new StringBuilder().append((Object)AuthenticationInfo$.MODULE$.headerPrefix()).append((Object)"test_domain").append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)"test_username").append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)credential.value()).append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)BoxesRunTime.boxToBoolean((boolean)credential.isToken())).toString();
        AuthenticationInfo authn = new AuthenticationInfo("test_domain", "test_username", credential);
        this.convertToStringShouldWrapper(authn.toHeader()).should(this.equal(headerString));
        AuthenticationInfo roundTripped = AuthenticationInfo$.MODULE$.fromHeader(authn.toHeader());
        this.convertToStringShouldWrapper(authn.domain()).should(this.equal(roundTripped.domain()));
        this.convertToStringShouldWrapper(authn.username()).should(this.equal(roundTripped.username()));
        this.convertToAnyRefShouldWrapper(authn.credential()).should(this.equal(roundTripped.credential()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Test
    public void testFromXml() {
        void var3_2;
        Credential credential = new Credential("value", false);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("domain"));
        $buf.$amp$plus((Object)new Elem(null, "domain", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("username"));
        $buf.$amp$plus((Object)new Elem(null, "username", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)credential.toXml());
        AuthenticationInfo authn = AuthenticationInfo$.MODULE$.fromXml((NodeSeq)new Elem(null, "authenticationInfo", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var3_2));
        this.convertToStringShouldWrapper(authn.domain()).should(this.equal("domain"));
        this.convertToStringShouldWrapper(authn.username()).should(this.equal("username"));
        this.convertToAnyRefShouldWrapper(authn.credential()).should(this.equal(credential));
    }

    @Test
    public void testFromHeader() {
        String passwd = "SessionKey:prFsw9A1zZTr2PZpFLh1";
        String domain = "test_domain";
        String username = "test_username";
        Credential credential = new Credential("SessionKey:prFsw9A1zZTr2PZpFLh1", false);
        String headerString = new StringBuilder().append((Object)AuthenticationInfo$.MODULE$.headerPrefix()).append((Object)"test_domain").append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)"test_username").append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)credential.value()).append((Object)AuthenticationInfo$.MODULE$.headerDelimiter()).append((Object)BoxesRunTime.boxToBoolean((boolean)credential.isToken())).toString();
        AuthenticationInfo authn = AuthenticationInfo$.MODULE$.fromHeader(headerString);
        this.convertToAnyRefShouldWrapper(authn).should(this.not()).be(null);
        this.convertToStringShouldWrapper(authn.domain()).should(this.equal("test_domain"));
        this.convertToStringShouldWrapper(authn.username()).should(this.equal("test_username"));
        this.convertToAnyRefShouldWrapper(authn.credential()).should(this.equal(credential));
    }

    public AuthenticationInfoTest() {
        Assertions.class.$init$((Assertions)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        Matchers.class.$init$((Matchers)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        ShouldMatchers.class.$init$((ShouldMatchers)this);
        ShouldMatchersForJUnit.class.$init$((ShouldMatchersForJUnit)this);
    }
}

