/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.protocol;

import net.shrine.protocol.Credential;
import net.shrine.protocol.Credential$;
import net.shrine.protocol.I2b2SerializableValidator;
import net.shrine.protocol.XmlSerializableValidator;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.ShouldMatchersForJUnit;
import org.scalatest.matchers.Matchers;
import org.scalatest.matchers.Matchers$ByteTolerance$;
import org.scalatest.matchers.Matchers$DoubleTolerance$;
import org.scalatest.matchers.Matchers$FloatTolerance$;
import org.scalatest.matchers.Matchers$IntTolerance$;
import org.scalatest.matchers.Matchers$LongTolerance$;
import org.scalatest.matchers.Matchers$ShortTolerance$;
import org.scalatest.matchers.ShouldMatchers;
import org.scalatest.matchers.ShouldMatchers$ShouldMethodHelper$;
import org.scalatest.verb.ShouldVerb;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0013\tq1I]3eK:$\u0018.\u00197UKN$(BA\u0002\u0005\u0003!\u0001(o\u001c;pG>d'BA\u0003\u0007\u0003\u0019\u0019\bN]5oK*\tq!A\u0002oKR\u001c\u0001aE\u0004\u0001\u0015Iard\t\u0014\u0011\u0005-\u0001R\"\u0001\u0007\u000b\u00055q\u0011\u0001\u00027b]\u001eT\u0011aD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0012\u0019\t1qJ\u00196fGR\u0004\"a\u0005\u000e\u000e\u0003QQ!!\u0006\f\u0002\u000b),h.\u001b;\u000b\u0005]A\u0012!C:dC2\fG/Z:u\u0015\u0005I\u0012aA8sO&\u00111\u0004\u0006\u0002\u0013\u0003N\u001cXM\u001d;j_:\u001chi\u001c:K+:LG\u000f\u0005\u0002\u0014;%\u0011a\u0004\u0006\u0002\u0017'\"|W\u000f\u001c3NCR\u001c\u0007.\u001a:t\r>\u0014(*\u00168jiB\u0011\u0001%I\u0007\u0002\u0005%\u0011!E\u0001\u0002\u001916d7+\u001a:jC2L'0\u00192mKZ\u000bG.\u001b3bi>\u0014\bC\u0001\u0011%\u0013\t)#AA\rJe\t\u00144+\u001a:jC2L'0\u00192mKZ\u000bG.\u001b3bi>\u0014\bCA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aC*dC2\fwJ\u00196fGRDQ!\f\u0001\u0005\u00029\na\u0001P5oSRtD#A\u0018\u0011\u0005\u0001\u0002\u0001\"B\u0019\u0001\t\u0003\u0011\u0014\u0001\u0004;fgR4%o\\7Je\t\u0014D#A\u001a\u0011\u0005\u001d\"\u0014BA\u001b)\u0005\u0011)f.\u001b;)\u0005A:\u0004C\u0001\u001d;\u001b\u0005I$BA\u000b\u0019\u0013\tY\u0014H\u0001\u0003UKN$\b\"B\u001f\u0001\t\u0003\u0011\u0014A\u0003;fgR$v.\u0013\u001ace!\u0012Ah\u000e\u0005\u0006\u0001\u0002!\tAM\u0001\ni\u0016\u001cH\u000fV8Y[2D#aP\u001c\t\u000b\r\u0003A\u0011\u0001\u001a\u0002\u0017Q,7\u000f\u001e$s_6DV\u000e\u001c\u0015\u0003\u0005^BQA\u0012\u0001\u0005\u0002I\nQ\u0003^3ti\u0016\u000bX/\u00197t\u0003:$\u0007*Y:iG>$W\r\u000b\u0002Fo\u0001")
public class CredentialTest
implements AssertionsForJUnit,
ShouldMatchersForJUnit,
XmlSerializableValidator,
I2b2SerializableValidator,
ScalaObject {
    private final Matchers.NotWord not;
    private final Matchers.BeWord be;
    private final Matchers.HaveWord have;
    private final Matchers.ContainWord contain;
    private final Matchers.IncludeWord include;
    private final Matchers.FullyMatchWord fullyMatch;
    private final Matchers.StartWithWord startWith;
    private final Matchers.EndWithWord endWith;
    private final Matchers.LengthWord length;
    private final Matchers.SizeWord size;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile ShouldMatchers$ShouldMethodHelper$ org$scalatest$matchers$ShouldMatchers$$ShouldMethodHelper$module;
    private volatile Matchers$DoubleTolerance$ DoubleTolerance$module;
    private volatile Matchers$FloatTolerance$ FloatTolerance$module;
    private volatile Matchers$LongTolerance$ LongTolerance$module;
    private volatile Matchers$IntTolerance$ IntTolerance$module;
    private volatile Matchers$ShortTolerance$ ShortTolerance$module;
    private volatile Matchers$ByteTolerance$ ByteTolerance$module;

    @Override
    @Test
    public void testFromI2b2() {
        String passwd = "SessionKey:prFsw9A1zZTr2PZpFLh1";
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("is_token", (Seq)new Text("true"), (MetaData)$md);
        $md = new UnprefixedAttribute("token_ms_timeout", (Seq)new Text("1800000"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)"SessionKey:prFsw9A1zZTr2PZpFLh1");
        Credential cred = Credential$.MODULE$.fromI2b2((NodeSeq)new Elem(null, "password", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf));
        this.convertToStringShouldWrapper(cred.value()).should(this.equal("SessionKey:prFsw9A1zZTr2PZpFLh1"));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)cred.isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)true)));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("is_token", (Seq)new Text("false"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("token_ms_timeout", (Seq)new Text("1800000"), (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)"SessionKey:prFsw9A1zZTr2PZpFLh1");
        cred = Credential$.MODULE$.fromI2b2((NodeSeq)new Elem(null, "password", (MetaData)$md2, (NamespaceBinding)topScope$2, (Seq)$buf2));
        this.convertToStringShouldWrapper(cred.value()).should(this.equal("SessionKey:prFsw9A1zZTr2PZpFLh1"));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)cred.isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)false)));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)"SessionKey:prFsw9A1zZTr2PZpFLh1");
        cred = Credential$.MODULE$.fromI2b2((NodeSeq)new Elem(null, "password", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        this.convertToStringShouldWrapper(cred.value()).should(this.equal("SessionKey:prFsw9A1zZTr2PZpFLh1"));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)cred.isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    @Override
    @Test
    public void testToI2b2() {
        String passwd = "passwd";
        boolean isToken = false;
        Credential credential = new Credential("passwd", false);
        ShouldMatchers.SeqShouldWrapper seqShouldWrapper = this.convertToSeqShouldWrapper((Seq)credential.toI2b2());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("is_token", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("token_ms_timeout", (Seq)new Text("1800000"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)"passwd");
        seqShouldWrapper.should(this.equal(new Elem(null, "password", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Test
    public void testToXml() {
        void var3_3;
        Credential credential = new Credential("passwd", false);
        ShouldMatchers.SeqShouldWrapper seqShouldWrapper = this.convertToSeqShouldWrapper((Seq)credential.toXml());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("isToken", (Seq)new Text("false"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("passwd"));
        seqShouldWrapper.should(this.equal(new Elem(null, "credential", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Test
    public void testFromXml() {
        void var3_2;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("isToken", (Seq)new Text("false"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("passwd"));
        Credential credential = Credential$.MODULE$.fromXml((NodeSeq)new Elem(null, "credential", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)var3_2));
        this.convertToStringShouldWrapper(credential.value()).should(this.equal("passwd"));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)credential.isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)false)));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("isToken", (Seq)new Text("true"), (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("passwd"));
        credential = Credential$.MODULE$.fromXml((NodeSeq)new Elem(null, "credential", (MetaData)$md2, (NamespaceBinding)topScope$2, (Seq)$buf2));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)credential.isToken())).should(this.equal(BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Test
    public void testEqualsAndHashcode() {
        Credential credsTrue = new Credential("creds", true);
        Credential credsTrue2 = new Credential("creds", true);
        this.convertToAnyRefShouldWrapper(credsTrue).should(this.equal(credsTrue2));
        this.convertToAnyRefShouldWrapper(credsTrue2).should(this.equal(credsTrue));
        this.convertToIntShouldWrapper(credsTrue.hashCode()).should(this.equal(BoxesRunTime.boxToInteger((int)credsTrue2.hashCode())));
        Credential credsFalse = new Credential("creds", false);
        Credential credsFalse2 = new Credential("creds", false);
        this.convertToAnyRefShouldWrapper(credsFalse).should(this.equal(credsFalse2));
        this.convertToAnyRefShouldWrapper(credsFalse2).should(this.equal(credsFalse));
        this.convertToIntShouldWrapper(credsFalse.hashCode()).should(this.equal(BoxesRunTime.boxToInteger((int)credsFalse2.hashCode())));
        this.convertToAnyRefShouldWrapper(credsTrue).should(this.not()).equal((Object)credsFalse);
        this.convertToAnyRefShouldWrapper(credsFalse).should(this.not()).equal((Object)credsTrue);
    }

    public CredentialTest() {
        Assertions.class.$init$((Assertions)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        Matchers.class.$init$((Matchers)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        ShouldMatchers.class.$init$((ShouldMatchers)this);
        ShouldMatchersForJUnit.class.$init$((ShouldMatchersForJUnit)this);
    }
}

