/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import junit.framework.Assert;
import net.shrine.serializers.crc.QueryDefBuilder;
import org.spin.tools.SPINUnitTest;

public class QueryBuilderTest
extends SPINUnitTest {
    public void testSinglePanelWithGenderMaleORFemale() throws Exception {
        QueryDefinitionType queryDef = QueryDefBuilder.getQueryDefinition((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderFemale(), QueryDefBuilder.getItemGenderMale()});
        QueryBuilderTest.assertTrue((String)"Expect a single panel ", (queryDef.getPanel().size() == 1 ? 1 : 0) != 0);
        PanelType singlePanel = (PanelType)queryDef.getPanel().get(0);
        QueryBuilderTest.assertTrue((String)"Expect 2 items keys ", (singlePanel.getItem().size() == 2 ? 1 : 0) != 0);
        ItemType item1 = (ItemType)singlePanel.getItem().get(0);
        ItemType item2 = (ItemType)singlePanel.getItem().get(1);
        QueryBuilderTest.assertEquals((String)"Female ", (String)QueryDefBuilder.PATH_FEMALE, (String)item1.getItemKey());
        QueryBuilderTest.assertEquals((String)"Male ", (String)QueryDefBuilder.PATH_MALE, (String)item2.getItemKey());
    }

    public void testDualPanelGenderMaleAndFemale() throws Exception {
        PanelType panelFemale = QueryDefBuilder.getPanel((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderFemale()});
        PanelType panelMale = QueryDefBuilder.getPanel((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderMale()});
        QueryDefinitionType queryDef = QueryDefBuilder.getQueryDefinition((PanelType[])new PanelType[]{panelFemale, panelMale});
        Assert.assertEquals((String)"Expect 2 panels ", (int)2, (int)queryDef.getPanel().size());
        Assert.assertEquals((String)"Each panel has only one item ", (int)1, (int)((PanelType)queryDef.getPanel().get(0)).getItem().size());
        Assert.assertEquals((String)"Each panel has only one item ", (int)1, (int)((PanelType)queryDef.getPanel().get(1)).getItem().size());
        QueryBuilderTest.assertEquals((String)"This is the Female panel", (String)QueryDefBuilder.PATH_FEMALE, (String)((ItemType)((PanelType)queryDef.getPanel().get(0)).getItem().get(0)).getItemKey());
        QueryBuilderTest.assertEquals((String)"This is the Male panel", (String)QueryDefBuilder.PATH_MALE, (String)((ItemType)((PanelType)queryDef.getPanel().get(1)).getItem().get(0)).getItemKey());
    }

    public void testBuildPaths() {
        String pathNoPrefix = QueryDefBuilder.buildPath((String[])new String[]{"Diagnoses", "Complications of pregnancy, childbirth, and the puerperium"});
        String pathWithPrefix = QueryDefBuilder.buildPathWithPrefix((String)"SHRINE", (String[])new String[]{"Diagnoses", "Complications of pregnancy, childbirth, and the puerperium"});
        QueryBuilderTest.assertEquals((String)"Diagnoses\\Complications of pregnancy, childbirth, and the puerperium\\", (String)pathNoPrefix);
        QueryBuilderTest.assertEquals((String)"\\\\SHRINE\\Diagnoses\\Complications of pregnancy, childbirth, and the puerperium\\", (String)pathWithPrefix);
    }
}

