/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.protocol.query;

import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase;
import net.shrine.protocol.query.And;
import net.shrine.protocol.query.And$;
import net.shrine.protocol.query.DateBounded;
import net.shrine.protocol.query.Expression;
import net.shrine.protocol.query.Expression$;
import net.shrine.protocol.query.Not;
import net.shrine.protocol.query.OccuranceLimited;
import net.shrine.protocol.query.Or;
import net.shrine.protocol.query.Or$;
import net.shrine.protocol.query.Term;
import net.shrine.protocol.query.Utils$;
import org.scalatest.Assertions;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.matchers.Matchers;
import org.scalatest.matchers.Matchers$ByteTolerance$;
import org.scalatest.matchers.Matchers$DoubleTolerance$;
import org.scalatest.matchers.Matchers$FloatTolerance$;
import org.scalatest.matchers.Matchers$IntTolerance$;
import org.scalatest.matchers.Matchers$LongTolerance$;
import org.scalatest.matchers.Matchers$ShortTolerance$;
import org.scalatest.matchers.ShouldMatchers;
import org.scalatest.matchers.ShouldMatchers$ShouldMethodHelper$;
import org.scalatest.verb.ShouldVerb;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0003\u0017\tqQ\t\u001f9sKN\u001c\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!\u0001\u0005qe>$xnY8m\u0015\t9\u0001\"\u0001\u0004tQJLg.\u001a\u0006\u0002\u0013\u0005\u0019a.\u001a;\u0004\u0001M)\u0001\u0001\u0004\u000b\u001eGA\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\nMJ\fW.Z<pe.T\u0011!E\u0001\u0006UVt\u0017\u000e^\u0005\u0003'9\u0011\u0001\u0002V3ti\u000e\u000b7/\u001a\t\u0003+mi\u0011A\u0006\u0006\u0003#]Q!\u0001G\r\u0002\u0013M\u001c\u0017\r\\1uKN$(\"\u0001\u000e\u0002\u0007=\u0014x-\u0003\u0002\u001d-\t\u0011\u0012i]:feRLwN\\:G_JTUK\\5u!\tq\u0012%D\u0001 \u0015\t\u0001s#\u0001\u0005nCR\u001c\u0007.\u001a:t\u0013\t\u0011sD\u0001\bTQ>,H\u000eZ'bi\u000eDWM]:\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003\tAaa\f\u0001!\u0002\u0013\u0001\u0014A\u0001;2!\ti\u0013'\u0003\u00023\u0005\t!A+\u001a:n\u0011\u0019!\u0004\u0001)A\u0005a\u0005\u0011AO\r\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0019\u0002\u0005Q\u001c\u0004B\u0002\u001d\u0001A\u0003%\u0001'\u0001\u0002ui!1!\b\u0001Q\u0001\nA\n!\u0001^\u001b\t\rq\u0002\u0001\u0015!\u00031\u0003\t!h\u0007C\u0003?\u0001\u0011\u0005q(A\u000buKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ge>l\u0007,\u001c7\u0016\u0003\u0001\u0003\"\u0001J!\n\u0005\t+#\u0001B+oSRDQ\u0001\u0012\u0001\u0005\u0002}\n\u0011\u0003^3ti:{'/\\1mSj,G+\u001a:n\u0011\u00151\u0005\u0001\"\u0001@\u0003A!Xm\u001d;O_Jl\u0017\r\\5{K:{G\u000fC\u0003I\u0001\u0011\u0005q(\u0001\tuKN$hj\u001c:nC2L'0Z!oI\")!\n\u0001C\u0001\u007f\u0005yA/Z:u\u001d>\u0014X.\u00197ju\u0016|%\u000fC\u0003M\u0001\u0011\u0005q(A\u000fuKN$hj\u001c:nC2L'0Z'jq\u0016$7i\\7q_N,\u0017M\u00197f\u0011\u0015q\u0005\u0001\"\u0001@\u0003\u0015\"Xm\u001d;ECR,'i\\;oI\u0016$G+[7f5>tWm]!sK:{'/\\1mSj,G\rC\u0003Q\u0001\u0011\u0005q(\u0001\ruKN$hj\u001c:nC2L'0\u001a#bi\u0016\u0014u.\u001e8eK\u0012DQA\u0015\u0001\u0005\u0002}\nA\u0003^3ti>\u001b7-\u001e:b]\u000e,G*[7ji\u0016$\u0007\"\u0002+\u0001\t\u0003y\u0014!\b;fgRtuN]7bY&TXmT2dkJ\fgnY3MS6LG/\u001a3\t\u000bY\u0003A\u0011A \u0002\u001bQ,7\u000f\u001e+fe6$v\u000eW7m\u0011\u0015A\u0006\u0001\"\u0001@\u00031!Xm\u001d;O_R$v\u000eW7m\u0011\u0015Q\u0006\u0001\"\u0001@\u00031!Xm\u001d;B]\u0012$v\u000eW7m\u0011\u0015a\u0006\u0001\"\u0001@\u0003-!Xm\u001d;PeR{\u0007,\u001c7\t\u000by\u0003A\u0011A \u0002)Q,7\u000f\u001e#bi\u0016\u0014u.\u001e8eK\u0012$v\u000eW7m\u0011\u0015\u0001\u0007\u0001\"\u0001@\u0003e!Xm\u001d;PG\u000e,(/\u00198dK2KW.\u001b;fIR{\u0007,\u001c7\t\u000b\t\u0004A\u0011B2\u00025\u0011|G+Z:u\u001d>\u0014X.\u00197ju\u0016\u001cu.\u001c9pg\u0016\f'\r\\3\u0016\u0005\u0011\u0014HC\u0001!f\u0011\u00151\u0017\r1\u0001h\u0003\ty\u0005\u000f\u0005\u0003%Q*\u0004\u0018BA5&\u0005%1UO\\2uS>t\u0017\u0007E\u0002%W6L!\u0001\\\u0013\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002.]&\u0011qN\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA9s\u0019\u0001!Qa]1C\u0002Q\u0014\u0011\u0001V\t\u0003k6\u0004\"\u0001\n<\n\u0005],#a\u0002(pi\"Lgn\u001a")
public final class ExpressionTest
extends TestCase
implements AssertionsForJUnit,
ShouldMatchers,
ScalaObject {
    public final Term net$shrine$protocol$query$ExpressionTest$$t1;
    private final Term t2;
    private final Term t3;
    private final Term t4;
    private final Term t5;
    private final Term t6;
    private final Matchers.NotWord not;
    private final Matchers.BeWord be;
    private final Matchers.HaveWord have;
    private final Matchers.ContainWord contain;
    private final Matchers.IncludeWord include;
    private final Matchers.FullyMatchWord fullyMatch;
    private final Matchers.StartWithWord startWith;
    private final Matchers.EndWithWord endWith;
    private final Matchers.LengthWord length;
    private final Matchers.SizeWord size;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile ShouldMatchers$ShouldMethodHelper$ org$scalatest$matchers$ShouldMatchers$$ShouldMethodHelper$module;
    private volatile Matchers$DoubleTolerance$ DoubleTolerance$module;
    private volatile Matchers$FloatTolerance$ FloatTolerance$module;
    private volatile Matchers$LongTolerance$ LongTolerance$module;
    private volatile Matchers$IntTolerance$ IntTolerance$module;
    private volatile Matchers$ShortTolerance$ ShortTolerance$module;
    private volatile Matchers$ByteTolerance$ ByteTolerance$module;

    public void testExpressionFromXml() {
        OccuranceLimited expr = new OccuranceLimited(99, (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1), new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t2, this.t3, new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t4, this.t5})), new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)this.t6)}))})));
        DateBounded db1 = new DateBounded((Option)None$.MODULE$, (Option)None$.MODULE$, (Expression)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3})));
        DateBounded db2 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)None$.MODULE$, (Expression)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3})));
        DateBounded db3 = new DateBounded((Option)None$.MODULE$, (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3})));
        DateBounded db4 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3})));
        this.roundTrip$1((Expression)expr);
        this.roundTrip$1((Expression)db1);
        this.roundTrip$1((Expression)db2);
        this.roundTrip$1((Expression)db3);
        this.roundTrip$1((Expression)db4);
        this.roundTrip$1((Expression)new Or((Seq)Nil$.MODULE$));
        this.roundTrip$1((Expression)new And((Seq)Nil$.MODULE$));
        this.roundTrip$1((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.roundTrip$1((Expression)new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1));
        this.roundTrip$1((Expression)new OccuranceLimited(99, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1));
    }

    public void testNormalizeTerm() {
        Term t1 = new Term("foo");
        this.convertToAnyRefShouldWrapper(t1).should(this.be().apply((Object)t1.normalize()));
    }

    public void testNormalizeNot() {
        Not simple = new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.convertToAnyRefShouldWrapper(simple.normalize()).should(this.be().apply((Object)simple));
        this.assert(this.convertToEqualizer(new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).$eq$eq$eq((Object)new Not((Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))).normalize()));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)new Not((Expression)new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).normalize()));
    }

    public void testNormalizeAnd() {
        this.doTestNormalizeComposeable((Function1)And$.MODULE$);
    }

    public void testNormalizeOr() {
        this.doTestNormalizeComposeable((Function1)Or$.MODULE$);
    }

    public void testNormalizeMixedComposeable() {
        And mixed1 = new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.convertToAnyRefShouldWrapper(mixed1.normalize()).should(this.be().apply((Object)mixed1));
        Or mixed2 = new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.convertToAnyRefShouldWrapper(mixed2.normalize()).should(this.be().apply((Object)mixed2));
        Or mixed3 = new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.assert(this.convertToEqualizer(new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), this.t3, this.t4}))).$eq$eq$eq((Object)mixed3.normalize()));
        And mixed4 = new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.assert(this.convertToEqualizer(new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), this.t3, this.t4}))).$eq$eq$eq((Object)mixed4.normalize()));
    }

    public void testDateBoundedTimeZonesAreNormalized() {
        DateBounded db = (DateBounded)new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))).normalize();
        this.assert(this.convertToEqualizer(db.expr()).$eq$eq$eq((Object)this.net$shrine$protocol$query$ExpressionTest$$t1));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.isUTC$1(db.start()))).should(this.be().apply(true));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.isUTC$1(db.end()))).should(this.be().apply(true));
        DateBounded db2 = (DateBounded)new DateBounded((Option)None$.MODULE$, (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))).normalize();
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.isUTC$1(db2.start()))).should(this.be().apply(false));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.isUTC$1(db2.end()))).should(this.be().apply(true));
    }

    public void testNormalizeDateBounded() {
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)new DateBounded((Option)None$.MODULE$, (Option)None$.MODULE$, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).normalize()));
        DateBounded db1 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)None$.MODULE$, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.convertToAnyRefShouldWrapper(db1.normalize()).should(this.be().apply((Object)db1));
        DateBounded db2 = new DateBounded((Option)None$.MODULE$, (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.convertToAnyRefShouldWrapper(db2.normalize()).should(this.be().apply((Object)db2));
        DateBounded db3 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.convertToAnyRefShouldWrapper(db3.normalize()).should(this.be().apply((Object)db3));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)new DateBounded((Option)None$.MODULE$, (Option)None$.MODULE$, (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))).normalize()));
        DateBounded db4 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)None$.MODULE$, (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))})));
        this.assert(this.convertToEqualizer(new DateBounded(db4.start(), db4.end(), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).$eq$eq$eq((Object)db4.normalize()));
        DateBounded db5 = new DateBounded((Option)None$.MODULE$, (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))})));
        this.assert(this.convertToEqualizer(new DateBounded(db5.start(), db5.end(), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).$eq$eq$eq((Object)db5.normalize()));
        DateBounded db6 = new DateBounded((Option)new Some((Object)Utils$.MODULE$.now()), (Option)new Some((Object)Utils$.MODULE$.now()), (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))})));
        this.assert(this.convertToEqualizer(new DateBounded(db6.start(), db6.end(), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).$eq$eq$eq((Object)db6.normalize()));
    }

    public void testOccuranceLimited() {
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ExpressionTest $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OccuranceLimited apply() {
                return new OccuranceLimited(-1, (Expression)this.$outer.net$shrine$protocol$query$ExpressionTest$$t1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Manifest$.MODULE$.classType(IllegalArgumentException.class));
    }

    public void testNormalizeOccuranceLimited() {
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)new OccuranceLimited(0, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).normalize()));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)new OccuranceLimited(0, (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))).normalize()));
        OccuranceLimited o1 = new OccuranceLimited(1, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1);
        this.convertToAnyRefShouldWrapper(o1.normalize()).should(this.be().apply((Object)o1));
        OccuranceLimited o2 = new OccuranceLimited(99, (Expression)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))})));
        this.assert(this.convertToEqualizer(new OccuranceLimited(99, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1)).$eq$eq$eq((Object)o2.normalize()));
    }

    /*
     * WARNING - void declaration
     */
    public void testTermToXml() {
        void var1_1;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        this.assert(this.convertToEqualizer(new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.toXml().toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void testNotToXml() {
        void var1_1;
        void var2_2;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        this.assert(this.convertToEqualizer(new Elem(null, "not", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)new Not((Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void testAndToXml() {
        void var3_3;
        void var1_1;
        void var2_2;
        this.assert(this.convertToEqualizer(new Elem(null, "and", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])).toString()).$eq$eq$eq((Object)new And((Seq)Nil$.MODULE$).toXml().toString()));
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        this.assert(this.convertToEqualizer(new Elem(null, "and", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1})).toXml().toString()));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf3.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)this.t2.value());
        $buf3.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf5));
        this.assert(this.convertToEqualizer(new Elem(null, "and", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)var3_3).toString()).$eq$eq$eq((Object)new And((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})).toXml().toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void testOrToXml() {
        void var3_3;
        void var1_1;
        void var2_2;
        this.assert(this.convertToEqualizer(new Elem(null, "or", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])).toString()).$eq$eq$eq((Object)new Or((Seq)Nil$.MODULE$).toXml().toString()));
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        this.assert(this.convertToEqualizer(new Elem(null, "or", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1})).toXml().toString()));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf3.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)this.t2.value());
        $buf3.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf5));
        this.assert(this.convertToEqualizer(new Elem(null, "or", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)var3_3).toString()).$eq$eq$eq((Object)new Or((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})).toXml().toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void testDateBoundedToXml() {
        void var1_1;
        void var2_2;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        this.assert(this.convertToEqualizer(new Elem(null, "dateBounded", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)new DateBounded((Option)None$.MODULE$, (Option)None$.MODULE$, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
        XMLGregorianCalendar time = Utils$.MODULE$.now();
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)time.toString());
        $buf3.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf3.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf5));
        this.assert(this.convertToEqualizer(new Elem(null, "dateBounded", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString()).$eq$eq$eq((Object)new DateBounded((Option)new Some((Object)time), (Option)None$.MODULE$, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)time.toString());
        $buf6.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, (Seq)$buf7));
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf6.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$8, (Seq)$buf8));
        this.assert(this.convertToEqualizer(new Elem(null, "dateBounded", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, (Seq)$buf6).toString()).$eq$eq$eq((Object)new DateBounded((Option)None$.MODULE$, (Option)new Some((Object)time), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)time.toString());
        $buf9.$amp$plus((Object)new Elem(null, "start", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$10, (Seq)$buf10));
        TopScope$ topScope$11 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)time.toString());
        $buf9.$amp$plus((Object)new Elem(null, "end", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$11, (Seq)$buf11));
        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf9.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, (Seq)$buf12));
        this.assert(this.convertToEqualizer(new Elem(null, "dateBounded", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, (Seq)$buf9).toString()).$eq$eq$eq((Object)new DateBounded((Option)new Some((Object)time), (Option)new Some((Object)time), (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void testOccuranceLimitedToXml() {
        void var1_1;
        void var3_3;
        void var2_2;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("99"));
        $buf.$amp$plus((Object)new Elem(null, "min", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)this.net$shrine$protocol$query$ExpressionTest$$t1.value());
        $buf.$amp$plus((Object)new Elem(null, "term", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)var3_3));
        this.assert(this.convertToEqualizer(new Elem(null, "occurs", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1).toString()).$eq$eq$eq((Object)new OccuranceLimited(99, (Expression)this.net$shrine$protocol$query$ExpressionTest$$t1).toXml().toString()));
    }

    private <T extends Expression> void doTestNormalizeComposeable(Function1<Seq<Expression>, T> Op) {
        Expression empty = (Expression)Op.apply((Object)Nil$.MODULE$);
        this.convertToAnyRefShouldWrapper(empty).should(this.be().apply((Object)empty.normalize()));
        Expression one = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)one.normalize()));
        Expression two = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2}));
        this.assert(this.convertToEqualizer(two).$eq$eq$eq((Object)two.normalize()));
        Expression nested = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)nested.normalize()));
        Expression nested2 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2}))}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2}))).$eq$eq$eq((Object)nested2.normalize()));
        Expression nested3 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3, this.t4}))).$eq$eq$eq((Object)nested3.normalize()));
        Expression nested4 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2})), this.t3, this.t4}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3, this.t4}))).$eq$eq$eq((Object)nested4.normalize()));
        Expression nested5 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3, this.t4}))}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3, this.t4}))).$eq$eq$eq((Object)nested5.normalize()));
        Expression nested6 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t2, this.t3})), this.t4}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3, this.t4}))).$eq$eq$eq((Object)nested6.normalize()));
        Expression nested7 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1})), (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t2})), (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t3})), (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.t4}))}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2, this.t3, this.t4}))).$eq$eq$eq((Object)nested7.normalize()));
        Expression deeplyNested1 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1}))}))}))}))}));
        this.assert(this.convertToEqualizer(this.net$shrine$protocol$query$ExpressionTest$$t1).$eq$eq$eq((Object)deeplyNested1.normalize()));
        Expression deeplyNested2 = (Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2}))}))}))}))}));
        this.assert(this.convertToEqualizer(Op.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.net$shrine$protocol$query$ExpressionTest$$t1, this.t2}))).$eq$eq$eq((Object)deeplyNested2.normalize()));
    }

    private final void roundTrip$1(Expression expr) {
        NodeSeq xml = expr.toXml();
        Expression unmarshalled = Expression$.MODULE$.fromXml(xml);
        this.assert(this.convertToEqualizer(unmarshalled).$eq$eq$eq((Object)expr));
    }

    private final boolean isUTC$1(Option date) {
        return BoxesRunTime.unboxToBoolean((Object)date.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(XMLGregorianCalendar xMLGregorianCalendar) {
                return xMLGregorianCalendar.getTimeZone(0).getRawOffset() == 0;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    public ExpressionTest() {
        Assertions.class.$init$((Assertions)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        Matchers.class.$init$((Matchers)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        ShouldMatchers.class.$init$((ShouldMatchers)this);
        this.net$shrine$protocol$query$ExpressionTest$$t1 = new Term("foo");
        this.t2 = new Term("bar");
        this.t3 = new Term("baz");
        this.t4 = new Term("blarg");
        this.t5 = new Term("nuh");
        this.t6 = new Term("zuh");
    }
}

