/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.pm;

import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.pm.ConfigureType;
import edu.harvard.i2b2.crc.datavo.pm.PasswordType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import net.shrine.config.I2B2HiveConfig;
import net.shrine.serializers.I2B2ExampleMessages;
import net.shrine.serializers.SerializerUnitTest;
import net.shrine.serializers.pm.PMInvalidLogonException;
import net.shrine.serializers.pm.PMSerializer;

public class PMSerializerTest
extends SerializerUnitTest {
    public void testRoundTripCannedMessages() throws Exception {
        this.roundTripRequest(I2B2ExampleMessages.PM_INVALID_LOGON_REQUEST);
        this.roundTripRequest(I2B2ExampleMessages.PM_VALID_LOGON_REQUEST);
        this.roundTripResponse(I2B2ExampleMessages.PM_INVALID_LOGON_RESPONSE);
        this.roundTripResponse(I2B2ExampleMessages.PM_VALID_LOGON_RESPONSE);
    }

    public void testGetHiveConfig() throws Exception {
        ResponseMessageType response = I2B2ExampleMessages.PM_VALID_LOGON_RESPONSE.getResponse();
        I2B2HiveConfig hiveConfig = PMSerializer.getHiveConfig((ResponseMessageType)response);
        PMSerializerTest.assertTrue((boolean)hiveConfig.hasCRC());
        PMSerializerTest.assertTrue((boolean)hiveConfig.hasONT());
        PMSerializerTest.assertEquals((String)hiveConfig.getCRCURL(), (String)"http://cbmi-lab.med.harvard.edu:8443/shrine-cell/QueryToolService/");
        PMSerializerTest.assertEquals((String)hiveConfig.getONTURL(), (String)"http://cbmi-i2b2-dev:9090/i2b2/rest/OntologyService/");
        try {
            I2B2HiveConfig shouldBeNull = PMSerializer.getHiveConfig((ResponseMessageType)I2B2ExampleMessages.PM_INVALID_LOGON_RESPONSE.getResponse());
            PMSerializerTest.fail((String)("Expected PMInvalidLogonException getting I2B2HiveConfig from PM_INVALID_LOGON_RESPONSE, instead got " + String.valueOf(shouldBeNull)));
        }
        catch (PMInvalidLogonException pMInvalidLogonException) {
            // empty catch block
        }
    }

    public void testGetUserType() throws Exception {
        UserType userType = PMSerializer.getUserType((ResponseMessageType)I2B2ExampleMessages.PM_VALID_LOGON_RESPONSE.getResponse());
        PMSerializerTest.assertNotNull((String)"UserType should not be null!", (Object)userType);
        PMSerializerTest.assertEquals((String)userType.getFullName(), (String)"Demo User");
        PMSerializerTest.assertEquals((String)userType.getUserName(), (String)"demo");
        PasswordType pass = new PasswordType();
        pass.setValue("demouser");
        PMSerializerTest.assertEquals((Object)userType.getPassword(), (Object)pass);
        PMSerializerTest.assertEquals((String)userType.getDomain(), (String)"demo");
        PMSerializerTest.assertEquals((int)userType.getProject().size(), (int)2);
        try {
            UserType shouldBeNull = PMSerializer.getUserType((ResponseMessageType)I2B2ExampleMessages.PM_INVALID_LOGON_RESPONSE.getResponse());
            PMSerializerTest.fail((String)("Expected PMInvalidLogonException getting usertype from PM_INVALID_LOGON_RESPONSE, instead got " + String.valueOf(shouldBeNull)));
        }
        catch (PMInvalidLogonException pMInvalidLogonException) {
            // empty catch block
        }
    }

    public void testGetBodyType() throws Exception {
        ConfigureType configureType = PMSerializer.getBodyType((ResponseMessageType)I2B2ExampleMessages.PM_VALID_LOGON_RESPONSE.getResponse());
        PMSerializerTest.assertEquals((String)"DEVELOPMENT", (String)configureType.getEnvironment());
        PMSerializerTest.assertEquals((String)"http://www.i2b2.org", (String)configureType.getHelpURL());
        PMSerializerTest.assertEquals((int)6, (int)configureType.getCellDatas().getCellData().size());
        try {
            ConfigureType shouldBeNull = PMSerializer.getBodyType((ResponseMessageType)I2B2ExampleMessages.PM_INVALID_LOGON_RESPONSE.getResponse());
            PMSerializerTest.fail((String)("Expected PMInvalidLogonException getting configureType from PM_INVALID_LOGON_RESPONSE, instead got " + String.valueOf(shouldBeNull)));
        }
        catch (PMInvalidLogonException pMInvalidLogonException) {
            // empty catch block
        }
    }
}

