/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.shrine.config.LocalKeys;
import org.apache.log4j.Logger;
import org.spin.tools.FileUtils;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

@XmlRootElement(name="AdapterMappings")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AdapterMappings {
    private static final Logger log = Logger.getLogger(AdapterMappings.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private static final String DEFAULT_MAPPINGS_FILENAME = "AdapterMappings.xml";
    public static final String I2B2_PREFIX = "\\\\I2B2";
    private static AdapterMappings defaultInstance;
    private String hostname;
    private Date timestamp;
    private final TreeMap<String, LocalKeys> mappings = new TreeMap();

    public AdapterMappings() {
        this.hostname = ConfigTool.getHostName();
        this.timestamp = new Date();
    }

    public static AdapterMappings getDefaultInstance() throws ConfigException {
        if (defaultInstance != null) {
            if (DEBUG) {
                log.debug((Object)"getDefaultInstance() returning cached instance");
            }
        } else {
            defaultInstance = AdapterMappings.loadFromFile(DEFAULT_MAPPINGS_FILENAME);
        }
        return defaultInstance;
    }

    public static AdapterMappings loadFromFile(String mappingsFilename) throws ConfigException {
        return AdapterMappings.loadfromFile(ConfigTool.getConfigFileWithFailover((String)mappingsFilename));
    }

    public String getHostname() {
        return this.hostname;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<String> getMappings(String globalKey) {
        LocalKeys keys = this.mappings.get(globalKey);
        if (keys != null) {
            return Collections.unmodifiableList(keys);
        }
        return Collections.unmodifiableList(new ArrayList(0));
    }

    public static AdapterMappings loadfromStream(InputStream inputStream) throws ConfigException {
        AdapterMappings mappings = null;
        try {
            if (INFO) {
                log.info((Object)("Loading AdapterMappings from stream : " + String.valueOf(inputStream)));
            }
            mappings = (AdapterMappings)JAXBUtils.unmarshal((String)FileUtils.read((InputStream)inputStream), AdapterMappings.class);
            return mappings;
        }
        catch (IOException ioe) {
            log.error((Object)"IO Error", (Throwable)ioe);
            throw new ConfigException("AdapterMappings io error", (Throwable)ioe);
        }
        catch (JAXBException jaxbe) {
            log.error((Object)"Unmarshalling error", (Throwable)jaxbe);
            throw new ConfigException("AdapterMappings unmarshalling error", (Throwable)jaxbe);
        }
    }

    public static AdapterMappings loadfromFile(File mappingsFile) throws ConfigException {
        AdapterMappings mappings = null;
        try {
            if (INFO) {
                log.info((Object)("Loading AdapterMappings from disk : " + mappingsFile.getAbsolutePath()));
            }
            mappings = (AdapterMappings)JAXBUtils.unmarshal((File)mappingsFile, AdapterMappings.class);
            return mappings;
        }
        catch (JAXBException jaxbe) {
            log.error((Object)"Unmarshalling error", (Throwable)jaxbe);
            throw new ConfigException("AdapterMappings unmarshalling error", (Throwable)jaxbe);
        }
    }

    public int size() {
        return this.mappings.size();
    }

    public static String applyI2B2Prefix(String key) {
        if (!key.startsWith(I2B2_PREFIX)) {
            String new_key = I2B2_PREFIX + key;
            log.debug((Object)("Adding i2b2 prefix for local_key:" + key + "->" + new_key));
            return new_key;
        }
        return key;
    }

    public boolean addMapping(String core_key, String local_key) {
        if (this.mappings.containsKey(core_key)) {
            List keys = this.mappings.get(core_key);
            if (keys.contains(local_key)) {
                return false;
            }
            return keys.add(local_key);
        }
        LocalKeys keys = new LocalKeys(local_key);
        this.mappings.put(core_key, keys);
        return true;
    }

    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.mappings.keySet());
    }
}

