/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import javax.xml.bind.annotation.XmlRootElement;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.NodeConfig;

@XmlRootElement(name="ShrineConfig")
public class ShrineConfig {
    protected String humanReadableNodeName;
    protected boolean isBroadcasterAggregator = true;
    protected String broadcasterPeerGroupToQuery;
    protected int queryTTL = 180000;
    protected long cacheTTL = 3600000L;
    protected long certificationTTL = 3600000L;
    protected boolean isAdapter = true;
    protected Integer adapterLockoutAttemptsThreshold = 7;
    protected boolean setSizeObfuscationEnabled = true;
    protected boolean adapterRequireExplicitMappings = true;
    protected String identityServiceClass = null;
    protected String databasePropertiesFile;
    protected String realCRCEndpoint;
    protected String shrineEndpoint;
    protected String aggregatorEndpoint;
    protected String pmEndpoint;
    protected String ontEndpoint;
    protected String sheriffEndpoint;
    protected String translatorClass;
    private String queryActionMapClassName;

    public boolean isSetSizeObfuscationEnabled() {
        return this.setSizeObfuscationEnabled;
    }

    public void setSetSizeObfuscationEnabled(boolean setSizeObfuscationEnabled) {
        this.setSizeObfuscationEnabled = setSizeObfuscationEnabled;
    }

    public String getShrineEndpoint() {
        return this.shrineEndpoint;
    }

    public void setShrineEndpoint(String shrineEndpoint) {
        this.shrineEndpoint = shrineEndpoint;
    }

    public String getAggregatorEndpoint() {
        return this.aggregatorEndpoint;
    }

    public void setAggregatorEndpoint(String aggregatorEndpoint) {
        this.aggregatorEndpoint = aggregatorEndpoint;
    }

    public String getPmEndpoint() {
        return this.pmEndpoint;
    }

    public void setPmEndpoint(String pmEndpoint) {
        this.pmEndpoint = pmEndpoint;
    }

    public String getOntEndpoint() {
        return this.ontEndpoint;
    }

    public void setOntEndpoint(String ontEndpoint) {
        this.ontEndpoint = ontEndpoint;
    }

    public String getSheriffEndpoint() {
        return this.sheriffEndpoint;
    }

    public void setSheriffEndpoint(String sheriffEndpoint) {
        this.sheriffEndpoint = sheriffEndpoint;
    }

    public String getDatabasePropertiesFile() {
        return this.databasePropertiesFile;
    }

    public void setDatabasePropertiesFile(String databasePropertiesFile) {
        this.databasePropertiesFile = databasePropertiesFile;
    }

    public void setAdapterLockoutAttemptsThreshold(Integer adapterLockoutAttemptsThreshold) {
        this.adapterLockoutAttemptsThreshold = adapterLockoutAttemptsThreshold;
    }

    public String getHumanReadableNodeName() {
        return this.humanReadableNodeName;
    }

    public void setHumanReadableNodeName(String humanReadableNodeName) {
        this.humanReadableNodeName = humanReadableNodeName;
    }

    public boolean isBroadcasterAggregator() {
        return this.isBroadcasterAggregator;
    }

    public void setBroadcasterAggregator(boolean broadcasterAggregator) {
        this.isBroadcasterAggregator = broadcasterAggregator;
    }

    public String getBroadcasterPeerGroupToQuery() {
        return this.broadcasterPeerGroupToQuery;
    }

    public void setBroadcasterPeerGroupToQuery(String broadcasterPeerGroupToQuery) {
        this.broadcasterPeerGroupToQuery = broadcasterPeerGroupToQuery;
    }

    public boolean isAdapter() {
        return this.isAdapter;
    }

    public void setAdapter(boolean adapter) {
        this.isAdapter = adapter;
    }

    public int getQueryTTL() {
        return this.queryTTL;
    }

    public void setQueryTTL(int queryTTL) {
        this.queryTTL = queryTTL;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public long getCertificationTTL() {
        return this.certificationTTL;
    }

    public void setCertificationTTL(long certificationTTL) {
        this.certificationTTL = certificationTTL;
    }

    public int getAdapterLockoutAttemptsThreshold() {
        return this.adapterLockoutAttemptsThreshold;
    }

    public void setAdapterLockoutAttemptsThreshold(int adapterLockoutAttemptsThreshold) {
        this.adapterLockoutAttemptsThreshold = adapterLockoutAttemptsThreshold;
    }

    public boolean isAdapterRequireExplicitMappings() {
        return this.adapterRequireExplicitMappings;
    }

    public void setAdapterRequireExplicitMappings(boolean adapterRequireExplicitMappings) {
        this.adapterRequireExplicitMappings = adapterRequireExplicitMappings;
    }

    public String getIdentityServiceClass() {
        return this.identityServiceClass;
    }

    public void setIdentityServiceClass(String identityServiceClass) {
        this.identityServiceClass = identityServiceClass;
    }

    public String getRealCRCEndpoint() {
        return this.realCRCEndpoint;
    }

    public void setRealCRCEndpoint(String realCRCEndpoint) {
        this.realCRCEndpoint = realCRCEndpoint;
    }

    public String getTranslatorClass() {
        return this.translatorClass;
    }

    public void setTranslatorClass(String translatorClass) {
        this.translatorClass = translatorClass;
    }

    public String getQueryActionMapClassName() {
        return this.queryActionMapClassName;
    }

    public void setQueryActionMapClassName(String queryActionMapClassName) {
        this.queryActionMapClassName = queryActionMapClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrineConfig that = (ShrineConfig)o;
        if (this.adapterRequireExplicitMappings != that.adapterRequireExplicitMappings) {
            return false;
        }
        if (this.cacheTTL != that.cacheTTL) {
            return false;
        }
        if (this.certificationTTL != that.certificationTTL) {
            return false;
        }
        if (this.isAdapter != that.isAdapter) {
            return false;
        }
        if (this.isBroadcasterAggregator != that.isBroadcasterAggregator) {
            return false;
        }
        if (this.queryTTL != that.queryTTL) {
            return false;
        }
        if (this.adapterLockoutAttemptsThreshold != null ? !this.adapterLockoutAttemptsThreshold.equals(that.adapterLockoutAttemptsThreshold) : that.adapterLockoutAttemptsThreshold != null) {
            return false;
        }
        if (this.aggregatorEndpoint != null ? !this.aggregatorEndpoint.equals(that.aggregatorEndpoint) : that.aggregatorEndpoint != null) {
            return false;
        }
        if (this.broadcasterPeerGroupToQuery != null ? !this.broadcasterPeerGroupToQuery.equals(that.broadcasterPeerGroupToQuery) : that.broadcasterPeerGroupToQuery != null) {
            return false;
        }
        if (this.databasePropertiesFile != null ? !this.databasePropertiesFile.equals(that.databasePropertiesFile) : that.databasePropertiesFile != null) {
            return false;
        }
        if (this.humanReadableNodeName != null ? !this.humanReadableNodeName.equals(that.humanReadableNodeName) : that.humanReadableNodeName != null) {
            return false;
        }
        if (this.identityServiceClass != null ? !this.identityServiceClass.equals(that.identityServiceClass) : that.identityServiceClass != null) {
            return false;
        }
        if (this.ontEndpoint != null ? !this.ontEndpoint.equals(that.ontEndpoint) : that.ontEndpoint != null) {
            return false;
        }
        if (this.pmEndpoint != null ? !this.pmEndpoint.equals(that.pmEndpoint) : that.pmEndpoint != null) {
            return false;
        }
        if (this.realCRCEndpoint != null ? !this.realCRCEndpoint.equals(that.realCRCEndpoint) : that.realCRCEndpoint != null) {
            return false;
        }
        if (this.sheriffEndpoint != null ? !this.sheriffEndpoint.equals(that.sheriffEndpoint) : that.sheriffEndpoint != null) {
            return false;
        }
        if (this.shrineEndpoint != null ? !this.shrineEndpoint.equals(that.shrineEndpoint) : that.shrineEndpoint != null) {
            return false;
        }
        return !(this.translatorClass != null ? !this.translatorClass.equals(that.translatorClass) : that.translatorClass != null);
    }

    public int hashCode() {
        int result = this.humanReadableNodeName != null ? this.humanReadableNodeName.hashCode() : 0;
        result = 31 * result + (this.isBroadcasterAggregator ? 1 : 0);
        result = 31 * result + (this.broadcasterPeerGroupToQuery != null ? this.broadcasterPeerGroupToQuery.hashCode() : 0);
        result = 31 * result + this.queryTTL;
        result = 31 * result + (int)(this.cacheTTL ^ this.cacheTTL >>> 32);
        result = 31 * result + (int)(this.certificationTTL ^ this.certificationTTL >>> 32);
        result = 31 * result + (this.isAdapter ? 1 : 0);
        result = 31 * result + (this.adapterLockoutAttemptsThreshold != null ? this.adapterLockoutAttemptsThreshold.hashCode() : 0);
        result = 31 * result + (this.adapterRequireExplicitMappings ? 1 : 0);
        result = 31 * result + (this.identityServiceClass != null ? this.identityServiceClass.hashCode() : 0);
        result = 31 * result + (this.databasePropertiesFile != null ? this.databasePropertiesFile.hashCode() : 0);
        result = 31 * result + (this.realCRCEndpoint != null ? this.realCRCEndpoint.hashCode() : 0);
        result = 31 * result + (this.shrineEndpoint != null ? this.shrineEndpoint.hashCode() : 0);
        result = 31 * result + (this.aggregatorEndpoint != null ? this.aggregatorEndpoint.hashCode() : 0);
        result = 31 * result + (this.pmEndpoint != null ? this.pmEndpoint.hashCode() : 0);
        result = 31 * result + (this.ontEndpoint != null ? this.ontEndpoint.hashCode() : 0);
        result = 31 * result + (this.sheriffEndpoint != null ? this.sheriffEndpoint.hashCode() : 0);
        result = 31 * result + (this.translatorClass != null ? this.translatorClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ShrineConfig{humanReadableNodeName='" + this.humanReadableNodeName + '\'' + ", isBroadcasterAggregator=" + this.isBroadcasterAggregator + ", broadcasterPeerGroupToQuery='" + this.broadcasterPeerGroupToQuery + '\'' + ", queryTTL=" + this.queryTTL + ", cacheTTL=" + this.cacheTTL + ", certificationTTL=" + this.certificationTTL + ", isAdapter=" + this.isAdapter + ", adapterLockoutAttemptsThreshold=" + this.adapterLockoutAttemptsThreshold + ", adapterRequireExplicitMappings=" + this.adapterRequireExplicitMappings + ", translatorClass=" + this.translatorClass + '}';
    }

    public AgentConfig generateAgentConfig() {
        EndpointConfig endpointConfig = new EndpointConfig(EndpointType.SOAP, this.aggregatorEndpoint);
        AgentConfig agentConfig = new AgentConfig(endpointConfig, endpointConfig, this.broadcasterPeerGroupToQuery, null, new Long(this.queryTTL), Float.valueOf(1.0f));
        return agentConfig;
    }

    public NodeConfig generateNodeConfig() {
        NodeConfig nodeConfig = new NodeConfig();
        nodeConfig.setNodeName(this.getHumanReadableNodeName());
        nodeConfig.setCertificationTTL(Long.valueOf(this.getCertificationTTL()));
        nodeConfig.setBroadcaster(Boolean.valueOf(this.isBroadcasterAggregator()));
        nodeConfig.setAggregator(Boolean.valueOf(this.isBroadcasterAggregator()));
        nodeConfig.setAuthenticator(Boolean.valueOf(false));
        nodeConfig.setIdentityServiceClass(this.getIdentityServiceClass());
        if (this.isBroadcasterAggregator()) {
            nodeConfig.setCacheTTL(Long.valueOf(this.getCacheTTL()));
        }
        nodeConfig.setQueryable(Boolean.valueOf(this.isAdapter()));
        return nodeConfig;
    }
}

