/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.pdo.query.GetPDOFromInputListRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterDeleteRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.UserRequestType;
import net.shrine.serializers.crc.GetRequestXml;
import net.shrine.sheriff.model.SheriffRequestType;
import org.spin.tools.Util;

public enum CRCRequestType {
    GetPDOFromInputListRequestType(GetPDOFromInputListRequestType.class),
    InstanceRequestType(InstanceRequestType.class),
    MasterRequestType(MasterRequestType.class),
    QueryDefinitionRequestType(QueryDefinitionRequestType.class),
    UserRequestType(UserRequestType.class),
    SheriffRequestType(SheriffRequestType.class),
    ResultRequestType(ResultRequestType.class),
    MasterDeleteRequestType(MasterDeleteRequestType.class),
    GetRequestXml(GetRequestXml.class);

    public final Class<?> requestClass;

    private CRCRequestType(Class<?> requestClass) {
        this.requestClass = requestClass;
    }

    public static CRCRequestType fromClass(Class<?> desiredRequestClass) {
        Util.guardNotNull(desiredRequestClass);
        for (CRCRequestType type : CRCRequestType.values()) {
            if (type.requestClass != desiredRequestClass) continue;
            return type;
        }
        throw new IllegalArgumentException("No CRCRRequestType for class '" + desiredRequestClass + "'");
    }

    public static CRCRequestType fromClass(String desiredRequestClassName) {
        Util.guardNotNull((Object)desiredRequestClassName);
        try {
            return CRCRequestType.fromClass(Class.forName(desiredRequestClassName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

