/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.util.Arrays;
import java.util.List;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;

public class QueryDefBuilder {
    public static String SHRINE = "SHRINE";
    public static String Demographics = "Demographics";
    public static String Diagnosis = "Diagnosis";
    public static String Medications = "Medications";
    public static String Labs = "Labs";
    public static String Age = "Age";
    public static String Gender = "Gender";
    public static String Male = "Male";
    public static String Female = "Female";
    public static String PATH_DEMOGRAPHICS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics);
    public static String PATH_DIAGNOSIS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Diagnosis);
    public static String PATH_MEDICATIONS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Medications);
    public static String PATH_LABS = QueryDefBuilder.buildPathWithPrefix(SHRINE, Labs);
    public static String PATH_MALE = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics, Gender, Male);
    public static String PATH_FEMALE = QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics, Gender, Female);
    public static String SLASH = "\\";

    public static RequestMessageType getRequestPSM(QueryDefinitionType queryDef, SecurityType securityType, String projectId) throws SerializationException {
        return CRCSerializer.getRequestPSM(queryDef, securityType, projectId);
    }

    public static QueryDefinitionType getQueryDefinition(List<PanelType> panels) {
        QueryDefinitionType queryDef = new QueryDefinitionType();
        for (int p = 0; p < panels.size(); ++p) {
            PanelType panel = panels.get(p);
            panel.setPanelNumber(p + 1);
            queryDef.getPanel().add(panel);
        }
        return queryDef;
    }

    public static QueryDefinitionType getQueryDefinition(PanelType ... panels) {
        return QueryDefBuilder.getQueryDefinition(Arrays.asList(panels));
    }

    public static QueryDefinitionType getQueryDefinition(ItemType ... itemsInSinglePanel) {
        return QueryDefBuilder.getQueryDefinition(QueryDefBuilder.getPanel(itemsInSinglePanel));
    }

    public static QueryDefinitionType getQueryDefinition(String ... itemKeysSinglePanel) {
        return QueryDefBuilder.getQueryDefinition(QueryDefBuilder.getPanel(itemKeysSinglePanel));
    }

    public static PanelType getPanel(List<ItemType> items) {
        PanelType panel = new PanelType();
        panel.setPanelNumber(1);
        panel.setInvert(0);
        PanelType.TotalItemOccurrences occurences = new PanelType.TotalItemOccurrences();
        occurences.setValue(items.size());
        panel.setTotalItemOccurrences(occurences);
        for (ItemType item : items) {
            panel.getItem().add(item);
        }
        return panel;
    }

    public static PanelType getPanel(ItemType ... items) {
        return QueryDefBuilder.getPanel(Arrays.asList(items));
    }

    public static PanelType getPanel(String ... itemKeys) {
        return QueryDefBuilder.getPanel(QueryDefBuilder.getItems(itemKeys));
    }

    public static ItemType getItemAge(int yearsOld) {
        return QueryDefBuilder.getItemAge(String.valueOf(yearsOld));
    }

    public static ItemType getItemAge(String ageRange) {
        return QueryDefBuilder.getItem(QueryDefBuilder.buildPathWithPrefix(SHRINE, Demographics, Age, ageRange));
    }

    public static ItemType getItemGenderMale() {
        return QueryDefBuilder.getItem(PATH_MALE);
    }

    public static ItemType getItemGenderFemale() {
        return QueryDefBuilder.getItem(PATH_FEMALE);
    }

    public static ItemType getItem(String path) {
        ItemType item = new ItemType();
        item.setItemKey(path);
        return item;
    }

    public static ItemType[] getItems(List<String> itemKeys) {
        ItemType[] items = new ItemType[itemKeys.size()];
        for (int i = 0; i < itemKeys.size(); ++i) {
            items[i] = QueryDefBuilder.getItem(itemKeys.get(i));
        }
        return items;
    }

    public static ItemType[] getItems(String ... itemKeys) {
        return QueryDefBuilder.getItems(Arrays.asList(itemKeys));
    }

    public static String getPathPrefix(String PREFIX) {
        return SLASH + SLASH + PREFIX + SLASH;
    }

    public static String buildPath(String ... traversal) {
        StringBuilder path = new StringBuilder();
        for (String node : traversal) {
            path.append(node);
            path.append(SLASH);
        }
        return path.toString();
    }

    public static String buildPathWithPrefix(String PREFIX, String ... traversal) {
        return QueryDefBuilder.getPathPrefix(PREFIX) + QueryDefBuilder.buildPath(traversal);
    }
}

