/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.pm;

import edu.harvard.i2b2.crc.datavo.i2b2message.PasswordType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import edu.harvard.i2b2.crc.datavo.pm.UsersType;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import net.shrine.config.I2B2HiveConfig;
import net.shrine.serializers.HTTPClient;
import net.shrine.serializers.pm.PMInvalidLogonException;
import net.shrine.serializers.pm.PMSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.config.ConfigException;

public class PMHttpClient {
    private static final Logger log = Logger.getLogger(PMHttpClient.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private String pmURL;

    public PMHttpClient(String url) {
        this.pmURL = url;
    }

    public I2B2HiveConfig getServices(SecurityType credentials) throws ConfigException, JAXBException, IOException, PMInvalidLogonException, SerializationException {
        return this.getServices(PMSerializer.getPMUserAuthRequestString(credentials));
    }

    public I2B2HiveConfig getServices(String i2b2XML) throws ConfigException, IOException, JAXBException, PMInvalidLogonException, SerializationException {
        if (INFO) {
            log.info((Object)("PM.getServices from " + this.pmURL));
        }
        String responseXML = HTTPClient.post(i2b2XML, this.pmURL);
        if (DEBUG) {
            log.debug((Object)("Reading PM response" + responseXML));
        }
        return PMSerializer.getHiveConfig(responseXML);
    }

    public UserType getUserConfiguration(String domain, String username, String password) throws ConfigException, JAXBException, IOException, PMInvalidLogonException, SerializationException {
        PasswordType passwordType = new PasswordType();
        passwordType.setIsToken(Boolean.valueOf(false));
        passwordType.setValue(password);
        return this.getUserConfiguration(new SecurityType(domain, username, passwordType));
    }

    public UserType getUserConfiguration(SecurityType credentials) throws ConfigException, IOException, JAXBException, PMInvalidLogonException, SerializationException {
        return this.getUserConfiguration(PMSerializer.getPMUserAuthRequestString(credentials));
    }

    public UserType getUserConfiguration(String i2b2XML) throws ConfigException, IOException, JAXBException, PMInvalidLogonException, SerializationException {
        if (DEBUG) {
            log.debug((Object)("PM.getUserParams from " + this.pmURL));
        }
        String responseXML = HTTPClient.post(i2b2XML, this.pmURL);
        if (DEBUG) {
            log.debug((Object)("Reading PM response" + responseXML));
        }
        return PMSerializer.getUserType(responseXML);
    }

    public UsersType getAllUserParams(SecurityType securityType) throws JAXBException, IOException, SerializationException {
        String request = PMSerializer.getPMGetAllUserParamsRequestString(securityType);
        String response = HTTPClient.post(request, this.pmURL);
        return PMSerializer.getUsersType(response);
    }
}

