/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.pm;

import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.pm.CellDataType;
import edu.harvard.i2b2.crc.datavo.pm.ConfigureType;
import edu.harvard.i2b2.crc.datavo.pm.ParamType;
import edu.harvard.i2b2.crc.datavo.pm.ProjectType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import edu.harvard.i2b2.crc.datavo.pm.UsersType;
import javax.xml.bind.JAXBException;
import net.shrine.config.CellNames;
import net.shrine.config.I2B2HiveConfig;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.pm.PMInvalidLogonException;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;

public class PMSerializer
extends HiveCommonSerializer {
    public static final Logger log = Logger.getLogger(PMSerializer.class);
    public final boolean DEBUG = log.isDebugEnabled();
    public final boolean INFO = log.isInfoEnabled();

    public static ConfigureType getBodyType(ResponseMessageType response) throws SerializationException, PMInvalidLogonException {
        PMSerializer.assertValidLogin(response);
        return PMSerializer.getBodyNode(response, 0, ConfigureType.class);
    }

    public static I2B2HiveConfig getHiveConfig(String responseXML) throws JAXBException, PMInvalidLogonException, SerializationException {
        return PMSerializer.getHiveConfig(PMSerializer.getResponse(responseXML));
    }

    public static I2B2HiveConfig getHiveConfig(ResponseMessageType response) throws SerializationException, PMInvalidLogonException {
        PMSerializer.assertValidLogin(response);
        ConfigureType config = PMSerializer.getBodyType(response);
        I2B2HiveConfig hive = new I2B2HiveConfig();
        for (CellDataType cellData : config.getCellDatas().getCellData()) {
            hive.addCell(cellData.getId(), cellData.getUrl());
        }
        if (hive.hasCRC()) {
            String aggregatorURL = hive.getCRCURL() + "aggregate";
            hive.addCell(CellNames.AGGREGATOR, aggregatorURL);
        } else {
            log.warn((Object)"No CRC found, invalid hive?");
        }
        return hive;
    }

    public static UserType getUserType(String responseXML) throws JAXBException, PMInvalidLogonException, SerializationException {
        return PMSerializer.getUserType(PMSerializer.getResponse(responseXML));
    }

    public static UserType getUserType(ResponseMessageType response) throws JAXBException, PMInvalidLogonException, SerializationException {
        PMSerializer.assertValidLogin(response);
        UserType userType = PMSerializer.getBodyType(response).getUser();
        return userType;
    }

    private static void assertValidLogin(ResponseMessageType response) throws PMInvalidLogonException {
        ResponseHeaderType header = response.getResponseHeader();
        if (header.getResultStatus().getStatus().getType().equalsIgnoreCase("ERROR")) {
            throw new PMInvalidLogonException(header.getResultStatus().getStatus().getValue());
        }
    }

    public static UsersType getUsersType(String responseXml) throws JAXBException, SerializationException {
        ResponseMessageType response = PMSerializer.getResponse(responseXml);
        return PMSerializer.getBodyNode(response, 0, UsersType.class);
    }

    public static String extractEcommonsUsername(UserType user) {
        for (ParamType param : user.getParam()) {
            if (!param.getName().equals("ecommons_username")) continue;
            return param.getValue();
        }
        for (ProjectType project : user.getProject()) {
            for (ParamType param : project.getParam()) {
                if (!param.getName().equals("ecommons_username")) continue;
                return param.getValue();
            }
        }
        return null;
    }
}

