/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import net.shrine.serializers.I2B2ExampleMessages;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.spin.tools.JAXBUtils;
import org.spin.tools.SPINUnitTest;
import org.w3c.dom.Node;

public abstract class SerializerUnitTest
extends SPINUnitTest {
    private DifferenceListener differenceListener = new I2B2XMLDifferenceListener();

    protected DifferenceListener getDifferenceListener() {
        return this.differenceListener;
    }

    public <T> void roundTripRequest(I2B2ExampleMessages message) throws Exception {
        this.roundTrip(message, RequestMessageType.class);
    }

    public <T> void roundTripResponse(I2B2ExampleMessages message) throws Exception {
        this.roundTrip(message, ResponseMessageType.class);
    }

    public <T> void roundTrip(I2B2ExampleMessages message, Class<T> clazz) throws Exception {
        String XML = message.getXML();
        this.log.debug((Object)("original" + XML));
        Object type = JAXBUtils.unmarshal((String)XML, clazz);
        String roundTripped = JAXBUtils.marshalToString((Object)type);
        this.log.debug((Object)roundTripped);
        this.assertSimilarXML(XML, roundTripped);
    }

    public void assertSimilarXML(String original, String test) throws Exception {
        this.assertSimilarXML(null, original, test);
    }

    public void assertDissimilarXML(String original, String test) throws Exception {
        this.assertDissimilarXML(null, original, test);
    }

    private void assertDissimilarXML(String message, String original, String test) throws Exception {
        this.compareXML(message, original, test, false);
    }

    private void compareXML(String message, String original, String test, boolean shouldBeSimilar) throws Exception {
        Diff diff = new Diff(original, test);
        diff.overrideDifferenceListener(this.getDifferenceListener());
        if (diff.similar() != shouldBeSimilar) {
            SerializerUnitTest.fail((String)this.getFailMessage(message, diff));
        }
    }

    public void assertSimilarXML(String message, String original, String test) throws Exception {
        this.compareXML(message, original, test, true);
    }

    protected String getFailMessage(String msg, Diff diff) {
        StringBuffer sb = new StringBuffer();
        if (msg != null && msg.length() > 0) {
            sb.append(msg).append(", ");
        }
        return sb.append(diff.toString()).toString();
    }

    class I2B2XMLDifferenceListener
    implements DifferenceListener {
        I2B2XMLDifferenceListener() {
        }

        public int differenceFound(Difference difference) {
            if (difference.getId() == 15) {
                return 2;
            }
            if (difference.getId() == 14 && difference.getControlNodeDetail().getValue().trim().equals(difference.getTestNodeDetail().getValue().trim())) {
                return 2;
            }
            SerializerUnitTest.this.log.warn((Object)("Found XML difference:" + String.valueOf(difference.getId()) + " - " + String.valueOf(difference) + "\n\t" + difference.getControlNodeDetail().getXpathLocation() + "\n\t" + difference.getTestNodeDetail().getXpathLocation()));
            return 0;
        }

        public void skippedComparison(Node control, Node test) {
        }
    }
}

