/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers;

import java.util.Arrays;
import net.shrine.serializers.QueryResultIDList;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.hive.HiveJaxbContext;
import org.junit.Assert;
import org.junit.Test;
import org.spin.tools.JAXBUtils;
import org.w3c.dom.Element;

public final class ShrineHeaderTest {
    @Test
    public void testJAXBSerialization() throws Exception {
        ShrineHeader header = new ShrineHeader();
        header.putHeader("qmid", (Object)1L);
        header.putHeader("qiid", (Object)2L);
        header.putHeader("qrids", (Object)new QueryResultIDList(Arrays.asList(3L, 4L)));
        header.putHeader("rid", (Object)5L);
        String marshalledString = JAXBUtils.marshalToString((Element)JAXBUtils.marshalToElement((Object)header, (String)HiveJaxbContext.getInstance().getPackageList()));
        ShrineHeader unmarshalledHeader = (ShrineHeader)JAXBUtils.unmarshal((String)marshalledString, (String)HiveJaxbContext.getInstance().getPackageList());
        Assert.assertEquals((Object)header, (Object)unmarshalledHeader);
    }

    @Test
    public void testHeaderAddGetRemove() {
        ShrineHeader header = new ShrineHeader();
        String key = "Jay";
        String value = "SilentBob";
        header.putHeader(key, (Object)value);
        Assert.assertEquals((Object)header.getHeader(key), (Object)value);
        Assert.assertNull((Object)header.removeHeader("Blah"));
        Object o = header.removeHeader(key);
        Assert.assertEquals((Object)value, (Object)o);
        Assert.assertNull((Object)header.getHeader(key));
    }

    @Test
    public void testDupes() {
        ShrineHeader header = new ShrineHeader();
        String key = "Jay";
        String value = "SilentBob";
        header.putHeader(key, (Object)value);
        header.putHeader(key, (Object)"Seth");
        Assert.assertEquals((long)header.getSize(), (long)1L);
        Assert.assertEquals((Object)"Seth", (Object)header.getHeader(key));
    }
}

