/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.Marshaller;
import junit.framework.Assert;
import net.shrine.serializers.I2B2ExampleMessages;
import net.shrine.serializers.QueryResultIDList;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.hive.HiveJaxbContext;
import org.junit.Test;
import org.spin.tools.JAXBUtils;
import org.w3c.dom.Element;

public final class ShrineMessageTest {
    @Test
    public void testSerialization() throws Exception {
        RequestMessageType request = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_REQUEST.getRequest();
        List<Long> resultIds = Arrays.asList(5L, 10L);
        ShrineHeader shrineHeader = new ShrineHeader();
        shrineHeader.putHeader("qmid", (Object)1L);
        shrineHeader.putHeader("qiid", (Object)2L);
        shrineHeader.putHeader("qrids", (Object)new QueryResultIDList(Arrays.asList(3L, 4L)));
        shrineHeader.putHeader("rid", (Object)5L);
        ShrineMessage shrineMessage = new ShrineMessage(shrineHeader, (Object)request);
        Marshaller m = HiveJaxbContext.getInstance().getContext().createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)shrineMessage, (Writer)sw);
        String xml = sw.toString();
        ShrineMessage shrineMessageDeserialized = (ShrineMessage)JAXBUtils.unmarshal((String)xml, (String)HiveJaxbContext.getInstance().getPackageList());
        Assert.assertEquals((Object)shrineMessage.getHeader(), (Object)shrineMessageDeserialized.getHeader());
        String origPayload = JAXBUtils.marshalToString((Element)JAXBUtils.marshalToElement((Object)shrineMessage.getPayload(), (String)HiveJaxbContext.getInstance().getPackageList()));
        String newPayload = JAXBUtils.marshalToString((Element)JAXBUtils.marshalToElement((Object)shrineMessageDeserialized.getPayload(), (String)HiveJaxbContext.getInstance().getPackageList()));
        Assert.assertEquals((String)origPayload, (String)newPayload);
    }
}

