/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.pdo.query.PatientDataResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.InstanceResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterInstanceResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PsmQryHeaderType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.Marshaller;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shrine.serializers.I2B2ExampleMessages;
import net.shrine.serializers.SerializerUnitTest;
import net.shrine.serializers.crc.CRCParsedResponse;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCRequestType;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.hive.HiveJaxbContext;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffResponseType;
import org.spin.tools.JAXBUtils;
import org.spin.tools.NetworkTime;
import org.xml.sax.InputSource;

public final class CRCSerializerTest
extends SerializerUnitTest {
    private RequestMessageType demographicsRequest;
    private ResponseMessageType demographicsResponse;
    private ResponseMessageType errorResponse;

    public void setUp() throws Exception {
        this.demographicsRequest = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_REQUEST.getRequest();
        this.demographicsResponse = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getResponse();
        this.errorResponse = I2B2ExampleMessages.CRC_DAO_EXCEPTION_RESPONSE.getResponse();
    }

    public void testRoundTrip() throws Exception {
        this.roundTrip(I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_REQUEST, RequestMessageType.class);
        this.roundTrip(I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE, ResponseMessageType.class);
        this.roundTrip(I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_REQUEST, RequestMessageType.class);
        this.roundTrip(I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_RESPONSE, ResponseMessageType.class);
        this.roundTrip(I2B2ExampleMessages.CRC_CICTR_UDAVIS_RESPONSE, ResponseMessageType.class);
    }

    static String xpath(String query, String xml) throws XPathExpressionException {
        String result = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes()));
        result = xpath.evaluate(query, inputSource);
        return result;
    }

    static <T> String partialTrip(String query, String xml, Class<T> clazz) throws Exception {
        Object type = JAXBUtils.unmarshal((String)xml, clazz);
        String roundTripped = JAXBUtils.marshalToString((Object)type);
        return CRCSerializerTest.xpath(query, roundTripped);
    }

    public void testPartialTrip() throws Exception {
        String xml = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_FEMALE_REQUEST_WITH_QUERYTOPIC.getXML();
        RequestMessageType type = (RequestMessageType)JAXBUtils.unmarshal((String)xml, RequestMessageType.class);
        String result = CRCSerializerTest.partialTrip("//queryTopicID", xml, RequestMessageType.class);
        CRCSerializerTest.assertEquals((String)"36", (String)result);
    }

    public void testQueryDefinitionAndPanels() throws Exception {
        QueryDefinitionRequestType queryDef = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)this.demographicsRequest);
        CRCSerializerTest.assertEquals((String)"one result output", (int)queryDef.getResultOutputList().getResultOutput().size(), (int)1);
        CRCSerializerTest.assertEquals((String)"single panel query", (int)queryDef.getQueryDefinition().getPanel().size(), (int)1);
        PanelType panel = (PanelType)queryDef.getQueryDefinition().getPanel().get(0);
        CRCSerializerTest.assertEquals((String)"single item in the panel", (int)1, (int)panel.getItem().size());
        CRCSerializerTest.assertEquals((String)"query for all demographics in i2b2", (String)"\\\\i2b2\\i2b2\\Demographics\\", (String)((ItemType)panel.getItem().get(0)).getItemKey());
    }

    public void testQueryMaster() throws Exception {
        MasterInstanceResultResponseType master = CRCSerializer.getQueryMaster((ResponseMessageType)this.demographicsResponse);
        CRCSerializerTest.assertEquals((String)"single node reply query master   id", (String)"3837", (String)master.getQueryMaster().getQueryMasterId());
        CRCSerializerTest.assertEquals((String)"single node reply query instance id", (String)"3837", (String)master.getQueryInstance().getQueryInstanceId());
        CRCSerializerTest.assertEquals((String)"single node reply query result   id", (String)"4952", (String)((QueryResultInstanceType)master.getQueryResultInstance().get(0)).getResultInstanceId());
    }

    public void testUpdateQueryMaster() throws Exception {
        String cannedResponse = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getXML();
        ResponseMessageType response = HiveCommonSerializer.getResponse((String)cannedResponse);
        MasterInstanceResultResponseType master = CRCSerializer.getQueryMaster((ResponseMessageType)response);
        CRCSerializer.updateMasterResultInstanceResponse((ResponseMessageType)response, (MasterInstanceResultResponseType)master);
        String updatedResponse = HiveCommonSerializer.toXMLString((ResponseMessageType)response);
        ResponseMessageType finalResponse = HiveCommonSerializer.getResponse((String)updatedResponse);
        CRCSerializer.getQueryMaster((ResponseMessageType)finalResponse);
    }

    public void testAddQueryMaster() throws Exception {
        String cannedResponse = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getXML();
        ResponseMessageType response = HiveCommonSerializer.getResponse((String)cannedResponse);
        MasterInstanceResultResponseType master = CRCSerializer.getQueryMaster((ResponseMessageType)response);
        CRCSerializer.addMasterResultInstanceResponse((ResponseMessageType)response, (MasterInstanceResultResponseType)master);
        String updatedResponse = HiveCommonSerializer.toXMLString((ResponseMessageType)response);
        ResponseMessageType finalResponse = HiveCommonSerializer.getResponse((String)updatedResponse);
        HiveCommonSerializer.getBodyNode((ResponseMessageType)response, (int)0, MasterInstanceResultResponseType.class);
        HiveCommonSerializer.getBodyNode((ResponseMessageType)response, (int)1, MasterInstanceResultResponseType.class);
    }

    public void testUpdatePatientDataResponse() throws Exception {
        String cannedResponse = I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_RESPONSE.getXML();
        ResponseMessageType response = HiveCommonSerializer.getResponse((String)cannedResponse);
        PatientDataResponseType pdrt = CRCSerializer.getPatientDataResponseType((ResponseMessageType)response);
        CRCSerializer.updatePatientDataResponse((ResponseMessageType)response, (PatientDataResponseType)pdrt);
        String updatedResponse = HiveCommonSerializer.toXMLString((ResponseMessageType)response);
        ResponseMessageType finalResponse = HiveCommonSerializer.getResponse((String)updatedResponse);
        CRCSerializer.getPatientDataResponseType((ResponseMessageType)finalResponse);
    }

    public void testAddPatientDataResponse() throws Exception {
        String cannedResponse = I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_RESPONSE.getXML();
        ResponseMessageType response = HiveCommonSerializer.getResponse((String)cannedResponse);
        PatientDataResponseType pdrt = CRCSerializer.getPatientDataResponseType((ResponseMessageType)response);
        CRCSerializer.addPatientDataResponse((ResponseMessageType)response, (PatientDataResponseType)pdrt);
        String updatedResponse = HiveCommonSerializer.toXMLString((ResponseMessageType)response);
        ResponseMessageType finalResponse = HiveCommonSerializer.getResponse((String)updatedResponse);
        HiveCommonSerializer.getBodyNode((ResponseMessageType)finalResponse, (int)0, PatientDataResponseType.class);
        HiveCommonSerializer.getBodyNode((ResponseMessageType)finalResponse, (int)1, PatientDataResponseType.class);
    }

    public void testResponseStatusCodes() throws Exception {
        CRCSerializerTest.assertEquals((Object)CRCQueryStatus.ERROR, (Object)CRCSerializer.getQueryStatus((ResponseMessageType)I2B2ExampleMessages.CRC_DAO_EXCEPTION_RESPONSE.getResponse()));
        CRCSerializerTest.assertEquals((Object)CRCQueryStatus.COMPLETED, (Object)CRCSerializer.getQueryStatus((ResponseMessageType)I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getResponse()));
    }

    public void testParseCRCResponse() throws Exception {
        ResponseMessageType expectedResponse = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getResponse();
        Marshaller m = HiveJaxbContext.getInstance().getContext().createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)expectedResponse, (Writer)sw);
        CRCParsedResponse expectedParsed = new CRCParsedResponse(sw.toString(), "COMPLETED", 82, "3837", "3837", Collections.singletonList("4952"), "Male@19:22:36", NetworkTime.makeXMLGregorianCalendar((String)"2010-02-19T14:19:31.000-05:00"));
        CRCParsedResponse parsed = CRCSerializer.getParsedResponse((ResponseMessageType)expectedResponse);
        CRCSerializerTest.assertEquals((Object)expectedParsed, (Object)parsed);
    }

    public void testGetRequestType() throws Exception {
        RequestMessageType request = I2B2ExampleMessages.CRC_QRY_GET_REQUEST_XML_FROM_QUERY_MASTER_ID.getRequest();
        CRCRequestType actual = CRCSerializer.getRequestType((RequestMessageType)request);
        CRCSerializerTest.assertEquals((Object)CRCRequestType.GetRequestXml, (Object)actual);
    }

    public void testGetHistory() throws Exception {
    }

    public void testGetSheriffResponse() throws Exception {
        ArrayList<SheriffEntry> entries = new ArrayList<SheriffEntry>();
        SheriffEntry entry1 = new SheriffEntry();
        entry1.setECommonsID("id");
        entry1.setQueryTopicID(Long.valueOf(1L));
        entries.add(entry1);
        SheriffEntry entry2 = new SheriffEntry();
        entry2.setECommonsID("id");
        entry2.setQueryTopicID(Long.valueOf(2L));
        entries.add(entry2);
        RequestMessageType request = HiveCommonSerializer.getTemplateRequestMessageType();
        SheriffResponseType sheriffResponse = new SheriffResponseType(entries);
        ResponseMessageType actualResponse = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)request);
        CRCSerializer.addSheriffResponse((ResponseMessageType)actualResponse, (SheriffResponseType)sheriffResponse);
    }

    private static final RequestMessageType makeRequestMessageType(Object payload) {
        RequestMessageType requestMessageType = HiveCommonSerializer.getTemplateRequestMessageType();
        requestMessageType.getMessageBody().getAny().add(new Object());
        requestMessageType.getMessageBody().getAny().add(payload);
        return requestMessageType;
    }

    public void testGetMasterRequest() throws Exception {
        MasterRequestType payload = new MasterRequestType();
        RequestMessageType request = CRCSerializerTest.makeRequestMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getMasterRequest((RequestMessageType)request));
    }

    public void testGetInstanceRequest() throws Exception {
        InstanceRequestType payload = new InstanceRequestType();
        RequestMessageType request = CRCSerializerTest.makeRequestMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getInstanceRequest((RequestMessageType)request));
    }

    public void testGetResultRequest() throws Exception {
        ResultRequestType payload = new ResultRequestType();
        RequestMessageType request = CRCSerializerTest.makeRequestMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getResultRequest((RequestMessageType)request));
    }

    private static final ResponseMessageType makeResponseMessageType(Object payload) {
        ResponseMessageType responseMessageType = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
        responseMessageType.getMessageBody().getAny().add(payload);
        return responseMessageType;
    }

    public void testGetMasterResponse() throws Exception {
        MasterResponseType payload = new MasterResponseType();
        ResponseMessageType response = CRCSerializerTest.makeResponseMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getMasterResponse((ResponseMessageType)response));
    }

    public void testGetInstanceResponse() throws Exception {
        InstanceResponseType payload = new InstanceResponseType();
        ResponseMessageType response = CRCSerializerTest.makeResponseMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getInstanceResponse((ResponseMessageType)response));
    }

    public void testGetResultResponse() throws Exception {
        ResultResponseType payload = new ResultResponseType();
        ResponseMessageType response = CRCSerializerTest.makeResponseMessageType(payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getResultResponse((ResponseMessageType)response));
    }

    public void testAddMasterResponse() throws Exception {
        MasterResponseType payload = new MasterResponseType();
        ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
        CRCSerializer.addMasterResponse((ResponseMessageType)response, (MasterResponseType)payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getMasterResponse((ResponseMessageType)response));
    }

    public void testAddInstanceResponse() throws Exception {
        InstanceResponseType payload = new InstanceResponseType();
        ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
        CRCSerializer.addInstanceResponse((ResponseMessageType)response, (InstanceResponseType)payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getInstanceResponse((ResponseMessageType)response));
    }

    public void testAddResultResponse() throws Exception {
        ResultResponseType payload = new ResultResponseType();
        ResponseMessageType response = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)HiveCommonSerializer.getTemplateRequestMessageType());
        CRCSerializer.addResultResponse((ResponseMessageType)response, (ResultResponseType)payload);
        CRCSerializerTest.assertSame((Object)payload, (Object)CRCSerializer.getResultResponse((ResponseMessageType)response));
    }

    public void testSetQueryTopicId() throws Exception {
        RequestMessageType request = HiveCommonSerializer.getTemplateRequestMessageType();
        PsmQryHeaderType header = new PsmQryHeaderType();
        request.getMessageBody().getAny().add(header);
        MasterRequestType master = new MasterRequestType();
        request.getMessageBody().getAny().add(master);
        long topicId = 124L;
        CRCSerializer.setQueryTopicId((RequestMessageType)request, (Long)topicId);
        String s = CRCSerializer.toXMLString((RequestMessageType)request);
        RequestMessageType actualRequest = CRCSerializer.getRequest((String)s);
        CRCSerializerTest.assertEquals((long)topicId, (long)CRCSerializer.getQueryTopicId((RequestMessageType)actualRequest));
    }

    public void testPerformance() throws Exception {
        String xml = I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_REQUEST.getXML();
        int SECOND = 1000;
        int ITER = 5000;
        long[] reads = new long[5000];
        long[] writes = new long[5000];
        for (int i = 0; i < 5000; ++i) {
            long time_start = System.currentTimeMillis();
            RequestMessageType request = CRCSerializer.getRequest((String)xml);
            long time_read = System.currentTimeMillis();
            CRCSerializer.toXMLString((RequestMessageType)request);
            long time_write = System.currentTimeMillis();
            reads[i] = time_read - time_start;
            writes[i] = time_write - time_read;
        }
        long read_total = 0L;
        long read_fastest = 500L;
        long read_slowest = 0L;
        long write_total = 0L;
        long write_fastest = 500L;
        long write_slowest = 0L;
        for (int i = 0; i < 5000; ++i) {
            read_total += reads[i];
            write_total += writes[i];
            if (reads[i] < read_fastest) {
                read_fastest = reads[i];
            }
            if (writes[i] < write_fastest) {
                write_fastest = writes[i];
            }
            if (reads[i] > read_slowest) {
                read_slowest = reads[i];
            }
            if (writes[i] <= write_slowest) continue;
            write_slowest = writes[i];
        }
        System.out.println("Serializer perf over 5000 iterations: ");
        System.out.println("Average read  time is (ms) " + (double)read_total / 5000.0);
        System.out.println("Average write time is (ms) " + (double)write_total / 5000.0);
        System.out.println("Slowest read  time is (ms) " + read_slowest);
        System.out.println("Slowest write time is (ms) " + write_slowest);
        System.out.println("Fastest read  time is (ms) " + read_fastest);
        System.out.println("Fastest write time is (ms) " + write_fastest);
    }
}

