/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import junit.framework.Assert;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.crc.QueryDefBuilder;
import org.spin.tools.SPINUnitTest;

public class QueryBuilderTest
extends SPINUnitTest {
    public void testSinglePanelWithGenderMaleORFemale() throws Exception {
        this.log.info((Object)"Male or Female should be close to 100% of the dataset. ");
        SecurityType securityType = new SecurityType("domain", "username", null);
        RequestMessageType request = QueryDefBuilder.getRequestPSM((QueryDefinitionType)QueryDefBuilder.getQueryDefinition((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderFemale(), QueryDefBuilder.getItemGenderMale()}), (SecurityType)securityType, (String)"projectId");
        String XML = CRCSerializer.toXMLString((RequestMessageType)request);
        RequestMessageType roundTripped = CRCSerializer.getRequest((String)XML);
        QueryDefinitionRequestType queryDef = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)roundTripped);
        QueryBuilderTest.assertTrue((String)"Expect a single panel ", (queryDef.getQueryDefinition().getPanel().size() == 1 ? 1 : 0) != 0);
        PanelType singlePanel = (PanelType)queryDef.getQueryDefinition().getPanel().get(0);
        QueryBuilderTest.assertTrue((String)"Expect 2 items keys ", (singlePanel.getItem().size() == 2 ? 1 : 0) != 0);
        ItemType item1 = (ItemType)singlePanel.getItem().get(0);
        ItemType item2 = (ItemType)singlePanel.getItem().get(1);
        QueryBuilderTest.assertEquals((String)"Female ", (String)QueryDefBuilder.PATH_FEMALE, (String)item1.getItemKey());
        QueryBuilderTest.assertEquals((String)"Male ", (String)QueryDefBuilder.PATH_MALE, (String)item2.getItemKey());
        System.out.println("XML " + XML);
    }

    public void testDualPanelGenderMaleAndFemale() throws Exception {
        this.log.info((Object)"Near 0 patients with both Male and Female genders");
        PanelType panelFemale = QueryDefBuilder.getPanel((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderFemale()});
        PanelType panelMale = QueryDefBuilder.getPanel((ItemType[])new ItemType[]{QueryDefBuilder.getItemGenderMale()});
        SecurityType securityType = new SecurityType("domain", "username", null);
        RequestMessageType request = QueryDefBuilder.getRequestPSM((QueryDefinitionType)QueryDefBuilder.getQueryDefinition((PanelType[])new PanelType[]{panelFemale, panelMale}), (SecurityType)securityType, (String)"projectId");
        RequestMessageType roundTripped = CRCSerializer.getRequest((String)CRCSerializer.toXMLString((RequestMessageType)request));
        QueryDefinitionRequestType queryDef = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)roundTripped);
        Assert.assertEquals((String)"Expect 2 panels ", (int)2, (int)queryDef.getQueryDefinition().getPanel().size());
        Assert.assertEquals((String)"Each panel has only one item ", (int)1, (int)((PanelType)queryDef.getQueryDefinition().getPanel().get(0)).getItem().size());
        Assert.assertEquals((String)"Each panel has only one item ", (int)1, (int)((PanelType)queryDef.getQueryDefinition().getPanel().get(1)).getItem().size());
        QueryBuilderTest.assertEquals((String)"This is the Female panel", (String)QueryDefBuilder.PATH_FEMALE, (String)((ItemType)((PanelType)queryDef.getQueryDefinition().getPanel().get(0)).getItem().get(0)).getItemKey());
        QueryBuilderTest.assertEquals((String)"This is the Male panel", (String)QueryDefBuilder.PATH_MALE, (String)((ItemType)((PanelType)queryDef.getQueryDefinition().getPanel().get(1)).getItem().get(0)).getItemKey());
    }

    public void testBuildPaths() {
        String pathNoPrefix = QueryDefBuilder.buildPath((String[])new String[]{"Diagnoses", "Complications of pregnancy, childbirth, and the puerperium"});
        String pathWithPrefix = QueryDefBuilder.buildPathWithPrefix((String)"SHRINE", (String[])new String[]{"Diagnoses", "Complications of pregnancy, childbirth, and the puerperium"});
        QueryBuilderTest.assertEquals((String)"Diagnoses\\Complications of pregnancy, childbirth, and the puerperium\\", (String)pathNoPrefix);
        QueryBuilderTest.assertEquals((String)"\\\\SHRINE\\Diagnoses\\Complications of pregnancy, childbirth, and the puerperium\\", (String)pathWithPrefix);
    }

    public void testPanelDateConstraints() throws Exception {
        String xml = CRCSerializer.toXMLString((RequestMessageType)CRCSerializer.getRequestPSM((QueryDefinitionType)QueryDefBuilder.getQueryDefinition((PanelType[])new PanelType[]{QueryDefBuilder.getPanel((int)2000, (int)2001, (ItemType[])new ItemType[]{QueryDefBuilder.getItemAge((int)30)})}), (SecurityType)new SecurityType(), null));
        System.out.println(xml);
    }
}

