/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.hive;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import java.util.HashMap;
import net.shrine.serializers.I2B2ExampleMessages;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.hive.HiveServiceFaultException;
import net.shrine.serializers.hive.MockHttpHandler;
import net.shrine.serializers.hive.MockHttpHandlerException;
import org.apache.log4j.Logger;

public class MockHttpExpectedResponseHandler
implements MockHttpHandler {
    public static Logger log = Logger.getLogger(MockHttpExpectedResponseHandler.class);
    private HashMap<String, String> messages = new HashMap();

    public MockHttpExpectedResponseHandler() throws HiveServiceFaultException {
        try {
            log.info((Object)"Round trip serializing the input messages to remove any descrepancies about requestString.equals()");
            this.messages.put(HiveCommonSerializer.toXMLString((RequestMessageType)I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_REQUEST.getRequest()), HiveCommonSerializer.toXMLString((ResponseMessageType)I2B2ExampleMessages.CRC_QUERY_FROM_DEFINITION_DEMOGRAPHICS_RESPONSE.getResponse()));
            this.messages.put(HiveCommonSerializer.toXMLString((RequestMessageType)I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_REQUEST.getRequest()), HiveCommonSerializer.toXMLString((ResponseMessageType)I2B2ExampleMessages.QUERYTOOLSERVICE_GET_PDO_FROM_INPUT_LIST_RESPONSE.getResponse()));
        }
        catch (Exception e) {
            throw new HiveServiceFaultException("Could not load example messsages", (Throwable)e);
        }
    }

    @Override
    public String handle(String httpBody) throws MockHttpHandlerException {
        log.debug((Object)"serializing (Round trip) the client request.....");
        try {
            String requestRoundTrip = HiveCommonSerializer.toXMLString((RequestMessageType)HiveCommonSerializer.getRequest((String)httpBody));
            log.debug((Object)"Bound the client request to i2b2 RequestMessageType OK. ");
            if (!httpBody.equals(requestRoundTrip)) {
                log.warn((Object)"Incomming message and round trip messages differ.");
                log.warn((Object)("Incomming = " + httpBody));
                log.warn((Object)("Round trip = " + requestRoundTrip));
            }
            if (this.messages.containsKey(requestRoundTrip)) {
                return this.messages.get(requestRoundTrip);
            }
            throw new HiveServiceFaultException("Message was round trip serialized OK but was not located in the list of saved request types.");
        }
        catch (Exception e) {
            throw new MockHttpHandlerException(e);
        }
    }
}

