/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.ont;

import edu.harvard.i2b2.crc.datavo.i2b2message.PasswordType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.i2b2message.StatusType;
import javax.xml.bind.JAXBException;
import net.shrine.serializers.ont.ONTHttpClient;
import net.shrine.serializers.ont.ONTSerializer;
import org.spin.tools.SPINUnitTest;

public abstract class ONTHttpClientTest
extends SPINUnitTest {
    private String BASE_URL = "http://services.i2b2.org/i2b2/rest/OntologyService/";
    public static final String DOMAIN = "HarvardDemo";
    public static final String USER = "demo";
    public static final String PASSWORD = "demouser";
    public static final String PROJECT = "Demo2";
    private ONTHttpClient ontClient = null;

    protected void setUp() throws Exception {
        super.setUp();
        PasswordType pwd = new PasswordType();
        pwd.setValue(PASSWORD);
        SecurityType credentials = new SecurityType(DOMAIN, USER, pwd);
        ONTSerializer serializer = new ONTSerializer(credentials, PROJECT);
        this.ontClient = new ONTHttpClient(serializer, this.BASE_URL);
    }

    public void testGetCodeInfo() throws Exception {
        ResponseMessageType response = this.ontClient.getCodeInfo("ICD9:250");
        this.validateResponse(response, "Diabetes mellitus");
    }

    public void testGetTermInfo() throws Exception {
        this.ontClient.getTermInfo(" TODO ");
    }

    private void validateResponse(ResponseMessageType response, String searchString) throws JAXBException {
        StatusType status = ONTSerializer.getResponseStatusType((ResponseMessageType)response);
        String responseXML = ONTSerializer.toXMLString((ResponseMessageType)response);
        this.log.info((Object)ONTSerializer.toXMLString((ResponseMessageType)response));
        ONTHttpClientTest.assertEquals((String)"DONE", (String)status.getType());
        ONTHttpClientTest.assertTrue((boolean)responseXML.contains(searchString));
    }
}

