/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.pm.ParamType;
import edu.harvard.i2b2.crc.datavo.pm.PasswordType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import java.util.ArrayList;
import junit.framework.Assert;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.pm.PMHttpClient;
import net.shrine.serializers.pm.PMSerializer;
import net.shrine.sheriff.SheriffAuthorizationService;
import net.shrine.sheriff.model.SheriffClientFacade;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffResponseType;
import org.easymock.EasyMock;
import org.junit.Test;

public class SheriffAuthorizationServiceTest {
    @Test
    public void testExtractEcommonsUsername() {
        String expectedEcommonsUsername = "testEcommonsName";
        UserType userType = this.createTestUserType(expectedEcommonsUsername, "ecommons_username");
        SheriffAuthorizationService service = new SheriffAuthorizationService(null, null);
        Assert.assertEquals((String)expectedEcommonsUsername, (String)PMSerializer.extractEcommonsUsername((UserType)userType));
    }

    private UserType createTestUserType(String expectedEcommonsUsername, String paramName) {
        UserType userType = new UserType();
        userType.setDomain("HarvardDemo");
        userType.setUserName("demo");
        PasswordType password = new PasswordType();
        password.setValue("demouser");
        userType.setPassword(password);
        ParamType testParam = new ParamType();
        testParam.setName(paramName);
        testParam.setValue(expectedEcommonsUsername);
        userType.getParam().add(testParam);
        return userType;
    }

    @Test
    public void testReadApprovedEntries() throws Exception {
        String ecommonsName = "ecommonsUsername";
        ArrayList<SheriffEntry> sheriffEntries = new ArrayList<SheriffEntry>();
        SheriffEntry sheriffEntry = new SheriffEntry();
        sheriffEntry.setECommonsID(ecommonsName);
        Long queryTopic1 = 1L;
        sheriffEntry.setQueryTopicID(queryTopic1);
        sheriffEntries.add(sheriffEntry);
        SheriffClientFacade mockClientFacade = (SheriffClientFacade)EasyMock.createMock(SheriffClientFacade.class);
        EasyMock.expect((Object)mockClientFacade.readApprovedEntries(ecommonsName)).andReturn(sheriffEntries);
        EasyMock.replay((Object[])new Object[]{mockClientFacade});
        UserType user = this.createTestUserType(ecommonsName, "ecommons_username");
        RequestMessageType request = CRCSerializer.getTemplateRequestMessageType();
        SecurityType securityType = new SecurityType("domain", "username", new edu.harvard.i2b2.crc.datavo.i2b2message.PasswordType());
        PMHttpClient mockPmHttpClient = (PMHttpClient)EasyMock.createMock(PMHttpClient.class);
        EasyMock.expect((Object)mockPmHttpClient.getUserConfiguration(securityType)).andReturn((Object)user);
        EasyMock.replay((Object[])new Object[]{mockPmHttpClient});
        SheriffAuthorizationService service = new SheriffAuthorizationService(mockPmHttpClient, mockClientFacade);
        request.getMessageHeader().setSecurity(securityType);
        request.getMessageHeader().setProjectId("projectName");
        ResponseMessageType response = service.readApprovedEntries(request);
        Assert.assertNotNull((Object)response);
        ResponseMessageType expectedResponse = CRCSerializer.getTemplateResponseMessageType((RequestMessageType)request);
        HiveCommonSerializer.addResponseHeaderWithDoneStatus((ResponseMessageType)expectedResponse);
        CRCSerializer.addSheriffResponse((ResponseMessageType)expectedResponse, (SheriffResponseType)new SheriffResponseType(sheriffEntries));
        Assert.assertEquals((String)CRCSerializer.toXMLString((ResponseMessageType)expectedResponse), (String)CRCSerializer.toXMLString((ResponseMessageType)response));
    }
}

