/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.translators;

import edu.harvard.i2b2.crc.datavo.i2b2message.MessageHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import net.shrine.translators.CompositeTranslator;
import net.shrine.translators.TranslationException;
import net.shrine.translators.Translator;

public final class CompositeTranslatorTest
extends TestCase {
    private final String acknowledgementType = "askdfljlaskfj";
    private final String countryCode = "aslkjflaskfjlasfjlaksjdflkasdfjlakdfj";
    private final Translator<RequestMessageType> Null = new Translator<RequestMessageType>(){

        public void translate(RequestMessageType original) throws TranslationException {
        }
    };
    private final Translator<RequestMessageType> setAcceptAcknowledgementType = new Translator<RequestMessageType>(){

        public void translate(RequestMessageType original) throws TranslationException {
            original.getMessageHeader().setAcceptAcknowledgementType("askdfljlaskfj");
        }
    };
    private final Translator<RequestMessageType> setCountryCode = new Translator<RequestMessageType>(){

        public void translate(RequestMessageType original) throws TranslationException {
            original.getMessageHeader().setCountryCode("aslkjflaskfjlasfjlaksjdflkasdfjlakdfj");
        }
    };

    public void testListConstructor() throws Exception {
        CompositeTranslator translator = CompositeTranslator.from(Arrays.asList(this.setAcceptAcknowledgementType, this.setCountryCode));
        RequestMessageType request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertEquals((String)"askdfljlaskfj", (String)request.getMessageHeader().getAcceptAcknowledgementType());
        CompositeTranslatorTest.assertEquals((String)"aslkjflaskfjlasfjlaksjdflkasdfjlakdfj", (String)request.getMessageHeader().getCountryCode());
        translator = CompositeTranslator.from(Arrays.asList(this.setAcceptAcknowledgementType, this.Null));
        request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertEquals((String)"askdfljlaskfj", (String)request.getMessageHeader().getAcceptAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator = CompositeTranslator.from(Arrays.asList(this.Null, this.setCountryCode));
        request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertEquals((String)"aslkjflaskfjlasfjlaksjdflkasdfjlakdfj", (String)request.getMessageHeader().getCountryCode());
        translator = CompositeTranslator.from(Arrays.asList(this.Null, this.Null));
        request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator = CompositeTranslator.from(Collections.emptyList());
        request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
    }

    public void testPlus() throws Exception {
        CompositeTranslator translator = CompositeTranslator.from((Translator[])new Translator[0]);
        RequestMessageType request = CompositeTranslatorTest.makeRequestMessageType();
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        translator.translate((Object)request);
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getApplicationAcknowledgementType());
        CompositeTranslatorTest.assertNull((Object)request.getMessageHeader().getCountryCode());
        CompositeTranslatorTest.assertNotSame((Object)translator, (Object)translator.plus(this.Null));
        CompositeTranslatorTest.assertNotSame((Object)translator, (Object)translator.plus(this.setAcceptAcknowledgementType));
        translator.plus(this.setAcceptAcknowledgementType).plus(this.setCountryCode).translate((Object)request);
        CompositeTranslatorTest.assertEquals((String)"askdfljlaskfj", (String)request.getMessageHeader().getAcceptAcknowledgementType());
        CompositeTranslatorTest.assertEquals((String)"aslkjflaskfjlasfjlaksjdflkasdfjlakdfj", (String)request.getMessageHeader().getCountryCode());
    }

    private static RequestMessageType makeRequestMessageType() {
        RequestMessageType request = new RequestMessageType();
        request.setMessageHeader(new MessageHeaderType());
        return request;
    }
}

