/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.filters;

import java.io.IOException;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class LogFilter
implements Filter {
    private static final Logger log = Logger.getLogger(LogFilter.class);
    public static final String GRID = "globalRequestId";
    public static final String LRID = "localRequestId";
    private static final String IS_GLOBAL_HEAD = "isGlobalHead";
    private final Random rand = new Random();
    private boolean isGlobalHead;

    public void init(FilterConfig filterConfig) throws ServletException {
        String stringGlobal = filterConfig.getInitParameter(IS_GLOBAL_HEAD);
        this.isGlobalHead = stringGlobal != null && Boolean.parseBoolean(stringGlobal);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isGlobalHead) {
            MDC.put((String)GRID, (Object)Long.toHexString(this.rand.nextLong()));
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

