/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public final class ShrineHeader {
    @XmlElement(name="request_headers", required=true)
    public final List<ShrineHeaderEntry> requestHeaders = new ArrayList<ShrineHeaderEntry>();

    public void putHeader(String k, Object v) {
        ListIterator<ShrineHeaderEntry> iter = this.requestHeaders.listIterator();
        while (iter.hasNext()) {
            ShrineHeaderEntry entry = (ShrineHeaderEntry)iter.next();
            if (!entry.key.equals(k)) continue;
            entry.value = v;
            return;
        }
        this.requestHeaders.add(new ShrineHeaderEntry<Object>(k, v));
    }

    public Object removeHeader(String k) {
        ListIterator<ShrineHeaderEntry> iter = this.requestHeaders.listIterator();
        while (iter.hasNext()) {
            ShrineHeaderEntry entry = (ShrineHeaderEntry)iter.next();
            if (!entry.key.equals(k)) continue;
            iter.remove();
            return entry.value;
        }
        return null;
    }

    public Object getHeader(String k) {
        ListIterator<ShrineHeaderEntry> iter = this.requestHeaders.listIterator();
        while (iter.hasNext()) {
            ShrineHeaderEntry entry = (ShrineHeaderEntry)iter.next();
            if (!entry.key.equals(k)) continue;
            return entry.value;
        }
        return null;
    }

    public int getSize() {
        return this.requestHeaders.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrineHeader that = (ShrineHeader)o;
        return !(this.requestHeaders != null ? !((Object)this.requestHeaders).equals(that.requestHeaders) : that.requestHeaders != null);
    }

    public int hashCode() {
        return this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0;
    }

    public String toString() {
        return "ShrineHeader{requestHeaders=" + this.requestHeaders + '}';
    }

    public static class ShrineHeaderEntry<V> {
        @XmlElement(name="key", required=true)
        private String key;
        @XmlElement(name="value", required=true)
        private V value;

        public ShrineHeaderEntry() {
        }

        public ShrineHeaderEntry(String key, V value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShrineHeaderEntry that = (ShrineHeaderEntry)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShrineHeaderEntry{key='" + this.key + '\'' + ", value=" + this.value + '}';
        }
    }
}

