/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.crc;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import net.shrine.serializers.HTTPClient;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.pm.PMInvalidLogonException;
import org.apache.log4j.Logger;
import org.spin.tools.config.ConfigException;

public final class CRCHttpClient {
    private static final Logger log = Logger.getLogger(CRCHttpClient.class);

    private CRCHttpClient() {
    }

    public static ResponseMessageType sendRequestToCRC(String url, RequestMessageType request) throws ConfigException, IOException, JAXBException, PMInvalidLogonException {
        String responseXML = HTTPClient.post(HiveCommonSerializer.toXMLString(request), url);
        log.debug((Object)responseXML);
        return HiveCommonSerializer.getResponse(responseXML);
    }

    public static ResponseMessageType getPDOFromInputList(String url, RequestMessageType request) throws IOException, ConfigException, JAXBException, PMInvalidLogonException {
        return CRCHttpClient.sendRequestToCRC(url + "pdorequest", request);
    }
}

