/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.serializers.ont;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.serializers.HTTPClient;
import net.shrine.serializers.ont.I2B2OntologyVisualAttributeTypes;
import net.shrine.serializers.ont.ONTGeneralException;
import net.shrine.serializers.ont.ONTSerializer;
import org.apache.log4j.Logger;
import org.spin.extension.JDOMTool;
import org.spin.query.message.serializer.SerializationException;

public class ONTHttpClient {
    private static final Logger log = Logger.getLogger(ONTHttpClient.class);
    private ONTSerializer serializer;
    private String baseURL;

    public ONTHttpClient(ONTSerializer serializer, String baseURL) {
        this.serializer = serializer;
        this.baseURL = baseURL;
    }

    public List<String> getCodeInfoKeys(String concept) throws SerializationException, ONTGeneralException {
        return this.xmlValues(this.getCodeInfo(concept), "//concept/key");
    }

    public ResponseMessageType getCodeInfo(String concept) throws SerializationException, ONTGeneralException {
        return this.getCodeInfo(this.serializer.getCodeInfo(concept));
    }

    public ResponseMessageType getCodeInfo(RequestMessageType request) throws SerializationException, ONTGeneralException {
        return ONTHttpClient.post(this.url(OntCommand.getCodeInfo), request);
    }

    public String getTermInfoVisualAttribute(String term) throws SerializationException, ONTGeneralException {
        List<String> values = this.xmlValues(this.getTermInfo(term), "//concept/visualattributes");
        if (values.size() != 0) {
            throw new ONTGeneralException("wrong number of visual attributes, found " + values.size());
        }
        return values.get(0);
    }

    public ResponseMessageType getTermInfo(String term) throws SerializationException, ONTGeneralException {
        return this.getTermInfo(this.serializer.getTermInfo(term));
    }

    public ResponseMessageType getTermInfo(RequestMessageType request) throws SerializationException, ONTGeneralException {
        return ONTHttpClient.post(this.url(OntCommand.getTermInfo), request);
    }

    private String url(OntCommand command) {
        return this.baseURL + command.name();
    }

    private List<String> xmlValues(ResponseMessageType response, String xpath) throws SerializationException {
        try {
            String xml = ONTSerializer.toXMLString(response);
            JDOMTool jdom = new JDOMTool(xml);
            return jdom.getElementValues(xpath);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to read response", e);
        }
    }

    public static List<String> getParentFolderPathsInKey(String itemKey) {
        return null;
    }

    public static List<String> getAllPathsInKey(String itemKey) {
        return null;
    }

    public static I2B2OntologyVisualAttributeTypes getVisualAttributeType(String term) {
        return null;
    }

    protected static ResponseMessageType post(String url, RequestMessageType request) throws ONTGeneralException, SerializationException {
        try {
            String requestXML = ONTSerializer.toXMLString(request);
            log.debug((Object)requestXML);
            String responseXML = HTTPClient.post(requestXML, url);
            ResponseMessageType response = ONTSerializer.getResponse(responseXML);
            return response;
        }
        catch (JAXBException e) {
            log.error((Object)"Could not post, XML problem? :", (Throwable)e);
            throw new SerializationException((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error((Object)"Could not post, IO problem? ", (Throwable)e);
            throw new ONTGeneralException(e);
        }
    }

    public static enum OntCommand {
        getCategories,
        getChildren,
        getSchemes,
        getNameInfo,
        getCodeInfo,
        getTermInfo;

    }
}

