/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.pm.UserType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.authorization.AuthorizationException;
import net.shrine.authorization.AuthorizationService;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.pm.PMHttpClient;
import net.shrine.serializers.pm.PMInvalidLogonException;
import net.shrine.serializers.pm.PMSerializer;
import net.shrine.sheriff.model.SheriffClientFacade;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffException;
import net.shrine.sheriff.model.SheriffResponseType;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.config.ConfigException;

public class SheriffAuthorizationService
implements AuthorizationService {
    public static final Logger log = Logger.getLogger(SheriffAuthorizationService.class);
    private PMHttpClient pmHttpClient;
    private SheriffClientFacade sheriffClientFacade;

    public SheriffAuthorizationService(PMHttpClient pmHttpClient, SheriffClientFacade sheriffClientFacade) {
        this.pmHttpClient = pmHttpClient;
        this.sheriffClientFacade = sheriffClientFacade;
    }

    @Override
    public void authorizeRequest(RequestMessageType request) throws AuthorizationException {
        try {
            List<SheriffEntry> sheriffEntries;
            Long queryTopicId = CRCSerializer.getQueryTopicId(request);
            SecurityType securityType = request.getMessageHeader().getSecurity();
            UserType userType = this.pmHttpClient.getUserConfiguration(securityType);
            String ecommonsUsername = PMSerializer.extractEcommonsUsername(userType);
            if (ecommonsUsername != null && (sheriffEntries = this.sheriffClientFacade.readApprovedEntries(ecommonsUsername)) != null) {
                for (SheriffEntry sheriffEntry : sheriffEntries) {
                    Long id = sheriffEntry.getQueryTopicID();
                    if (id == null || !id.equals(queryTopicId)) continue;
                    return;
                }
            }
            throw new AuthorizationException("Requested topic is not approved");
        }
        catch (Exception e) {
            log.debug((Object)"Exception during authorization", (Throwable)e);
            throw new AuthorizationException(e);
        }
    }

    @Override
    public ResponseMessageType readApprovedEntries(RequestMessageType request) throws SerializationException, SheriffException, JAXBException, IOException, ConfigException, PMInvalidLogonException {
        SecurityType securityType = request.getMessageHeader().getSecurity();
        UserType user = this.pmHttpClient.getUserConfiguration(securityType);
        String ecommonsUsername = PMSerializer.extractEcommonsUsername(user);
        ArrayList<SheriffEntry> sheriffEntries = new ArrayList<SheriffEntry>();
        List<SheriffEntry> approvedEntries = this.sheriffClientFacade.readApprovedEntries(ecommonsUsername);
        if (approvedEntries != null) {
            sheriffEntries.addAll(approvedEntries);
        }
        ResponseMessageType response = CRCSerializer.getTemplateResponseMessageType(request);
        CRCSerializer.addSheriffResponse(response, new SheriffResponseType(sheriffEntries));
        HiveCommonSerializer.addResponseHeaderWithDoneStatus(response);
        return response;
    }
}

