/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.translators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shrine.translators.TranslationException;
import net.shrine.translators.Translator;
import org.spin.tools.Util;

public final class CompositeTranslator<T>
implements Translator<T> {
    private final List<Translator<T>> translators;

    public CompositeTranslator(Translator<T> ... translators) {
        this(Arrays.asList(translators));
    }

    public CompositeTranslator(List<Translator<T>> translators) {
        Util.guardNotNull(translators);
        this.translators = translators;
    }

    public static <T> CompositeTranslator<T> from(Translator<T> ... translators) {
        return new CompositeTranslator<T>(translators);
    }

    public static <T> CompositeTranslator<T> from(List<Translator<T>> translators) {
        return new CompositeTranslator<T>(translators);
    }

    @Override
    public void translate(T original) throws TranslationException {
        for (Translator<T> translator : this.translators) {
            translator.translate(original);
        }
    }

    public CompositeTranslator<T> plus(Translator<T> translator) {
        Util.guardNotNull(translator);
        ArrayList newTranslators = Util.makeArrayList(this.translators);
        newTranslators.add(translator);
        return new CompositeTranslator<T>(newTranslators);
    }
}

