/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.shrine.crypto.BouncyKeyStoreCollection$;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.util.NonEmptySeq;
import net.shrine.util.NonEmptySeq$;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;

public final class CertificateCreator$ {
    public static CertificateCreator$ MODULE$;
    private final BouncyKeyStoreCollection$ bc;
    private volatile boolean bitmap$init$0;

    static {
        new CertificateCreator$();
    }

    public BouncyKeyStoreCollection$ bc() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SW2020-SNAPSHOT-JOB1/commons/crypto/src/main/scala/net/shrine/crypto/CertificateCreator.scala: 19");
        }
        return this.bc;
    }

    public KeyStoreEntry createSelfSignedCertEntry(String alias, String cn, String dc) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)this.bc().provider());
        keyPairGenerator.initialize(4096, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return this.createSignedCertEntry(alias, cn, dc, keyPair.getPrivate(), keyPair);
    }

    public KeyStoreEntry createSignedCertEntry(String alias, String cn, String dc, PrivateKey signingKey, KeyPair keyPair) {
        X500Name name = new X500Name(new StringBuilder(3).append("cn=").append(cn).toString());
        X500Name subject = new X500Name(new StringBuilder(3).append("dc=").append(dc).toString());
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        Date notBefore = new Date(0L);
        Date notAfter = new Date(System.currentTimeMillis() + 864000000L);
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded()));
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(name, serial, notBefore, notAfter, subject, subjectPublicKeyInfo);
        X509CertificateHolder certHolder = certBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(signingKey));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        return new KeyStoreEntry(cert, (NonEmptySeq<String>)new NonEmptySeq((Object)alias, (Seq)NonEmptySeq$.MODULE$.apply$default$2()), (Option<PrivateKey>)new Some((Object)keyPair.getPrivate()));
    }

    public KeyStoreEntry createSignedCertFromEntry(String alias, String cn, String dc, KeyStoreEntry signingEntry) {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return this.createSignedCertEntry(alias, cn, dc, (PrivateKey)signingEntry.privateKey().get(), keyPair);
    }

    private CertificateCreator$() {
        MODULE$ = this;
        this.bc = BouncyKeyStoreCollection$.MODULE$;
        this.bitmap$init$0 = true;
    }
}

