/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import ch.qos.logback.classic.Logger;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import net.shrine.config.package$;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreDescriptorParser$Keys$;
import net.shrine.crypto.KeyStoreType;
import net.shrine.crypto.KeyStoreType$;
import net.shrine.crypto.RemoteSiteDescriptor;
import net.shrine.log.Loggable;
import net.shrine.util.PeerToPeerModel$;
import net.shrine.util.SingleHubModel;
import net.shrine.util.TrustModel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KeyStoreDescriptorParser$
implements Loggable {
    public static KeyStoreDescriptorParser$ MODULE$;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile boolean bitmap$0;
    private volatile boolean bitmap$init$0;

    static {
        new KeyStoreDescriptorParser$();
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        KeyStoreDescriptorParser$ keyStoreDescriptorParser$ = this;
        synchronized (keyStoreDescriptorParser$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = true;
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return !this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    public KeyStoreDescriptor apply(Config keyStoreConfig, Config hubConfig, Config qepConfig) {
        TrustModel tm = this.getTrustModel$1(qepConfig, hubConfig);
        return new KeyStoreDescriptor(keyStoreConfig.getString(KeyStoreDescriptorParser$Keys$.MODULE$.file()), keyStoreConfig.getString(KeyStoreDescriptorParser$Keys$.MODULE$.password()), (Option<String>)package$.MODULE$.ConfigExtensions(keyStoreConfig).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.privateKeyAlias(), (Function1 & Serializable & scala.Serializable)x$8 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$8.getString(x$1)), (Seq<String>)KeyStoreDescriptorParser$.getCaCertAliases$1(keyStoreConfig), tm, (Seq<RemoteSiteDescriptor>)KeyStoreDescriptorParser$.getRemoteSites$1(tm, keyStoreConfig, hubConfig, qepConfig), KeyStoreDescriptorParser$.getKeyStoreType$1(keyStoreConfig));
    }

    private final TrustModel getTrustModel$1(Config qepConfig$1, Config hubConfig$1) {
        PeerToPeerModel$ peerToPeerModel$;
        if (!qepConfig$1.getBoolean(KeyStoreDescriptorParser$Keys$.MODULE$.trustModel())) {
            peerToPeerModel$ = PeerToPeerModel$.MODULE$;
        } else if (hubConfig$1.hasPath(KeyStoreDescriptorParser$Keys$.MODULE$.isHub())) {
            peerToPeerModel$ = new SingleHubModel(hubConfig$1.getBoolean(KeyStoreDescriptorParser$Keys$.MODULE$.isHub()));
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Did not specify whether this is the hub or a downStreamNode, assuming it ").append((Object)(hubConfig$1.isEmpty() ? "isn't" : "is")).append(" because the hub config is ").append((Object)(hubConfig$1.isEmpty() ? "empty" : "defined")).toString());
            peerToPeerModel$ = new SingleHubModel(!hubConfig$1.isEmpty());
        }
        return peerToPeerModel$;
    }

    private static final String parseUrl$1(String url) {
        return new URL(url).getHost();
    }

    private static final String parsePort$1(String url) {
        URL jURL = new URL(url);
        return jURL.getPort() == -1 ? ((Object)BoxesRunTime.boxToInteger((int)jURL.getDefaultPort())).toString() : ((Object)BoxesRunTime.boxToInteger((int)jURL.getPort())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Seq getRemoteSites$1(TrustModel tm$1, Config keyStoreConfig$1, Config hubConfig$1, Config qepConfig$1) {
        boolean bl = false;
        SingleHubModel singleHubModel = null;
        TrustModel trustModel = tm$1;
        if (PeerToPeerModel$.MODULE$.equals(trustModel)) {
            return KeyStoreDescriptorParser$.parseAliasMap$1(keyStoreConfig$1, hubConfig$1);
        }
        if (trustModel instanceof SingleHubModel) {
            bl = true;
            singleHubModel = (SingleHubModel)trustModel;
            boolean bl2 = singleHubModel.isCa();
            if (bl2) {
                return KeyStoreDescriptorParser$.parseRemoteSitesForHub$1(hubConfig$1);
            }
        }
        if (!bl) throw new MatchError((Object)trustModel);
        boolean bl3 = singleHubModel.isCa();
        if (false != bl3) throw new MatchError((Object)trustModel);
        return KeyStoreDescriptorParser$.parseRemoteSiteFromQep$1(qepConfig$1, keyStoreConfig$1);
    }

    public static final boolean net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(ConfigValue cv) {
        ConfigValueType configValueType = cv.valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        return !(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null);
    }

    private static final Seq getCaCertAliases$1(Config keyStoreConfig$1) {
        return (Seq)((TraversableLike)package$.MODULE$.ConfigExtensions(keyStoreConfig$1).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.caCertAliases(), (Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getList(x$1)).fold((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$2 -> JavaConverters$.MODULE$.iterableAsScalaIterable((Iterable)x$2).toList())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ConfigValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(A1) ? KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ConfigValue x1) {
                ConfigValue configValue = x1;
                boolean bl = KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$isString$1(configValue);
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq parseRemoteSitesForHub$1(Config hubConfig$1) {
        Set downStreamAliases = package$.MODULE$.ConfigExtensions(hubConfig$1).getConfigOrEmpty(KeyStoreDescriptorParser$Keys$.MODULE$.downStreamNodes()).entrySet();
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSet(downStreamAliases).map((Function1 & Serializable & scala.Serializable)entry -> {
            String url = KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1((ConfigValue)entry.getValue());
            return new RemoteSiteDescriptor((String)entry.getKey(), (Option<String>)None$.MODULE$, KeyStoreDescriptorParser$.parseUrl$1(url), KeyStoreDescriptorParser$.parsePort$1(url));
        }, Set$.MODULE$.canBuildFrom())).toList();
    }

    private static final Seq parseRemoteSiteFromQep$1(Config qepConfig$1, Config keyStoreConfig$1) {
        Seq aliases = KeyStoreDescriptorParser$.getCaCertAliases$1(keyStoreConfig$1);
        Predef$.MODULE$.assert(aliases.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "There has to be at least one caCertAlias");
        String qepUrl = qepConfig$1.getString(new StringBuilder(1).append(KeyStoreDescriptorParser$Keys$.MODULE$.qepEndpoint()).append(".").append(KeyStoreDescriptorParser$Keys$.MODULE$.url()).toString());
        RemoteSiteDescriptor remoteSiteDescriptor = new RemoteSiteDescriptor("Hub", (Option<String>)new Some(aliases.head()), KeyStoreDescriptorParser$.parseUrl$1(qepUrl), KeyStoreDescriptorParser$.parsePort$1(qepUrl));
        return (Seq)Nil$.MODULE$.$plus$colon((Object)remoteSiteDescriptor, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$apply$9(Map.Entry entry) {
        ConfigValueType configValueType = ((ConfigValue)entry.getValue()).valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        Predef$.MODULE$.assert(!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null));
    }

    public static final /* synthetic */ boolean $anonfun$apply$13(Map.Entry siteAlias$1, Map.Entry x$6) {
        return BoxesRunTime.equals(x$6.getKey(), siteAlias$1.getKey());
    }

    private static final Seq parseAliasMap$1(Config keyStoreConfig$1, Config hubConfig$1) {
        scala.collection.mutable.Set aliases = JavaConverters$.MODULE$.asScalaSet(keyStoreConfig$1.getConfig(KeyStoreDescriptorParser$Keys$.MODULE$.aliasMap()).entrySet());
        scala.collection.mutable.Set downStreamAliases = JavaConverters$.MODULE$.asScalaSet(hubConfig$1.getConfig(KeyStoreDescriptorParser$Keys$.MODULE$.downStreamNodes()).entrySet());
        Predef$.MODULE$.assert(aliases.size() == downStreamAliases.size(), (Function0 & Serializable & scala.Serializable)() -> "The aliasMap has to match one-to-one with the Hub's downstreamNodes");
        aliases.$plus$plus((GenTraversableOnce)downStreamAliases).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            KeyStoreDescriptorParser$.$anonfun$apply$9(entry);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(aliases.size() == ((TraversableOnce)((GenSetLike)aliases.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.getKey(), Set$.MODULE$.canBuildFrom())).intersect((GenSet)downStreamAliases.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.getKey(), Set$.MODULE$.canBuildFrom()))).size());
        return ((SetLike)aliases.map((Function1 & Serializable & scala.Serializable)siteAlias -> {
            String url = KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1((ConfigValue)((Map.Entry)downStreamAliases.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KeyStoreDescriptorParser$.$anonfun$apply$13(siteAlias, x$6))).get()).getValue());
            return new RemoteSiteDescriptor((String)siteAlias.getKey(), (Option<String>)new Some((Object)KeyStoreDescriptorParser$.net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1((ConfigValue)siteAlias.getValue())), KeyStoreDescriptorParser$.parseUrl$1(url), KeyStoreDescriptorParser$.parsePort$1(url));
        }, Set$.MODULE$.canBuildFrom())).toSeq();
    }

    private static final KeyStoreType getKeyStoreType$1(Config keyStoreConfig$1) {
        Option typeOption = package$.MODULE$.ConfigExtensions(keyStoreConfig$1).getOption(KeyStoreDescriptorParser$Keys$.MODULE$.keyStoreType(), (Function1 & Serializable & scala.Serializable)x$7 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$7.getString(x$1));
        return (KeyStoreType)typeOption.flatMap((Function1 & Serializable & scala.Serializable)name -> KeyStoreType$.MODULE$.valueOf((String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Unknown keystore type '").append(typeOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("', allowed types are ").append(KeyStoreType$.MODULE$.JKS().name()).append(" and ").append(KeyStoreType$.MODULE$.PKCS12().name()).toString());
            return KeyStoreType$.MODULE$.Default();
        });
    }

    public static final String net$shrine$crypto$KeyStoreDescriptorParser$$cvToString$1(ConfigValue cv) {
        return cv.unwrapped().toString();
    }

    private KeyStoreDescriptorParser$() {
        MODULE$ = this;
        Loggable.$init$((Loggable)this);
    }
}

