/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.data.client;

import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.config.Config;
import net.shrine.config.package$;
import net.shrine.http4s.client.Http4sHttpClient$;
import net.shrine.hub.data.client.CouldNotCompleteApiTaskButOKToRetryException;
import net.shrine.hub.data.client.CouldNotCompleteApiTaskButOKToRetryException$;
import net.shrine.hub.data.client.CouldNotCompleteApiTaskDoNotRetryException;
import net.shrine.hub.data.client.CouldNotCompleteApiTaskDoNotRetryException$;
import net.shrine.hub.data.client.HubClientApi;
import net.shrine.hub.data.client.HubHttpClient$;
import net.shrine.hub.data.client.HubServiceRequests$;
import net.shrine.log.Log$;
import net.shrine.protocol.version.NodeKey$;
import net.shrine.protocol.version.v1.Network;
import net.shrine.protocol.version.v1.Network$;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Node$;
import net.shrine.source.ConfigSource$;
import org.http4s.Request;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;

public final class HubHttpClient$
implements HubClientApi {
    public static final HubHttpClient$ MODULE$;
    private final String configPath;
    private final Config hubClientConfig;
    private final Duration hubClientTimeOut;
    private final Uri hubUri;
    private final Uri hubServiceUri;
    private volatile byte bitmap$init$0;

    static {
        new HubHttpClient$();
    }

    public String configPath() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.configPath;
        }
        throw new UninitializedFieldError("Uninitialized field: HubClient.scala: 41");
    }

    public Config hubClientConfig() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.hubClientConfig;
        }
        throw new UninitializedFieldError("Uninitialized field: HubClient.scala: 42");
    }

    public Duration hubClientTimeOut() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.hubClientTimeOut;
        }
        throw new UninitializedFieldError("Uninitialized field: HubClient.scala: 44");
    }

    public Uri hubUri() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.hubUri;
        }
        throw new UninitializedFieldError("Uninitialized field: HubClient.scala: 45");
    }

    public Uri hubServiceUri() {
        if ((byte)(this.bitmap$init$0 & 0x10) != 0) {
            return this.hubServiceUri;
        }
        throw new UninitializedFieldError("Uninitialized field: HubClient.scala: 46");
    }

    @Override
    public IO<String> pingHubIO() {
        Request<IO> request = HubServiceRequests$.MODULE$.pingRequest(this.hubServiceUri());
        return Http4sHttpClient$.MODULE$.webFetchAndDecodeIO(request, (Function2)new Serializable(request){
            public static final long serialVersionUID = 0L;
            public final Request request$1;

            public final IO<String> apply(Status status, String bodyString) {
                HubHttpClient$.MODULE$.checkForErrorStatus((Request<IO>)this.request$1, status, bodyString);
                Status.ResponseClass responseClass = status.responseClass();
                Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, bodyString){
                        public static final long serialVersionUID = 0L;
                        private final String bodyString$1;

                        public final String apply() {
                            return this.bodyString$1;
                        }
                        {
                            this.bodyString$1 = bodyString$1;
                        }
                    });
                }
                Log$.MODULE$.error((Function0)new Serializable(this, status, bodyString){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pingHubIO.1 $outer;
                    private final Status status$1;
                    private final String bodyString$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying ", ". HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ", "\n             |Body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.request$1, this.status$1, this.bodyString$1})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.status$1 = status$1;
                        this.bodyString$1 = bodyString$1;
                    }
                });
                throw new CouldNotCompleteApiTaskDoNotRetryException((Request<IO>)this.request$1, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    @Override
    public IO<Network> getNetworkIO() {
        Request<IO> request = HubServiceRequests$.MODULE$.getNetworkRequest(this.hubServiceUri());
        return Http4sHttpClient$.MODULE$.webFetchAndDecodeIO(request, (Function2)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$2;

            public final IO<Network> apply(Status status, String bodyString) {
                HubHttpClient$.MODULE$.checkForErrorStatus((Request<IO>)this.request$2, status, bodyString);
                Status.ResponseClass responseClass = status.responseClass();
                Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, bodyString){
                        public static final long serialVersionUID = 0L;
                        private final String bodyString$2;

                        public final Network apply() {
                            return (Network)Network$.MODULE$.tryRead(this.bodyString$2).get();
                        }
                        {
                            this.bodyString$2 = bodyString$2;
                        }
                    });
                }
                Log$.MODULE$.error((Function0)new Serializable(this, status, bodyString){
                    public static final long serialVersionUID = 0L;
                    private final Status status$2;
                    private final String bodyString$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to get the network. HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ", "\n             |Body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$2, this.bodyString$2})))).stripMargin();
                    }
                    {
                        this.status$2 = status$2;
                        this.bodyString$2 = bodyString$2;
                    }
                });
                throw new CouldNotCompleteApiTaskDoNotRetryException((Request<IO>)this.request$2, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.request$2 = request$2;
            }
        });
    }

    public IO<Network> putNetworkIO(Network network) {
        Request<IO> request = HubServiceRequests$.MODULE$.putNetworkRequest(this.hubServiceUri(), network);
        return Http4sHttpClient$.MODULE$.webFetchAndDecodeIO(request, (Function2)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$3;

            public final IO<Network> apply(Status status, String bodyString) {
                HubHttpClient$.MODULE$.checkForErrorStatus((Request<IO>)this.request$3, status, bodyString);
                Status.ResponseClass responseClass = status.responseClass();
                Status.ResponseClass responseClass2 = Status$.MODULE$.Accepted().responseClass();
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, bodyString){
                        public static final long serialVersionUID = 0L;
                        private final String bodyString$3;

                        public final Network apply() {
                            return (Network)Network$.MODULE$.tryRead(this.bodyString$3).get();
                        }
                        {
                            this.bodyString$3 = bodyString$3;
                        }
                    });
                }
                Log$.MODULE$.error((Function0)new Serializable(this, status, bodyString){
                    public static final long serialVersionUID = 0L;
                    private final Status status$3;
                    private final String bodyString$3;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to put a network, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Accepted, Actual StatusCode: ", "\n             |Body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$3, this.bodyString$3})))).stripMargin();
                    }
                    {
                        this.status$3 = status$3;
                        this.bodyString$3 = bodyString$3;
                    }
                });
                throw new CouldNotCompleteApiTaskDoNotRetryException((Request<IO>)this.request$3, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.request$3 = request$3;
            }
        });
    }

    @Override
    public IO<Node> getNodeForKeyIO(String nodeKey) {
        Request<IO> request = HubServiceRequests$.MODULE$.getNodeRequest(this.hubServiceUri(), nodeKey);
        return Http4sHttpClient$.MODULE$.webFetchAndDecodeIO(request, (Function2)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$4;

            public final IO<Node> apply(Status status, String bodyString) {
                HubHttpClient$.MODULE$.checkForErrorStatus((Request<IO>)this.request$4, status, bodyString);
                Status.ResponseClass responseClass = status.responseClass();
                Status.ResponseClass responseClass2 = Status$.MODULE$.Ok().responseClass();
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, bodyString){
                        public static final long serialVersionUID = 0L;
                        private final String bodyString$4;

                        public final Node apply() {
                            return (Node)Node$.MODULE$.tryRead(this.bodyString$4).get();
                        }
                        {
                            this.bodyString$4 = bodyString$4;
                        }
                    });
                }
                Log$.MODULE$.error((Function0)new Serializable(this, status, bodyString){
                    public static final long serialVersionUID = 0L;
                    private final Status status$4;
                    private final String bodyString$4;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to get a node, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Ok, Actual StatusCode: ", "\n             |Body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$4, this.bodyString$4})))).stripMargin();
                    }
                    {
                        this.status$4 = status$4;
                        this.bodyString$4 = bodyString$4;
                    }
                });
                throw new CouldNotCompleteApiTaskDoNotRetryException((Request<IO>)this.request$4, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.request$4 = request$4;
            }
        });
    }

    @Override
    public IO<Node> getLocalNodeIO() {
        return this.getNodeForKeyIO(NodeKey$.MODULE$.localNodeKey());
    }

    public IO<Node> putNodeIO(String username, String password, Node node) {
        Request<IO> request = HubServiceRequests$.MODULE$.putNodeRequest(this.hubServiceUri(), username, password, node);
        return Http4sHttpClient$.MODULE$.webFetchAndDecodeIO(request, (Function2)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$5;

            public final IO<Node> apply(Status status, String bodyString) {
                HubHttpClient$.MODULE$.checkForErrorStatus((Request<IO>)this.request$5, status, bodyString);
                Status.ResponseClass responseClass = status.responseClass();
                Status.ResponseClass responseClass2 = Status$.MODULE$.Accepted().responseClass();
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, bodyString){
                        public static final long serialVersionUID = 0L;
                        private final String bodyString$5;

                        public final Node apply() {
                            return (Node)Node$.MODULE$.tryRead(this.bodyString$5).get();
                        }
                        {
                            this.bodyString$5 = bodyString$5;
                        }
                    });
                }
                Log$.MODULE$.error((Function0)new Serializable(this, status, bodyString){
                    public static final long serialVersionUID = 0L;
                    private final Status status$5;
                    private final String bodyString$5;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try to put a node, HTTPResponse is a success but it does not contain an expected StatusCode\n             |Expected StatusCodes: Accepted, Actual StatusCode: ", "\n             |Body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$5, this.bodyString$5})))).stripMargin();
                    }
                    {
                        this.status$5 = status$5;
                        this.bodyString$5 = bodyString$5;
                    }
                });
                throw new CouldNotCompleteApiTaskDoNotRetryException((Request<IO>)this.request$5, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            {
                this.request$5 = request$5;
            }
        });
    }

    public Status checkForErrorStatus(Request<IO> request, Status status, String bodyString) {
        if (status.isSuccess()) {
            return status;
        }
        int n = status.code();
        switch (n) {
            default: {
                Status.ResponseClass responseClass;
                Status.ResponseClass responseClass2 = responseClass = status.responseClass();
                Status.ResponseClass responseClass3 = Status$.MODULE$.RequestTimeout().responseClass();
                if (!(responseClass2 != null ? !responseClass2.equals(responseClass3) : responseClass3 != null)) {
                    throw new CouldNotCompleteApiTaskButOKToRetryException(request, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskButOKToRetryException$.MODULE$.apply$default$4());
                }
                Status.ResponseClass responseClass4 = responseClass;
                Status.ResponseClass responseClass5 = Status$.MODULE$.NotFound().responseClass();
                if (!(responseClass4 != null ? !responseClass4.equals(responseClass5) : responseClass5 != null)) {
                    throw new CouldNotCompleteApiTaskDoNotRetryException(request, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
                }
                throw new CouldNotCompleteApiTaskDoNotRetryException(request, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskDoNotRetryException$.MODULE$.apply$default$4());
            }
            case 599: {
                throw new CouldNotCompleteApiTaskButOKToRetryException(request, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskButOKToRetryException$.MODULE$.apply$default$4());
            }
            case 598: 
        }
        throw new CouldNotCompleteApiTaskButOKToRetryException(request, (Option<Status>)new Some((Object)status), (Option<String>)new Some((Object)bodyString), CouldNotCompleteApiTaskButOKToRetryException$.MODULE$.apply$default$4());
    }

    private HubHttpClient$() {
        MODULE$ = this;
        this.configPath = "shrine.hub.client";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.hubClientConfig = ConfigSource$.MODULE$.config().getConfig(this.configPath());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.hubClientTimeOut = (Duration)package$.MODULE$.ConfigExtensions(this.hubClientConfig()).get("httpClientTimeOut", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$1) {
                return Duration$.MODULE$.apply(x$1);
            }
        });
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.hubUri = (Uri)package$.MODULE$.ConfigExtensions(this.hubClientConfig()).get("serverUrl", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Uri apply(String s) {
                return Uri$.MODULE$.unsafeFromString(s);
            }
        });
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.hubServiceUri = this.hubUri().withPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/shrine-api/hub"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hubUri().path()})));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

