/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.implicits$;
import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.http4s.catsio.IOScheduler;
import net.shrine.http4s.catsio.IOScheduler$;
import net.shrine.hub.HubDispatcher$;
import net.shrine.hub.QueryAttemptTimeToLiveExceeded;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Loggable;
import net.shrine.problem.Problem;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.version.DateStamp;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.NodeId;
import net.shrine.protocol.version.ResultStatus;
import net.shrine.protocol.version.ResultStatuses;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Result;
import net.shrine.protocol.version.v1.UpdateResult;
import net.shrine.protocol.version.v1.UpdateResultWithError;
import net.shrine.protocol.version.v1.UpdateResultWithError$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class OverdueResultsPoller$
implements Loggable {
    public static OverdueResultsPoller$ MODULE$;
    private final FiniteDuration resultsOverdueAfter;
    private final FiniteDuration overdueResultsCheckPeriod;
    private final int overdueResultsBatchSize;
    private final Timer<IO> timer;
    private final IOScheduler scheduler;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile boolean bitmap$0;
    private volatile byte bitmap$init$0;

    static {
        new OverdueResultsPoller$();
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        OverdueResultsPoller$ overdueResultsPoller$ = this;
        synchronized (overdueResultsPoller$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = true;
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return !this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    public FiniteDuration resultsOverdueAfter() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 17");
        }
        return this.resultsOverdueAfter;
    }

    public FiniteDuration overdueResultsCheckPeriod() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 19");
        }
        return this.overdueResultsCheckPeriod;
    }

    public int overdueResultsBatchSize() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 21");
        }
        return this.overdueResultsBatchSize;
    }

    public Timer<IO> timer() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 23");
        }
        return this.timer;
    }

    private IOScheduler scheduler() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 25");
        }
        return this.scheduler;
    }

    public IO<BoxedUnit> restart() {
        return this.scheduler().restart();
    }

    public IO<BoxedUnit> stop() {
        return this.scheduler().stop();
    }

    public IO<BoxedUnit> checkForOverdueResults() {
        long before = DateStamp$.MODULE$.now() - this.resultsOverdueAfter().toMillis();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Checking for overdue results - results before ").append(new DateStamp(before)).toString());
        return HubDb$.MODULE$.db().selectAllNodesIO().flatMap((Function1 & Serializable & scala.Serializable)nodes -> HubDb$.MODULE$.db().countDistinctResultIds(before).flatMap((Function1 & Serializable & scala.Serializable)resultCount -> OverdueResultsPoller$.$anonfun$checkForOverdueResults$3(before, nodes, BoxesRunTime.unboxToInt((Object)resultCount))));
    }

    public IO<Object> batchProcessResults(long before, int count, Map<NodeId, Node> nodeIdsToNodes) {
        int batchSize = this.overdueResultsBatchSize();
        IndexedSeq batches = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count / batchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)batchIO -> batchIO.flatMap((Function1 & Serializable & scala.Serializable)batch -> OverdueResultsPoller$.$anonfun$batchProcessResults$4(before, batchSize, nodeIdsToNodes, BoxesRunTime.unboxToInt((Object)batch))), IndexedSeq$.MODULE$.canBuildFrom());
        return ((IO)implicits$.MODULE$.toTraverseOps((Object)batches.toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)IO$.MODULE$.ioEffect())).flatMap((Function1 & Serializable & scala.Serializable)updateCounts -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)updateCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
    }

    public IO<Object> updateAsOverdue(Result result, Map<NodeId, Node> nodeIdsToNodes) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append(result).append(" from ").append(((Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId()))).key()).append(" is overdue").toString());
        QueryAttemptTimeToLiveExceeded problem = new QueryAttemptTimeToLiveExceeded(result.queryId(), (Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId())), this.resultsOverdueAfter());
        UpdateResultWithError overdueUpdate = UpdateResultWithError$.MODULE$.create(result.queryId(), ((Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId()))).key(), (Problem)problem, (ResultStatus)ResultStatuses.ErrorFromCrc$.MODULE$, (Option)new Some((Object)problem.summary()), UpdateResultWithError$.MODULE$.create$default$6(), UpdateResultWithError$.MODULE$.create$default$7());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Will update ").append(overdueUpdate).toString());
        return HubDispatcher$.MODULE$.updateResultIO((UpdateResult)overdueUpdate).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
    }

    public static final /* synthetic */ IO $anonfun$checkForOverdueResults$3(long before$1, Iterable nodes$1, int resultCount) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(resultCount).append(" results to examine").toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.batchProcessResults(before$1, resultCount, (Map<NodeId, Node>)((TraversableOnce)nodes$1.map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodeId(((Node)node.get()).id())), node.get()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Updated ").append(updateCount).append(" results").toString()))));
    }

    public static final /* synthetic */ int $anonfun$batchProcessResults$10(List updateCounts) {
        return BoxesRunTime.unboxToInt((Object)updateCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ IO $anonfun$batchProcessResults$4(long before$2, int batchSize$1, Map nodeIdsToNodes$1, int batch) {
        return HubDb$.MODULE$.db().selectOverdueBatchIO(before$2, batch, batchSize$1).flatMap((Function1 & Serializable & scala.Serializable)overdueResults -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("batch ").append(batch).append(" found ").append(overdueResults.size()).append(" overdue results to update").toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> ((IO)implicits$.MODULE$.toTraverseOps(overdueResults.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.updateAsOverdue((Result)x$2, (Map<NodeId, Node>)nodeIdsToNodes$1), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)IO$.MODULE$.ioEffect())).map((Function1 & Serializable & scala.Serializable)updateCounts -> BoxesRunTime.boxToInteger((int)OverdueResultsPoller$.$anonfun$batchProcessResults$10(updateCounts)))));
    }

    private OverdueResultsPoller$() {
        MODULE$ = this;
        Loggable.$init$((Loggable)this);
        this.resultsOverdueAfter = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.resultsOverdueAfter");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.overdueResultsCheckPeriod = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.overdueResultsCheckPeriod");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.overdueResultsBatchSize = ConfigSource$.MODULE$.config().getInt("shrine.hub.result.overdueResultsBatchSize");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.scheduler = IOScheduler$.MODULE$.scheduleIndefinitely(this.overdueResultsCheckPeriod(), this.overdueResultsCheckPeriod(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.checkForOverdueResults(), "OldResultsPoller", this.timer());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

