/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import com.typesafe.config.Config;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import net.shrine.hub.data.store.HubDatabaseNetworkNotFoundException;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Log$;
import net.shrine.messagequeueservice.MessageQueueService$;
import net.shrine.protocol.version.MomQueueName;
import net.shrine.protocol.version.NodeKey;
import net.shrine.protocol.version.v1.Network;
import net.shrine.protocol.version.v1.Network$;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Node$;
import net.shrine.source.ConfigSource$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;

public final class HubLifecycle$ {
    public static HubLifecycle$ MODULE$;

    static {
        new HubLifecycle$();
    }

    public IO<BoxedUnit> initHubFromConfigIfEmptyIO() {
        return HubDb$.MODULE$.db().selectTheNetworkIO().attempt().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Throwable e = (Throwable)left.value();
                if (e instanceof HubDatabaseNetworkNotFoundException) {
                    Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "No Network record found. Building one from shrine.conf");
                    Config initialConfig = ConfigSource$.MODULE$.config().getConfig("shrine.hub.ifNoNetwork");
                    Network network = Network$.MODULE$.networkFromConfig(initialConfig);
                    return HubDb$.MODULE$.db().upsertNetworkIO(network).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> HubDb$.MODULE$.db().selectAllNodesIO().map((Function1 & Serializable & scala.Serializable)x$2 -> (Iterable)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> new NodeKey(HubLifecycle$.$anonfun$initHubFromConfigIfEmptyIO$5(x$3)), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toSet())).flatMap((Function1 & Serializable & scala.Serializable)existingNodeKeys -> {
                        scala.collection.immutable.Seq nodes = Node$.MODULE$.nodesFromConfig(initialConfig);
                        Seq nodesToUpsert = (Seq)nodes.filterNot((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)existingNodeKeys.contains((Object)new NodeKey(node.key()))));
                        Seq nodeUpserts = (Seq)nodesToUpsert.map((Function1 & Serializable & scala.Serializable)node -> HubDb$.MODULE$.db().upsertNodeIO((Node)node).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> IO$.MODULE$.unit()), scala.collection.Seq$.MODULE$.canBuildFrom());
                        return (IO)nodeUpserts.foldLeft((Object)IO$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(a, b) -> a.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> b));
                    });
                }
            }
            if (bl) {
                Throwable x = (Throwable)left.value();
                throw x;
            }
            if (!(either instanceof Right)) throw new MatchError((Object)either);
            Right right = (Right)either;
            Network network = (Network)right.value();
            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append(network.networkName()).append(" record found. Starting nodes from existing record").toString()));
        });
    }

    public IO<BoxedUnit> queuesFromDatabase() {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "Start queuesFromDatabase")).flatMap((Function1 & Serializable & scala.Serializable)_ -> HubDb$.MODULE$.db().selectTheNetworkIO().attempt().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Throwable e = (Throwable)left.value();
                if (e instanceof HubDatabaseNetworkNotFoundException) {
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Throwable x = (Throwable)left.value();
                throw x;
            }
            if (!(either instanceof Right)) throw new MatchError((Object)either);
            Right right = (Right)either;
            Network n = (Network)right.value();
            return new Some((Object)new MomQueueName(n.hubQueueName()));
        }).flatMap((Function1 & Serializable & scala.Serializable)hubQueueName -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("hub queue name is ").append(hubQueueName).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> HubDb$.MODULE$.db().selectAllNodesIO().map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)x$9.map((Function1 & Serializable & scala.Serializable)x$10 -> new MomQueueName(HubLifecycle$.$anonfun$queuesFromDatabase$20(x$10)), Iterable$.MODULE$.canBuildFrom())).toList()).flatMap((Function1 & Serializable & scala.Serializable)queueNamesForNodes -> IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)queueNamesForNodes.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(hubQueueName), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toSet()).flatMap((Function1 & Serializable & scala.Serializable)neededQueues -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("neededQueues is ").append(neededQueues).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> MessageQueueService$.MODULE$.service().queuesIO().map((Function1 & Serializable & scala.Serializable)x$13 -> (scala.collection.immutable.Seq)x$13.map((Function1 & Serializable & scala.Serializable)q -> new MomQueueName(q.name()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toSet()).flatMap((Function1 & Serializable & scala.Serializable)existingQueues -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("existingQueues are ").append(existingQueues).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Set)neededQueues.$minus$minus((GenTraversableOnce)existingQueues)).flatMap((Function1 & Serializable & scala.Serializable)queuesToCreate -> IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Set)existingQueues.$minus$minus((GenTraversableOnce)neededQueues)).flatMap((Function1 & Serializable & scala.Serializable)queuesToDelete -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Create queues: ").append(queuesToCreate.mkString(",")).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> HubLifecycle$.createQueues$1(queuesToCreate).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Delete queues: ").append(queuesToDelete.mkString(",")).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> HubLifecycle$.deleteQueues$1(queuesToDelete).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "Completed queuesFromDatabase")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HubLifecycle$.$anonfun$queuesFromDatabase$50(_);
            return BoxedUnit.UNIT;
        })))))))))))))));
    }

    public static final /* synthetic */ String $anonfun$initHubFromConfigIfEmptyIO$5(Try x$3) {
        return ((Node)x$3.get()).key();
    }

    private static final IO createQueues$1(Set queues) {
        return (IO)Stream$.MODULE$.compile$extension(((Stream)((TraversableOnce)((TraversableLike)((TraversableLike)queues.toSeq().map((Function1 & Serializable & scala.Serializable)x$7 -> ((MomQueueName)x$7).underlying(), scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)queueName -> MessageQueueService$.MODULE$.service().createQueueIfAbsentIO(queueName), scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)fo -> new Stream(Stream$.MODULE$.eval((Object)fo)), scala.collection.Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Stream(Stream$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(soFar, next) -> new Stream(Stream$.MODULE$.append$extension(((Stream)soFar).fs2$Stream$$free(), (Function0 & Serializable & scala.Serializable)() -> new Stream(next))))).fs2$Stream$$free(), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioEffect())).drain();
    }

    private static final IO deleteQueues$1(Set queues) {
        return (IO)Stream$.MODULE$.compile$extension(((Stream)((TraversableOnce)((TraversableLike)((TraversableLike)queues.toSeq().map((Function1 & Serializable & scala.Serializable)x$8 -> ((MomQueueName)x$8).underlying(), scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)queueName -> MessageQueueService$.MODULE$.service().deleteQueueIO(queueName), scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)fo -> new Stream(Stream$.MODULE$.eval((Object)fo)), scala.collection.Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Stream(Stream$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(soFar, next) -> new Stream(Stream$.MODULE$.append$extension(((Stream)soFar).fs2$Stream$$free(), (Function0 & Serializable & scala.Serializable)() -> new Stream(next))))).fs2$Stream$$free(), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioEffect())).drain();
    }

    public static final /* synthetic */ String $anonfun$queuesFromDatabase$20(Try x$10) {
        return ((MomQueueName)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> new MomQueueName(x$11.momQueueName())).get()).underlying();
    }

    public static final /* synthetic */ void $anonfun$queuesFromDatabase$50(BoxedUnit _) {
    }

    private HubLifecycle$() {
        MODULE$ = this;
    }
}

