/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.implicits$;
import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.http4s.catsio.IOScheduler;
import net.shrine.http4s.catsio.IOScheduler$;
import net.shrine.hub.HubDispatcher$;
import net.shrine.hub.QueryAttemptTimeToLiveExceeded;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Loggable;
import net.shrine.problem.Problem;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.version.DateStamp;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.NodeId;
import net.shrine.protocol.version.ResultStatus;
import net.shrine.protocol.version.ResultStatuses;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Result;
import net.shrine.protocol.version.v1.UpdateResult;
import net.shrine.protocol.version.v1.UpdateResultWithError;
import net.shrine.protocol.version.v1.UpdateResultWithError$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class OverdueResultsPoller$
implements Loggable {
    public static final OverdueResultsPoller$ MODULE$ = new OverdueResultsPoller$();
    private static final FiniteDuration resultsOverdueAfter;
    private static final FiniteDuration resultsDoNotBotherAfter;
    private static final FiniteDuration overdueResultsCheckPeriod;
    private static final int overdueResultsBatchSize;
    private static final Timer<IO> timer;
    private static final IOScheduler scheduler;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
        resultsOverdueAfter = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.resultsOverdueAfter");
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        resultsDoNotBotherAfter = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.resultsDoNotBotherAfter");
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        overdueResultsCheckPeriod = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.overdueResultsCheckPeriod");
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        overdueResultsBatchSize = ConfigSource$.MODULE$.config().getInt("shrine.hub.result.overdueResultsBatchSize");
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        scheduler = IOScheduler$.MODULE$.scheduleIndefinitely(MODULE$.overdueResultsCheckPeriod(), MODULE$.overdueResultsCheckPeriod(), (Function0 & Serializable)() -> MODULE$.checkForOverdueResults(), MODULE$.getClass().getSimpleName(), MODULE$.timer());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        OverdueResultsPoller$ overdueResultsPoller$ = this;
        synchronized (overdueResultsPoller$) {
            if (!bitmap$0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = true;
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return !bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : net$shrine$log$Loggable$$internalLogger;
    }

    public FiniteDuration resultsOverdueAfter() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 17");
        }
        return resultsOverdueAfter;
    }

    public FiniteDuration resultsDoNotBotherAfter() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 19");
        }
        return resultsDoNotBotherAfter;
    }

    public FiniteDuration overdueResultsCheckPeriod() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 21");
        }
        return overdueResultsCheckPeriod;
    }

    public int overdueResultsBatchSize() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 23");
        }
        return overdueResultsBatchSize;
    }

    public Timer<IO> timer() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 25");
        }
        return timer;
    }

    private IOScheduler scheduler() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK693-JOB1/hub/service/src/main/scala/net/shrine/hub/OverdueResultsPoller.scala: 27");
        }
        return scheduler;
    }

    public IO<BoxedUnit> restart() {
        return this.scheduler().restart();
    }

    public IO<BoxedUnit> stop() {
        return this.scheduler().stop();
    }

    public IO<BoxedUnit> checkForOverdueResults() {
        long now = DateStamp$.MODULE$.now();
        long before = now - this.resultsOverdueAfter().toMillis();
        long notBefore = now - this.resultsDoNotBotherAfter().toMillis();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Checking for overdue results - results before ").append(new DateStamp(before)).append(" and not before ").append(new DateStamp(notBefore)).toString());
        return HubDb$.MODULE$.db().selectAllNodesIO().flatMap((Function1 & Serializable)nodes -> MODULE$.batchProcessResults(0, before, notBefore, (Map<NodeId, Node>)((IterableOnceOps)nodes.map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodeId(((Node)node.get()).id())), node.get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1)(JFunction1.mcVI.sp & Serializable)updateCount -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Updated ").append(updateCount).append(" results").toString()))));
    }

    private IO<Object> batchProcessResults(int batchNumber, long before, long notBefore, Map<NodeId, Node> nodeIdsToNodes) {
        return HubDb$.MODULE$.db().selectOverdueBatchIO(before, notBefore, batchNumber, this.overdueResultsBatchSize()).flatMap((Function1 & Serializable)overdueResultsAndIsLast -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("batch ").append(batchNumber).append(" found ").append(((SeqOps)overdueResultsAndIsLast._1()).size()).append(" overdue results to update. isLast? ").append(overdueResultsAndIsLast._2$mcZ$sp()).toString())).flatMap((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            IO iO = ((IO)implicits$.MODULE$.toTraverseOps((Object)((List)overdueResultsAndIsLast._1()).map((Function1 & Serializable)x$1 -> MODULE$.updateAsOverdue((Result)x$1, nodeIdsToNodes)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.ioEffect())).flatMap((Function1 & Serializable)updateCounts -> (overdueResultsAndIsLast._2$mcZ$sp() ? IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> 0) : MODULE$.batchProcessResults(batchNumber + 1, before, notBefore, nodeIdsToNodes)).map((Function1)(JFunction1.mcII.sp & Serializable)otherBatches -> BoxesRunTime.unboxToInt((Object)updateCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + otherBatches));
            return iO;
        }));
    }

    private IO<Object> updateAsOverdue(Result result, Map<NodeId, Node> nodeIdsToNodes) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append(result).append(" from ").append(((Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId()))).key()).append(" is overdue").toString());
        QueryAttemptTimeToLiveExceeded problem = new QueryAttemptTimeToLiveExceeded(result.queryId(), (Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId())), this.resultsOverdueAfter());
        UpdateResultWithError overdueUpdate = UpdateResultWithError$.MODULE$.create(result.queryId(), ((Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId()))).key(), (Problem)problem, (ResultStatus)ResultStatuses.ErrorFromCrc$.MODULE$, (Option)new Some((Object)problem.summary()), UpdateResultWithError$.MODULE$.create$default$6(), UpdateResultWithError$.MODULE$.create$default$7());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Will update ").append(overdueUpdate).toString());
        return HubDispatcher$.MODULE$.updateResultIO((UpdateResult)overdueUpdate).flatMap((Function1 & Serializable)x$3 -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
    }

    private OverdueResultsPoller$() {
    }
}

