IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'I2B2_DB_SCHEMA' AND  TABLE_NAME = 'SHRINE')
BEGIN
   DROP TABLE [I2B2_DB_SCHEMA].[SHRINE]
END

CREATE TABLE [I2B2_DB_SCHEMA].[SHRINE](
	[C_HLEVEL] [int] NOT NULL,
	[C_FULLNAME] [varchar](700) NOT NULL,
	[C_NAME] [varchar](2000) NOT NULL,
	[C_SYNONYM_CD] [char](1) NOT NULL,
	[C_VISUALATTRIBUTES] [char](3) NOT NULL,
	[C_TOTALNUM] [int] NULL,
	[C_BASECODE] [varchar](50) NULL,
	[C_METADATAXML] [text] NULL,
	[C_FACTTABLECOLUMN] [varchar](50) NOT NULL,
	[C_TABLENAME] [varchar](50) NOT NULL,
	[C_COLUMNNAME] [varchar](50) NOT NULL,
	[C_COLUMNDATATYPE] [varchar](50) NOT NULL,
	[C_OPERATOR] [varchar](10) NOT NULL,
	[C_DIMCODE] [varchar](700) NOT NULL,
	[C_COMMENT] [text] NULL,
	[C_TOOLTIP] [varchar](900) NULL,
	[M_APPLIED_PATH] [varchar](700) NOT NULL,
	[UPDATE_DATE] [datetime] NULL default current_timestamp,
	[DOWNLOAD_DATE] [datetime] NULL,
	[IMPORT_DATE] [datetime] NULL,
	[SOURCESYSTEM_CD] [varchar](50) NULL,
	[VALUETYPE_CD] [varchar](50) NULL,
	[M_EXCLUSION_CD] [varchar](25) NULL,
	[C_PATH] [varchar](700) NULL,
	[C_SYMBOL] [varchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'I2B2_DB_SCHEMA' AND  TABLE_NAME = 'TABLE_ACCESS')

BEGIN

  CREATE TABLE [I2B2_DB_SCHEMA].[TABLE_ACCESS](
  	[C_TABLE_CD] [varchar](50) NOT NULL,
  	[C_TABLE_NAME] [varchar](50) NOT NULL,
  	[C_PROTECTED_ACCESS] [char](1) NULL,
  	[C_HLEVEL] [int] NOT NULL,
  	[C_FULLNAME] [varchar](700) NOT NULL,
  	[C_NAME] [varchar](2000) NOT NULL,
  	[C_SYNONYM_CD] [char](1) NOT NULL,
  	[C_VISUALATTRIBUTES] [char](3) NOT NULL,
  	[C_TOTALNUM] [int] NULL,
  	[C_BASECODE] [varchar](50) NULL,
  	[C_METADATAXML] [text] NULL,
  	[C_FACTTABLECOLUMN] [varchar](50) NOT NULL,
  	[C_DIMTABLENAME] [varchar](50) NOT NULL,
  	[C_COLUMNNAME] [varchar](50) NOT NULL,
  	[C_COLUMNDATATYPE] [varchar](50) NOT NULL,
  	[C_OPERATOR] [varchar](10) NOT NULL,
  	[C_DIMCODE] [varchar](700) NOT NULL,
  	[C_COMMENT] [text] NULL,
  	[C_TOOLTIP] [varchar](900) NULL,
  	[C_ENTRY_DATE] [datetime] NULL,
  	[C_CHANGE_DATE] [datetime] NULL,
  	[C_STATUS_CD] [char](1) NULL,
  	[VALUETYPE_CD] [varchar](50) NULL
  ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

END




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'I2B2_DB_SCHEMA' AND  TABLE_NAME = 'SCHEMES')

BEGIN

  CREATE TABLE [I2B2_DB_SCHEMA].[SCHEMES](
  	[C_KEY] [varchar](50) NOT NULL,
  	[C_NAME] [varchar](50) NOT NULL,
  	[C_DESCRIPTION] [varchar](100) NULL,
   CONSTRAINT [SCHEMES_PK] PRIMARY KEY CLUSTERED
  (
  	[C_KEY] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
  ) ON [PRIMARY]


END
