/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class ShapeField {
    static final int BYTES = 4;
    protected static final FieldType TYPE = new FieldType();
    private static final int MINY_MINX_MAXY_MAXX_Y_X = 0;
    private static final int MINY_MINX_Y_X_MAXY_MAXX = 1;
    private static final int MAXY_MINX_Y_X_MINY_MAXX = 2;
    private static final int MAXY_MINX_MINY_MAXX_Y_X = 3;
    private static final int Y_MINX_MINY_X_MAXY_MAXX = 4;
    private static final int Y_MINX_MINY_MAXX_MAXY_X = 5;
    private static final int MAXY_MINX_MINY_X_Y_MAXX = 6;
    private static final int MINY_MINX_Y_MAXX_MAXY_X = 7;

    private ShapeField() {
    }

    public static void encodeTriangle(byte[] bytes, int aLat, int aLon, int bLat, int bLon, int cLat, int cLon) {
        int bits;
        int x2;
        int y;
        int tempY;
        int tempX;
        int cY;
        int bY;
        int aY;
        int cX;
        int bX;
        int aX;
        assert (bytes.length == 28);
        if (GeoUtils.orient(aLon, aLat, bLon, bLat, cLon, cLat) == -1) {
            aX = cLon;
            bX = bLon;
            cX = aLon;
            aY = cLat;
            bY = bLat;
            cY = aLat;
        } else {
            aX = aLon;
            bX = bLon;
            cX = cLon;
            aY = aLat;
            bY = bLat;
            cY = cLat;
        }
        if (bX < aX || cX < aX) {
            if (bX < cX) {
                tempX = aX;
                tempY = aY;
                aX = bX;
                aY = bY;
                bX = cX;
                bY = cY;
                cX = tempX;
                cY = tempY;
            } else if (cX < aX) {
                tempX = aX;
                tempY = aY;
                aX = cX;
                aY = cY;
                cX = bX;
                cY = bY;
                bX = tempX;
                bY = tempY;
            }
        } else if (aX == bX && aX == cX && (bY < aY || cY < aY)) {
            if (bY < cY) {
                tempX = aX;
                tempY = aY;
                aX = bX;
                aY = bY;
                bX = cX;
                bY = cY;
                cX = tempX;
                cY = tempY;
            } else if (cY < aY) {
                tempX = aX;
                tempY = aY;
                aX = cX;
                aY = cY;
                cX = bX;
                cY = bY;
                bX = tempX;
                bY = tempY;
            }
        }
        int minX = aX;
        int minY = StrictMath.min(aY, StrictMath.min(bY, cY));
        int maxX = StrictMath.max(aX, StrictMath.max(bX, cX));
        int maxY = StrictMath.max(aY, StrictMath.max(bY, cY));
        if (minY == aY) {
            if (maxY == bY && maxX == bX) {
                y = cY;
                x2 = cX;
                bits = 0;
            } else if (maxY == cY && maxX == cX) {
                y = bY;
                x2 = bX;
                bits = 1;
            } else {
                y = bY;
                x2 = cX;
                bits = 7;
            }
        } else if (maxY == aY) {
            if (minY == bY && maxX == bX) {
                y = cY;
                x2 = cX;
                bits = 3;
            } else if (minY == cY && maxX == cX) {
                y = bY;
                x2 = bX;
                bits = 2;
            } else {
                y = cY;
                x2 = bX;
                bits = 6;
            }
        } else if (maxX == bX && minY == bY) {
            y = aY;
            x2 = cX;
            bits = 5;
        } else if (maxX == cX && maxY == cY) {
            y = aY;
            x2 = bX;
            bits = 4;
        } else {
            throw new IllegalArgumentException("Could not encode the provided triangle");
        }
        NumericUtils.intToSortableBytes(minY, bytes, 0);
        NumericUtils.intToSortableBytes(minX, bytes, 4);
        NumericUtils.intToSortableBytes(maxY, bytes, 8);
        NumericUtils.intToSortableBytes(maxX, bytes, 12);
        NumericUtils.intToSortableBytes(y, bytes, 16);
        NumericUtils.intToSortableBytes(x2, bytes, 20);
        NumericUtils.intToSortableBytes(bits, bytes, 24);
    }

    public static void decodeTriangle(byte[] t, int[] triangle) {
        assert (triangle.length == 6);
        int bits = NumericUtils.sortableBytesToInt(t, 24);
        int tCode = 7 & bits >> 0;
        switch (tCode) {
            case 0: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 12);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 1: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 20);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 2: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 20);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 3: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 12);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 4: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 20);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 5: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 12);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            case 6: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 20);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 12);
                break;
            }
            case 7: {
                triangle[0] = NumericUtils.sortableBytesToInt(t, 0);
                triangle[1] = NumericUtils.sortableBytesToInt(t, 4);
                triangle[2] = NumericUtils.sortableBytesToInt(t, 16);
                triangle[3] = NumericUtils.sortableBytesToInt(t, 12);
                triangle[4] = NumericUtils.sortableBytesToInt(t, 8);
                triangle[5] = NumericUtils.sortableBytesToInt(t, 20);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not decode the provided triangle");
            }
        }
        assert (GeoUtils.orient(triangle[1], triangle[0], triangle[3], triangle[2], triangle[5], triangle[4]) >= 0);
    }

    static {
        TYPE.setDimensions(7, 4, 4);
        TYPE.freeze();
    }

    public static enum QueryRelation {
        INTERSECTS,
        WITHIN,
        DISJOINT;

    }

    public static class Triangle
    extends Field {
        Triangle(String name, int aXencoded, int aYencoded, int bXencoded, int bYencoded, int cXencoded, int cYencoded) {
            super(name, TYPE);
            this.setTriangleValue(aXencoded, aYencoded, bXencoded, bYencoded, cXencoded, cYencoded);
        }

        Triangle(String name, Tessellator.Triangle t) {
            super(name, TYPE);
            this.setTriangleValue(t.getEncodedX(0), t.getEncodedY(0), t.getEncodedX(1), t.getEncodedY(1), t.getEncodedX(2), t.getEncodedY(2));
        }

        protected void setTriangleValue(int aX, int aY, int bX, int bY, int cX, int cY) {
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[28];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            ShapeField.encodeTriangle(bytes, aY, aX, bY, bX, cY, cX);
        }
    }
}

