/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Foldable;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.ContextShift;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.implicits$;
import cats.kernel.Semigroup;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$PureOps$;
import fs2.internal.FreeC;
import fs2.io.file.package$;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Key$;
import io.chrisdavenport.vault.Vault;
import io.chrisdavenport.vault.Vault$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified;
import org.http4s.headers.Transfer$minusEncoding$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0$mcZ$sp;

public final class StaticFile$ {
    public static StaticFile$ MODULE$;
    private final Logger logger;
    private final int DefaultBufferSize;
    private final Key<File> staticFileKey;

    static {
        new StaticFile$();
    }

    public int DefaultBufferSize() {
        return this.DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> evidence$1, ContextShift<F> evidence$2) {
        return this.fromFile(new File(url), blockingExecutionContext, req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$3() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, ExecutionContext blockingExecutionContext, Option<Request<F>> req, boolean preferGzipped, Sync<F> evidence$3, ContextShift<F> evidence$4) {
        boolean tryGzipped = preferGzipped && req.flatMap((Function1<Request, Option> & Serializable & scala.Serializable)x$1 -> Headers$.MODULE$.get$extension0(x$1.headers(), Accept$minusEncoding$.MODULE$)).exists((Function1<Accept$minusEncoding, Object> & Serializable & scala.Serializable)acceptEncoding -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromResource$2(acceptEncoding)));
        OptionT gzUrl = tryGzipped ? new OptionT(Sync$.MODULE$.apply(evidence$3).delay((Function0<Option> & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(MODULE$.getClass().getResource(new StringBuilder(3).append(name).append(".gz").toString())))) : OptionT$.MODULE$.none(evidence$3);
        return gzUrl.flatMap((Function1<URL, OptionT> & Serializable & scala.Serializable)url -> {
            Option<Content$minusType> contentType = MODULE$.nameToContentType(name);
            Content$minusEncoding content$minusEncoding = new Content$minusEncoding(ContentCoding$.MODULE$.gzip());
            List<Content$minusEncoding> headers = contentType.toList().$colon$colon(content$minusEncoding);
            return MODULE$.fromURL((URL)url, blockingExecutionContext, req, evidence$3, evidence$4).map((Function1<Response, Response> & Serializable & scala.Serializable)x$3 -> (Response)x$3.removeHeader(Content$minusType$.MODULE$).putHeaders(headers), evidence$3);
        }, evidence$3).orElse((Function0<OptionT> & Serializable & scala.Serializable)() -> new OptionT(Sync$.MODULE$.apply(evidence$3).delay((Function0<Option> & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(MODULE$.getClass().getResource(name)))).flatMap((Function1<URL, OptionT> & Serializable & scala.Serializable)x$4 -> MODULE$.fromURL((URL)x$4, blockingExecutionContext, req, evidence$3, evidence$4), evidence$3), evidence$3);
    }

    public <F> None$ fromResource$default$3() {
        return None$.MODULE$;
    }

    public <F> boolean fromResource$default$4() {
        return false;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> F2, ContextShift<F> cs) {
        return OptionT$.MODULE$.liftF(F2.delay((Function0<Response> & Serializable & scala.Serializable)() -> {
            Response response;
            URLConnection urlConn = url.openConnection();
            Option<HttpDate> lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
            Option ifModifiedSince = req.flatMap((Function1<Request, Option> & Serializable & scala.Serializable)x$5 -> Headers$.MODULE$.get$extension0(x$5.headers(), If$minusModified$minusSince$.MODULE$));
            boolean expired = BoxesRunTime.unboxToBoolean(implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(ifModifiedSince, lastmod)).mapN((Function2<If$minusModified$minusSince, HttpDate, Object> & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromURL$3(x$6, x$7)), implicits$.MODULE$.catsStdInstancesForOption(), (Semigroupal)((Object)implicits$.MODULE$.catsStdInstancesForOption())).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> true));
            if (expired) {
                List<Header> headers;
                Content$minusLength lenHeader;
                List lastModHeader = lastmod.map((Function1<HttpDate, Last$minusModified> & Serializable & scala.Serializable)x$8 -> new Last$minusModified((HttpDate)x$8)).toList();
                List<Content$minusType> contentType = MODULE$.nameToContentType(url.getPath()).toList();
                long len = urlConn.getContentLengthLong();
                Content$minusLength content$minusLength = lenHeader = len >= 0L ? Content$minusLength$.MODULE$.unsafeFromLong(len) : Transfer$minusEncoding$.MODULE$.apply(TransferCoding$.MODULE$.chunked(), Predef$.MODULE$.wrapRefArray((Object[])new TransferCoding[0]));
                List list = lastModHeader;
                List<Header> x$1 = headers = Headers$.MODULE$.apply(contentType.$colon$colon$colon(list).$colon$colon(content$minusLength));
                FreeC<?, BoxedUnit> x$2 = fs2.io.package$.MODULE$.readInputStream(F2.delay((Function0<InputStream> & Serializable & scala.Serializable)() -> url.openStream()), MODULE$.DefaultBufferSize(), blockingExecutionContext, fs2.io.package$.MODULE$.readInputStream$default$4(), F2, cs);
                Status x$3 = Response$.MODULE$.apply$default$1();
                HttpVersion x$4 = Response$.MODULE$.apply$default$2();
                Vault x$52 = Response$.MODULE$.apply$default$5();
                response = new Response(x$3, x$4, x$1, x$2, x$52);
            } else {
                urlConn.getInputStream().close();
                response = new Response(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
            }
            return response;
        }), F2);
    }

    public <F> None$ fromURL$default$3() {
        return None$.MODULE$;
    }

    public <F> Function1<File, F> calcETag(Sync<F> evidence$5) {
        return (Function1<File, Object> & Serializable & scala.Serializable)f -> Sync$.MODULE$.apply(evidence$5).delay((Function0<String> & Serializable & scala.Serializable)() -> f.isFile() ? new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.length()))).toString() : "");
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> evidence$6, ContextShift<F> evidence$7) {
        return this.fromFile(f, this.DefaultBufferSize(), blockingExecutionContext, req, this.calcETag(evidence$6), evidence$6, evidence$7);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$8, ContextShift<F> evidence$9) {
        return this.fromFile(f, this.DefaultBufferSize(), blockingExecutionContext, req, etagCalculator, evidence$8, evidence$9);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$10, ContextShift<F> evidence$11) {
        return this.fromFile(f, 0L, f.length(), buffsize, blockingExecutionContext, req, etagCalculator, evidence$10, evidence$11);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> F2, ContextShift<F> cs) {
        return new OptionT(implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(etagCalculator.apply(f), F2).map((Function1<String, ETag> & Serializable & scala.Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F2).flatMap((Function1<ETag, Object> & Serializable & scala.Serializable)etagCalc -> F2.delay((Function0<Option> & Serializable & scala.Serializable)() -> {
            Option option;
            if (f.isFile()) {
                Predef$.MODULE$.require(start >= 0L && end >= start && buffsize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(26).append("start: ").append(start).append(", end: ").append(end).append(", buffsize: ").append(buffsize).toString());
                Option<HttpDate> lastModified = HttpDate$.MODULE$.fromEpochSecond(f.lastModified() / 1000L).toOption();
                option = MODULE$.notModified(req, (ETag)etagCalc, lastModified).orElse((Function0<Some> & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = tuple2 = f.length() < end ? new Tuple2(new Stream(Stream$PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()))), BoxesRunTime.boxToLong(0L)) : new Tuple2(new Stream(MODULE$.fileToBody(f, start, end, blockingExecutionContext, F2, cs)), BoxesRunTime.boxToLong(end - start));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    FreeC<?, BoxedUnit> body = tuple2._1().fs2$Stream$$free();
                    long contentLength = tuple2._2$mcJ$sp();
                    Tuple2 tuple23 = new Tuple2(new Stream(body), BoxesRunTime.boxToLong(contentLength));
                    Tuple2 tuple24 = tuple23;
                    FreeC<?, BoxedUnit> body2 = tuple24._1().fs2$Stream$$free();
                    long contentLength2 = tuple24._2$mcJ$sp();
                    Option<Content$minusType> contentType = MODULE$.nameToContentType(f.getName());
                    List list = lastModified.map((Function1<HttpDate, Last$minusModified> & Serializable & scala.Serializable)lm -> new Last$minusModified((HttpDate)lm)).toList();
                    List list2 = implicits$.MODULE$.toFoldableOps(Content$minusLength$.MODULE$.fromLong(contentLength2), (Foldable)((Object)implicits$.MODULE$.catsStdInstancesForEither())).toList();
                    List<Content$minusType> list3 = contentType.toList();
                    List<Header> hs = new $colon$colon<Nothing$>((Nothing$)((Object)etagCalc), Nil$.MODULE$).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
                    List<Header> x$1 = Headers$.MODULE$.apply(hs);
                    FreeC<?, BoxedUnit> x$2 = body2;
                    Vault x$3 = Vault$.MODULE$.empty().insert(MODULE$.staticFileKey(), f);
                    Status x$4 = Response$.MODULE$.apply$default$1();
                    HttpVersion x$5 = Response$.MODULE$.apply$default$2();
                    Response r = new Response(x$4, x$5, x$1, x$2, x$3);
                    if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
                        StaticFile$.MODULE$.logger.trace(new StringBuilder(32).append("Static file generated response: ").append(r).toString());
                    }
                    return new Some(r);
                });
            } else {
                option = None$.MODULE$;
            }
            return option;
        })));
    }

    public <F> None$ fromFile$default$3() {
        return None$.MODULE$;
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup<Object> conjunction = new Semigroup<Object>(){

            public double combine$mcD$sp(double x2, double y) {
                return Semigroup.combine$mcD$sp$(this, x2, y);
            }

            public float combine$mcF$sp(float x2, float y) {
                return Semigroup.combine$mcF$sp$(this, x2, y);
            }

            public int combine$mcI$sp(int x2, int y) {
                return Semigroup.combine$mcI$sp$(this, x2, y);
            }

            public long combine$mcJ$sp(long x2, long y) {
                return Semigroup.combine$mcJ$sp$(this, x2, y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$(this, a, n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$(this, a, n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$(this, a, n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$(this, a, n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$(this, a, n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$(this, a, n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$(this, a, n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$(this, a, n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$(this, a, n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$(this, a, n);
            }

            public Option<Object> combineAllOption(TraversableOnce<Object> as) {
                return Semigroup.combineAllOption$(this, as);
            }

            public boolean combine(boolean x2, boolean y) {
                return x2 && y;
            }
            {
                Semigroup.$init$(this);
            }
        };
        return implicits$.MODULE$.toFoldableOps(new $colon$colon<Nothing$>((Nothing$)((Object)this.etagMatch(req, etagCalc)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.notModifiedSince(req, lastModified)), Nil$.MODULE$)), implicits$.MODULE$.catsStdInstancesForList()).combineAll(implicits$.MODULE$.catsKernelStdMonoidForOption(conjunction)).filter((Function1<Object, Object> & Serializable & scala.Serializable)x2 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModified$1(BoxesRunTime.unboxToBoolean(x2)))).map((Function1<Object, Response> & Serializable & scala.Serializable)x$15 -> StaticFile$.$anonfun$notModified$2(BoxesRunTime.unboxToBoolean(x$15)));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1<Request, Option> & Serializable & scala.Serializable)r -> Headers$.MODULE$.get$extension0(r.headers(), If$minusNone$minusMatch$.MODULE$).map((Function1<If$minusNone$minusMatch, Object> & Serializable & scala.Serializable)etagHeader -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$2(etagCalc, etagHeader))));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1<Request, Option> & Serializable & scala.Serializable)r -> Headers$.MODULE$.get$extension0(r.headers(), If$minusModified$minusSince$.MODULE$).flatMap((Function1<If$minusModified$minusSince, Option> & Serializable & scala.Serializable)h -> lastModified.map((Function1<HttpDate, Object> & Serializable & scala.Serializable)lm -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModifiedSince$3(h, lm)))));
    }

    private <F> FreeC<?, BoxedUnit> fileToBody(File f, long start, long end, ExecutionContext blockingExecutionContext, Sync<F> evidence$12, ContextShift<F> evidence$13) {
        return package$.MODULE$.readRange(f.toPath(), blockingExecutionContext, this.DefaultBufferSize(), start, end, evidence$12, evidence$13);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        Option option;
        int n = name.lastIndexOf(46);
        switch (n) {
            case -1: {
                option = None$.MODULE$;
                break;
            }
            default: {
                option = MediaType$.MODULE$.forExtension(name.substring(n + 1)).map((Function1<MediaType, Content$minusType> & Serializable & scala.Serializable)x$22 -> Content$minusType$.MODULE$.apply((MediaType)x$22));
                break;
            }
        }
        return option;
    }

    public Key<File> staticFileKey() {
        return this.staticFileKey;
    }

    public static final /* synthetic */ boolean $anonfun$fromResource$2(Accept$minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    public static final /* synthetic */ boolean $anonfun$fromURL$3(If$minusModified$minusSince x$6, HttpDate x$7) {
        return x$6.date().$less(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$notModified$1(boolean x2) {
        return BoxesRunTime.unboxToBoolean(Predef$.MODULE$.identity(BoxesRunTime.boxToBoolean(x2)));
    }

    public static final /* synthetic */ Response $anonfun$notModified$2(boolean x$15) {
        return new Response(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$4(ETag etagCalc$2, ETag.EntityTag x$17) {
        ETag.EntityTag entityTag = x$17;
        ETag.EntityTag entityTag2 = etagCalc$2.tag();
        return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$etagMatch$2(ETag etagCalc$2, If$minusNone$minusMatch etagHeader) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean etagMatch = etagHeader.tags().exists((Function1<NonEmptyList<ETag.EntityTag>, Object>)(Function1<NonEmptyList, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.exists((Function1<ETag.EntityTag, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$4(etagCalc$2, x$17)))));
        if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
            StaticFile$.MODULE$.logger.trace(new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch).append(" Previous ETag: ").append(etagHeader.value()).append(", New ETag: ").append(etagCalc$2).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$notModifiedSince$3(If$minusModified$minusSince h$1, HttpDate lm) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean notModified = h$1.date().$greater$eq(lm);
        if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
            StaticFile$.MODULE$.logger.trace(new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified).append(". Request age: ").append(h$1.date()).append(", Modified: ").append(lm).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    private StaticFile$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger("org.http4s.StaticFile");
        this.DefaultBufferSize = 10240;
        this.staticFileKey = (Key)Key$.MODULE$.newKey(IO$.MODULE$.ioEffect()).unsafeRunSync();
    }
}

