/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import ch.qos.logback.classic.Logger;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import net.shrine.config.ConfigSource$;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.CryptoErrors$;
import net.shrine.crypto.DownStreamCertCollection;
import net.shrine.crypto.HubCertCollection;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreProblem;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreDescriptor$;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.KeyStoreFormat;
import net.shrine.crypto.RemoteSiteDescriptor;
import net.shrine.crypto.SingleHubModel;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import net.shrine.util.NonEmptySeq;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;

public final class BouncyKeyStoreCollection$
implements Loggable {
    public static final BouncyKeyStoreCollection$ MODULE$ = new BouncyKeyStoreCollection$();
    private static BouncyKeyStoreCollection fromConfig;
    private static final BouncyCastleProvider provider;
    private static Option<KeyStoreDescriptor> descriptor;
    private static Option<KeyStore> keyStore;
    private static final String SHA256;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$init$0;
    private static volatile byte bitmap$0;

    static {
        Loggable.$init$(MODULE$);
        provider = new BouncyCastleProvider();
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        Security.addProvider(MODULE$.provider());
        descriptor = None$.MODULE$;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        keyStore = None$.MODULE$;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        SHA256 = "SHA256withRSA";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    @Override
    public Logger logger() {
        return Loggable.logger$(this);
    }

    @Override
    public final boolean debugEnabled() {
        return Loggable.debugEnabled$(this);
    }

    @Override
    public final boolean infoEnabled() {
        return Loggable.infoEnabled$(this);
    }

    @Override
    public void debug(Function0<String> s2) {
        Loggable.debug$(this, s2);
    }

    @Override
    public final void debug(Function0<String> s2, Throwable e) {
        Loggable.debug$(this, s2, e);
    }

    @Override
    public void info(Function0<String> s2) {
        Loggable.info$(this, s2);
    }

    @Override
    public final void info(Function0<String> s2, Throwable e) {
        Loggable.info$(this, s2, e);
    }

    @Override
    public void warn(Function0<String> s2) {
        Loggable.warn$(this, s2);
    }

    @Override
    public final void warn(Function0<String> s2, Throwable e) {
        Loggable.warn$(this, s2, e);
    }

    @Override
    public void error(Function0<String> s2) {
        Loggable.error$(this, s2);
    }

    @Override
    public final void error(Function0<String> s2, Throwable e) {
        Loggable.error$(this, s2, e);
    }

    @Override
    public void log(RawProblem problem) {
        Loggable.log$(this, problem);
    }

    @Override
    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$(this, taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        BouncyKeyStoreCollection$ bouncyKeyStoreCollection$ = this;
        synchronized (bouncyKeyStoreCollection$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$(this);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    @Override
    public Logger net$shrine$log$Loggable$$internalLogger() {
        return (byte)(bitmap$0 & 2) == 0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : net$shrine$log$Loggable$$internalLogger;
    }

    public BouncyCastleProvider provider() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/commons/util/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 49");
        }
        return provider;
    }

    public Option<KeyStoreDescriptor> descriptor() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/commons/util/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 51");
        }
        return descriptor;
    }

    public void descriptor_$eq(Option<KeyStoreDescriptor> x$1) {
        descriptor = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public Option<KeyStore> keyStore() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/commons/util/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 52");
        }
        return keyStore;
    }

    public void keyStore_$eq(Option<KeyStore> x$1) {
        keyStore = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public String SHA256() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/commons/util/src/main/scala/net/shrine/crypto/BouncyKeyStoreCollection.scala: 53");
        }
        return SHA256;
    }

    private BouncyKeyStoreCollection fromConfig$lzycompute() {
        BouncyKeyStoreCollection$ bouncyKeyStoreCollection$ = this;
        synchronized (bouncyKeyStoreCollection$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Config shrineConfig = ConfigSource$.MODULE$.config().getConfig("shrine");
                KeyStoreDescriptor keyStoreDescriptor = KeyStoreDescriptor$.MODULE$.apply(shrineConfig.getConfig("keystore"), net.shrine.config.package$.MODULE$.ConfigExtensions(shrineConfig).getConfigOrEmpty("hub"), net.shrine.config.package$.MODULE$.ConfigExtensions(shrineConfig).getConfigOrEmpty("queryEntryPoint"));
                fromConfig = this.fromFileRecoverWithClassPath(keyStoreDescriptor);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return fromConfig;
    }

    public BouncyKeyStoreCollection fromConfig() {
        return (byte)(bitmap$0 & 1) == 0 ? this.fromConfig$lzycompute() : fromConfig;
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createCertCollection(KeyStore keyStore, KeyStoreDescriptor descriptor) {
        this.descriptor_$eq(new Some<KeyStoreDescriptor>(descriptor));
        this.keyStore_$eq(new Some<KeyStore>(keyStore));
        Iterator values2 = CollectionConverters$.MODULE$.EnumerationHasAsScala(keyStore.aliases()).asScala().map((Function1<String, Tuple3> & Serializable)alias -> new Tuple3<String, Certificate, Option<PrivateKey>>((String)alias, keyStore.getCertificate((String)alias), Option$.MODULE$.apply((PrivateKey)keyStore.getKey((String)alias, descriptor.password().toCharArray()))));
        Set<KeyStoreEntry> entries = values2.map((Function1<Tuple3, KeyStoreEntry> & Serializable)value -> new KeyStoreEntry((X509Certificate)value._2(), new NonEmptySeq<Nothing$>((Nothing$)value._1(), package$.MODULE$.Nil()), (Option)value._3())).toSet();
        Serializable serializable = entries.exists((Function1<KeyStoreEntry, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isExpired(x$1.isExpired$default$1()))) ? CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.ExpiredCertificates((Iterable)entries.filter((Function1<KeyStoreEntry, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isExpired(x$2.isExpired$default$1()))))) : BoxedUnit.UNIT;
        return this.createCentralCertCollection(entries, descriptor, descriptor.trustModel().isCa());
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createCentralCertCollection(Set<KeyStoreEntry> entries, KeyStoreDescriptor descriptor, boolean isHub) {
        Option hubEntryOption = entries.find((Function1<KeyStoreEntry, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createCentralCertCollection$1(descriptor, e)));
        return (Either)hubEntryOption.fold((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError("You must specify at least one ca cert alias corresponding to a PrivateKey entry for the Hub")), (Function1<KeyStoreEntry, Either> & Serializable)hub -> {
            Option signingEntry = entries.find((Function1<KeyStoreEntry, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(BouncyKeyStoreCollection$.$anonfun$createCentralCertCollection$4(hub, e)));
            return (Either)signingEntry.fold((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(CryptoErrors$.MODULE$.configureError("There is no private entry signed by a public entry in the keystore corresponding to the Hub.")), (Function1<KeyStoreEntry, Either> & Serializable)signing -> isHub ? package$.MODULE$.Right().apply(new HubCertCollection((KeyStoreEntry)signing, (KeyStoreEntry)hub)) : package$.MODULE$.Right().apply(new DownStreamCertCollection((KeyStoreEntry)signing, (KeyStoreEntry)hub)));
        });
    }

    public BouncyKeyStoreCollection fromFileRecoverWithClassPath(KeyStoreDescriptor descriptor) {
        KeyStore keyStore = new File(descriptor.file()).exists() ? this.fromStreamHelper(descriptor, (Function1<String, InputStream>)(Function1<String, FileInputStream> & Serializable)x$3 -> new FileInputStream((String)x$3)) : this.fromStreamHelper(descriptor, (Function1<String, InputStream> & Serializable)x$4 -> MODULE$.getClass().getClassLoader().getResourceAsStream((String)x$4));
        this.keyStore_$eq(new Some<KeyStore>(keyStore));
        this.descriptor_$eq(new Some<KeyStoreDescriptor>(descriptor));
        return (BouncyKeyStoreCollection)this.createCertCollection(keyStore, descriptor).fold((Function1<ImproperlyConfiguredKeyStoreProblem, Nothing$> & Serializable)problem -> {
            throw problem.throwable().get();
        }, (Function1<BouncyKeyStoreCollection, BouncyKeyStoreCollection> & Serializable)x2 -> Predef$.MODULE$.identity(x2));
    }

    public KeyStore fromStreamHelper(KeyStoreDescriptor descriptor, Function1<String, InputStream> streamFrom) {
        this.debug((Function0<String> & Serializable)() -> new StringBuilder(35).append("Loading keystore using descriptor: ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).toString());
        InputStream stream = streamFrom.apply(descriptor.file());
        Predef$.MODULE$.require(stream != null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(28).append("null stream for descriptor ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).append("\u00ac").toString());
        KeyStore keystore = KeyStore.getInstance(descriptor.keyStoreFormat().name());
        try {
            keystore.load(stream, descriptor.password().toCharArray());
        }
        catch (IOException x2) {
            throw new IOException(new StringBuilder(29).append("Unable to load keystore from ").append(descriptor).toString(), x2);
        }
        this.debug((Function0<String> & Serializable)() -> new StringBuilder(18).append("Keystore aliases: ").append(CollectionConverters$.MODULE$.EnumerationHasAsScala(keystore.aliases()).asScala().mkString(",")).toString());
        this.debug((Function0<String> & Serializable)() -> new StringBuilder(29).append("Keystore ").append(BouncyKeyStoreCollection$.toString$1(descriptor)).append(" loaded successfully").toString());
        return keystore;
    }

    public static final /* synthetic */ boolean $anonfun$createCentralCertCollection$1(KeyStoreDescriptor descriptor$2, KeyStoreEntry e) {
        return e.privateKey().isEmpty() && ((IterableOnceOps)e.aliases().intersect(descriptor$2.caCertAliases())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createCentralCertCollection$4(KeyStoreEntry hub$1, KeyStoreEntry e) {
        return e.privateKey().isDefined() && e.wasSignedBy(hub$1);
    }

    private static final String toString$1(KeyStoreDescriptor descriptor) {
        String x$1 = "********";
        String x$2 = descriptor.copy$default$1();
        Option<String> x$3 = descriptor.copy$default$3();
        Seq<String> x$4 = descriptor.copy$default$4();
        SingleHubModel x$5 = descriptor.copy$default$5();
        Seq<RemoteSiteDescriptor> x$6 = descriptor.copy$default$6();
        KeyStoreFormat x$7 = descriptor.copy$default$7();
        return descriptor.copy(x$2, "********", x$3, x$4, x$5, x$6, x$7).toString();
    }

    private BouncyKeyStoreCollection$() {
    }
}

