/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.shrine.crypto.BouncyKeyStoreCollection$;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.SelectAll$;
import net.shrine.util.NonEmptySeq;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Store;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;

public final class KeyStoreEntry$
implements Serializable {
    public static final KeyStoreEntry$ MODULE$ = new KeyStoreEntry$();

    public Option<X509CertificateHolder> extractCertHolder(CMSSignedData signedData) {
        Store<X509CertificateHolder> store = signedData.getCertificates();
        Collection<X509CertificateHolder> certCollection = store.getMatches(SelectAll$.MODULE$);
        return CollectionConverters$.MODULE$.IterableHasAsScala(certCollection).asScala().headOption();
    }

    public Option<String> getCommonNameFromCert(X509CertificateHolder certHolder) {
        return ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps(certHolder.getSubject().getRDNs(BCStyle.CN))).flatMap((Function1<RDN, Option> & Serializable)rdn -> Option$.MODULE$.apply(rdn.getFirst()).map((Function1<AttributeTypeAndValue, String> & Serializable)cn -> IETFUtils.valueToString(cn.getValue())));
    }

    public Option<String> extractCommonName(byte[] signedBytes) {
        CMSSignedData signedData = new CMSSignedData(signedBytes);
        return this.extractCertHolder(signedData).flatMap((Function1<X509CertificateHolder, Option> & Serializable)certHolder -> MODULE$.getCommonNameFromCert((X509CertificateHolder)certHolder).map((Function1<String, String> & Serializable)commonName -> commonName));
    }

    public X509Certificate extractX509Cert(X509CertificateHolder certificateHolder) {
        return new JcaX509CertificateConverter().setProvider(BouncyKeyStoreCollection$.MODULE$.provider()).getCertificate(certificateHolder);
    }

    public boolean certSignedOtherCert(X509CertificateHolder signer, X509CertificateHolder signee) {
        return signee.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(BouncyKeyStoreCollection$.MODULE$.provider()).build(signer));
    }

    public KeyStoreEntry apply(X509Certificate cert, NonEmptySeq<String> aliases, Option<PrivateKey> privateKey) {
        return new KeyStoreEntry(cert, aliases, privateKey);
    }

    public Option<Tuple3<X509Certificate, NonEmptySeq<String>, Option<PrivateKey>>> unapply(KeyStoreEntry x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<X509Certificate, NonEmptySeq<String>, Option<PrivateKey>>>(new Tuple3<X509Certificate, NonEmptySeq<String>, Option<PrivateKey>>(x$0.cert(), x$0.aliases(), x$0.privateKey()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KeyStoreEntry$.class);
    }

    private KeyStoreEntry$() {
    }
}

